/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.AtomicDoubleArray;
import com.google.common.util.concurrent.JSR166TestCase;
import java.util.Arrays;
import junit.framework.Assert;

public class AtomicDoubleArrayTest
extends JSR166TestCase {
    private static final double[] VALUES = new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -9.223372036854776E18, -2.147483648E9, -Math.PI, -1.0, -4.9E-324, -0.0, 0.0, Double.MIN_VALUE, 1.0, Math.PI, 2.147483647E9, 9.223372036854776E18, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NaN, 3.4028234663852886E38};
    static final long COUNTDOWN = 100000L;

    static boolean bitEquals(double x, double y) {
        return Double.doubleToRawLongBits(x) == Double.doubleToRawLongBits(y);
    }

    static void assertBitEquals(double x, double y) {
        AtomicDoubleArrayTest.assertEquals((long)Double.doubleToRawLongBits(x), (long)Double.doubleToRawLongBits(y));
    }

    public void testConstructor() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i = 0; i < 20; ++i) {
            AtomicDoubleArrayTest.assertBitEquals(0.0, aa.get(i));
        }
    }

    public void testConstructor2NPE() {
        try {
            double[] a = null;
            AtomicDoubleArray aa = new AtomicDoubleArray(a);
            this.shouldThrow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructor2() {
        AtomicDoubleArray aa = new AtomicDoubleArray(VALUES);
        AtomicDoubleArrayTest.assertEquals((int)VALUES.length, (int)aa.length());
        for (int i = 0; i < VALUES.length; ++i) {
            AtomicDoubleArrayTest.assertBitEquals(VALUES[i], aa.get(i));
        }
    }

    public void testConstructorEmptyArray() {
        AtomicDoubleArray aa = new AtomicDoubleArray(new double[0]);
        AtomicDoubleArrayTest.assertEquals((int)0, (int)aa.length());
        try {
            aa.get(0);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testConstructorZeroLength() {
        AtomicDoubleArray aa = new AtomicDoubleArray(0);
        AtomicDoubleArrayTest.assertEquals((int)0, (int)aa.length());
        try {
            aa.get(0);
            this.shouldThrow();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testIndexing() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int index : new int[]{-1, 20}) {
            try {
                aa.get(index);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
            try {
                aa.set(index, 1.0);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
            try {
                aa.lazySet(index, 1.0);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
            try {
                aa.compareAndSet(index, 1.0, 2.0);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
            try {
                aa.weakCompareAndSet(index, 1.0, 2.0);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
            try {
                aa.getAndAdd(index, 1.0);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
            try {
                aa.addAndGet(index, 1.0);
                this.shouldThrow();
            }
            catch (IndexOutOfBoundsException success) {
                // empty catch block
            }
        }
    }

    public void testGetSet() {
        AtomicDoubleArray aa = new AtomicDoubleArray(VALUES.length);
        for (int i = 0; i < VALUES.length; ++i) {
            AtomicDoubleArrayTest.assertBitEquals(0.0, aa.get(i));
            aa.set(i, VALUES[i]);
            AtomicDoubleArrayTest.assertBitEquals(VALUES[i], aa.get(i));
            aa.set(i, -3.0);
            AtomicDoubleArrayTest.assertBitEquals(-3.0, aa.get(i));
        }
    }

    public void testGetLazySet() {
        AtomicDoubleArray aa = new AtomicDoubleArray(VALUES.length);
        for (int i = 0; i < VALUES.length; ++i) {
            AtomicDoubleArrayTest.assertBitEquals(0.0, aa.get(i));
            aa.lazySet(i, VALUES[i]);
            AtomicDoubleArrayTest.assertBitEquals(VALUES[i], aa.get(i));
            aa.lazySet(i, -3.0);
            AtomicDoubleArrayTest.assertBitEquals(-3.0, aa.get(i));
        }
    }

    public void testCompareAndSet() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i : new int[]{0, 19}) {
            double prev = 0.0;
            double unused = 5.859874482048838;
            for (double x : VALUES) {
                AtomicDoubleArrayTest.assertBitEquals(prev, aa.get(i));
                AtomicDoubleArrayTest.assertFalse((boolean)aa.compareAndSet(i, unused, x));
                AtomicDoubleArrayTest.assertBitEquals(prev, aa.get(i));
                AtomicDoubleArrayTest.assertTrue((boolean)aa.compareAndSet(i, prev, x));
                AtomicDoubleArrayTest.assertBitEquals(x, aa.get(i));
                prev = x;
            }
        }
    }

    public void testCompareAndSetInMultipleThreads() throws InterruptedException {
        final AtomicDoubleArray a = new AtomicDoubleArray(1);
        a.set(0, 1.0);
        Thread t = this.newStartedThread(new JSR166TestCase.CheckedRunnable(){

            @Override
            public void realRun() {
                while (!a.compareAndSet(0, 2.0, 3.0)) {
                    Thread.yield();
                }
            }
        });
        AtomicDoubleArrayTest.assertTrue((boolean)a.compareAndSet(0, 1.0, 2.0));
        this.awaitTermination(t);
        AtomicDoubleArrayTest.assertBitEquals(3.0, a.get(0));
    }

    public void testWeakCompareAndSet() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i : new int[]{0, 19}) {
            double prev = 0.0;
            double unused = 5.859874482048838;
            for (double x : VALUES) {
                AtomicDoubleArrayTest.assertBitEquals(prev, aa.get(i));
                AtomicDoubleArrayTest.assertFalse((boolean)aa.weakCompareAndSet(i, unused, x));
                AtomicDoubleArrayTest.assertBitEquals(prev, aa.get(i));
                while (!aa.weakCompareAndSet(i, prev, x)) {
                }
                AtomicDoubleArrayTest.assertBitEquals(x, aa.get(i));
                prev = x;
            }
        }
    }

    public void testGetAndSet() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i : new int[]{0, 19}) {
            double prev = 0.0;
            for (double x : VALUES) {
                AtomicDoubleArrayTest.assertBitEquals(prev, aa.getAndSet(i, x));
                prev = x;
            }
        }
    }

    public void testGetAndAdd() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i : new int[]{0, 19}) {
            for (double x : VALUES) {
                for (double y : VALUES) {
                    aa.set(i, x);
                    double z = aa.getAndAdd(i, y);
                    AtomicDoubleArrayTest.assertBitEquals(x, z);
                    AtomicDoubleArrayTest.assertBitEquals(x + y, aa.get(i));
                }
            }
        }
    }

    public void testAddAndGet() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i : new int[]{0, 19}) {
            for (double x : VALUES) {
                for (double y : VALUES) {
                    aa.set(i, x);
                    double z = aa.addAndGet(i, y);
                    AtomicDoubleArrayTest.assertBitEquals(x + y, z);
                    AtomicDoubleArrayTest.assertBitEquals(x + y, aa.get(i));
                }
            }
        }
    }

    public void testCountingInMultipleThreads() throws InterruptedException {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i = 0; i < 20; ++i) {
            aa.set(i, 100000.0);
        }
        Counter c1 = new Counter(aa);
        Counter c2 = new Counter(aa);
        Thread t1 = this.newStartedThread(c1);
        Thread t2 = this.newStartedThread(c2);
        this.awaitTermination(t1);
        this.awaitTermination(t2);
        AtomicDoubleArrayTest.assertEquals((long)(c1.counts + c2.counts), (long)2000000L);
    }

    public void testSerialization() throws Exception {
        AtomicDoubleArray x = new AtomicDoubleArray(20);
        for (int i = 0; i < 20; ++i) {
            x.set(i, (double)(-i));
        }
        AtomicDoubleArray y = this.serialClone(x);
        AtomicDoubleArrayTest.assertTrue((x != y ? 1 : 0) != 0);
        AtomicDoubleArrayTest.assertEquals((int)x.length(), (int)y.length());
        for (int i = 0; i < 20; ++i) {
            AtomicDoubleArrayTest.assertBitEquals(x.get(i), y.get(i));
        }
        AtomicDoubleArray a = new AtomicDoubleArray(VALUES);
        AtomicDoubleArray b = this.serialClone(a);
        AtomicDoubleArrayTest.assertFalse((boolean)a.equals(b));
        AtomicDoubleArrayTest.assertFalse((boolean)b.equals(a));
        AtomicDoubleArrayTest.assertEquals((int)a.length(), (int)b.length());
        for (int i = 0; i < VALUES.length; ++i) {
            AtomicDoubleArrayTest.assertBitEquals(a.get(i), b.get(i));
        }
    }

    public void testToString() {
        AtomicDoubleArray aa = new AtomicDoubleArray(VALUES);
        AtomicDoubleArrayTest.assertEquals((String)Arrays.toString(VALUES), (String)aa.toString());
        AtomicDoubleArrayTest.assertEquals((String)"[]", (String)new AtomicDoubleArray(0).toString());
        AtomicDoubleArrayTest.assertEquals((String)"[]", (String)new AtomicDoubleArray(new double[0]).toString());
    }

    public void testDistinctZeros() {
        AtomicDoubleArray aa = new AtomicDoubleArray(20);
        for (int i : new int[]{0, 19}) {
            AtomicDoubleArrayTest.assertFalse((boolean)aa.compareAndSet(i, -0.0, 7.0));
            AtomicDoubleArrayTest.assertFalse((boolean)aa.weakCompareAndSet(i, -0.0, 7.0));
            AtomicDoubleArrayTest.assertBitEquals(0.0, aa.get(i));
            AtomicDoubleArrayTest.assertTrue((boolean)aa.compareAndSet(i, 0.0, -0.0));
            AtomicDoubleArrayTest.assertBitEquals(-0.0, aa.get(i));
            AtomicDoubleArrayTest.assertFalse((boolean)aa.compareAndSet(i, 0.0, 7.0));
            AtomicDoubleArrayTest.assertFalse((boolean)aa.weakCompareAndSet(i, 0.0, 7.0));
            AtomicDoubleArrayTest.assertBitEquals(-0.0, aa.get(i));
        }
    }

    class Counter
    extends JSR166TestCase.CheckedRunnable {
        final AtomicDoubleArray aa;
        volatile long counts;

        Counter(AtomicDoubleArray a) {
            this.aa = a;
        }

        @Override
        public void realRun() {
            boolean done;
            do {
                done = true;
                for (int i = 0; i < this.aa.length(); ++i) {
                    double v = this.aa.get(i);
                    Assert.assertTrue((v >= 0.0 ? 1 : 0) != 0);
                    if (v == 0.0) continue;
                    done = false;
                    if (!this.aa.compareAndSet(i, v, v - 1.0)) continue;
                    ++this.counts;
                }
            } while (!done);
        }
    }
}

