/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Callables;
import java.security.Permission;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CallablesTest
extends TestCase {
    public void testReturning() throws Exception {
        CallablesTest.assertNull(Callables.returning(null).call());
        Object value = new Object();
        Callable callable = Callables.returning((Object)value);
        CallablesTest.assertSame((Object)value, callable.call());
        CallablesTest.assertSame((Object)value, callable.call());
    }

    @GwtIncompatible(value="threads")
    public void testRenaming() throws Exception {
        String oldName = Thread.currentThread().getName();
        final Supplier newName = Suppliers.ofInstance((Object)"MyCrazyThreadName");
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((String)Thread.currentThread().getName(), (String)((String)newName.get()));
                return null;
            }
        };
        Callables.threadRenaming((Callable)callable, (Supplier)newName).call();
        CallablesTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
    }

    @GwtIncompatible(value="threads")
    public void testRenaming_exceptionalReturn() throws Exception {
        class MyException
        extends Exception {
            MyException() {
            }
        }
        String oldName = Thread.currentThread().getName();
        final Supplier newName = Suppliers.ofInstance((Object)"MyCrazyThreadName");
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Assert.assertEquals((String)Thread.currentThread().getName(), (String)((String)newName.get()));
                throw new MyException();
            }
        };
        try {
            Callables.threadRenaming((Callable)callable, (Supplier)newName).call();
            CallablesTest.fail();
        }
        catch (MyException expected) {
            // empty catch block
        }
        CallablesTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GwtIncompatible(value="threads")
    public void testRenaming_noPermissions() throws Exception {
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkAccess(Thread t) {
                throw new SecurityException();
            }

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        try {
            final String oldName = Thread.currentThread().getName();
            Supplier newName = Suppliers.ofInstance((Object)"MyCrazyThreadName");
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Assert.assertEquals((String)Thread.currentThread().getName(), (String)oldName);
                    return null;
                }
            };
            Callables.threadRenaming((Callable)callable, (Supplier)newName).call();
            CallablesTest.assertEquals((String)oldName, (String)Thread.currentThread().getName());
        }
        finally {
            System.setSecurityManager(null);
        }
    }
}

