/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.util.concurrent.CycleDetectingLockFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CycleDetectingLockFactoryBenchmark {
    @Param(value={"2", "3", "4", "5", "10"})
    int lockNestingDepth;
    CycleDetectingLockFactory factory;
    private Lock[] plainLocks;
    private Lock[] detectingLocks;

    @BeforeExperiment
    void setUp() throws Exception {
        int i;
        this.factory = CycleDetectingLockFactory.newInstance((CycleDetectingLockFactory.Policy)CycleDetectingLockFactory.Policies.WARN);
        this.plainLocks = new Lock[this.lockNestingDepth];
        for (i = 0; i < this.lockNestingDepth; ++i) {
            this.plainLocks[i] = new ReentrantLock();
        }
        this.detectingLocks = new Lock[this.lockNestingDepth];
        for (i = 0; i < this.lockNestingDepth; ++i) {
            this.detectingLocks[i] = this.factory.newReentrantLock("Lock" + i);
        }
    }

    @Benchmark
    void unorderedPlainLocks(int reps) {
        this.lockAndUnlock(new ReentrantLock(), reps);
    }

    @Benchmark
    void unorderedCycleDetectingLocks(int reps) {
        this.lockAndUnlock(this.factory.newReentrantLock("foo"), reps);
    }

    private void lockAndUnlock(Lock lock, int reps) {
        for (int i = 0; i < reps; ++i) {
            lock.lock();
            lock.unlock();
        }
    }

    @Benchmark
    void orderedPlainLocks(int reps) {
        this.lockAndUnlockNested(this.plainLocks, reps);
    }

    @Benchmark
    void orderedCycleDetectingLocks(int reps) {
        this.lockAndUnlockNested(this.detectingLocks, reps);
    }

    private void lockAndUnlockNested(Lock[] locks, int reps) {
        for (int i = 0; i < reps; ++i) {
            int j;
            for (j = 0; j < locks.length; ++j) {
                locks[j].lock();
            }
            for (j = locks.length - 1; j >= 0; --j) {
                locks[j].unlock();
            }
        }
    }
}

