/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class GeneratedMonitorTest
extends TestCase {
    private static final long SMALL_TIMEOUT_MILLIS = 10L;
    private static final long EXPECTED_HANG_DELAY_MILLIS = 75L;
    private static final long UNEXPECTED_HANG_DELAY_MILLIS = 10000L;
    private final Method method;
    private final Scenario scenario;
    private final Timeout timeout;
    private final Outcome expectedOutcome;
    private final Monitor monitor;
    private final FlagGuard guard;
    private final CountDownLatch tearDownLatch;
    private final CountDownLatch doingCallLatch;
    private final CountDownLatch callCompletedLatch;

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        Method[] methods = Monitor.class.getMethods();
        GeneratedMonitorTest.sortMethods(methods);
        for (Method method : methods) {
            if (!GeneratedMonitorTest.isAnyEnter(method) && !GeneratedMonitorTest.isWaitFor(method)) continue;
            GeneratedMonitorTest.validateMethod(method);
            GeneratedMonitorTest.addTests(suite, method);
        }
        GeneratedMonitorTest.assertEquals((int)548, (int)suite.testCount());
        return suite;
    }

    private static boolean isAnyEnter(Method method) {
        return method.getName().startsWith("enter") || method.getName().startsWith("tryEnter");
    }

    private static boolean isTryEnter(Method method) {
        return method.getName().startsWith("tryEnter");
    }

    private static boolean isEnterIf(Method method) {
        return method.getName().startsWith("enterIf");
    }

    private static boolean isWaitFor(Method method) {
        return method.getName().startsWith("waitFor");
    }

    private static boolean isGuarded(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length >= 1 && parameterTypes[0] == Monitor.Guard.class;
    }

    private static boolean isTimed(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length >= 2 && parameterTypes[parameterTypes.length - 2] == Long.TYPE && parameterTypes[parameterTypes.length - 1] == TimeUnit.class;
    }

    private static boolean isBoolean(Method method) {
        return method.getReturnType() == Boolean.TYPE;
    }

    private static boolean isInterruptible(Method method) {
        return Arrays.asList(method.getExceptionTypes()).contains(InterruptedException.class);
    }

    private static void sortMethods(Method[] methods) {
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                int nameComparison = m1.getName().compareTo(m2.getName());
                if (nameComparison != 0) {
                    return nameComparison;
                }
                return Ints.compare((int)m1.getParameterTypes().length, (int)m2.getParameterTypes().length);
            }
        });
    }

    private static void validateMethod(Method method) {
        String desc = method.toString();
        GeneratedMonitorTest.assertTrue((String)desc, (GeneratedMonitorTest.isAnyEnter(method) || GeneratedMonitorTest.isWaitFor(method) ? 1 : 0) != 0);
        switch (method.getParameterTypes().length) {
            case 0: {
                GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isGuarded(method));
                GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isTimed(method));
                break;
            }
            case 1: {
                GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isGuarded(method));
                GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isTimed(method));
                break;
            }
            case 2: {
                GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isGuarded(method));
                GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isTimed(method));
                break;
            }
            case 3: {
                GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isGuarded(method));
                GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isTimed(method));
                break;
            }
            default: {
                GeneratedMonitorTest.fail((String)desc);
            }
        }
        if (method.getReturnType() == Void.TYPE) {
            GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isBoolean(method));
        } else {
            GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isBoolean(method));
        }
        switch (method.getExceptionTypes().length) {
            case 0: {
                GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isInterruptible(method));
                break;
            }
            case 1: {
                GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isInterruptible(method));
                break;
            }
            default: {
                GeneratedMonitorTest.fail((String)desc);
            }
        }
        if (GeneratedMonitorTest.isEnterIf(method)) {
            GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isGuarded(method));
            GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isBoolean(method));
        } else if (GeneratedMonitorTest.isTryEnter(method)) {
            GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isTimed(method));
            GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isBoolean(method));
            GeneratedMonitorTest.assertFalse((String)desc, (boolean)GeneratedMonitorTest.isInterruptible(method));
        } else if (GeneratedMonitorTest.isWaitFor(method)) {
            GeneratedMonitorTest.assertTrue((String)desc, (boolean)GeneratedMonitorTest.isGuarded(method));
            GeneratedMonitorTest.assertEquals((String)desc, (boolean)GeneratedMonitorTest.isTimed(method), (boolean)GeneratedMonitorTest.isBoolean(method));
        } else {
            GeneratedMonitorTest.assertEquals((String)desc, (boolean)GeneratedMonitorTest.isTimed(method), (boolean)GeneratedMonitorTest.isBoolean(method));
        }
    }

    private static void addTests(TestSuite suite, Method method) {
        if (GeneratedMonitorTest.isGuarded(method)) {
            for (boolean fair1 : new boolean[]{true, false}) {
                for (boolean fair2 : new boolean[]{true, false}) {
                    suite.addTest((Test)GeneratedMonitorTest.generateGuardWithWrongMonitorTestCase(method, fair1, fair2));
                }
            }
        }
        if (GeneratedMonitorTest.isAnyEnter(method)) {
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING, TimeoutsToUse.ANY, Outcome.SUCCESS);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING, TimeoutsToUse.FINITE, GeneratedMonitorTest.isGuarded(method) ? (GeneratedMonitorTest.isBoolean(method) ? Outcome.FAILURE : Outcome.HANG) : Outcome.SUCCESS);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING, TimeoutsToUse.INFINITE, GeneratedMonitorTest.isGuarded(method) ? (GeneratedMonitorTest.isTryEnter(method) || GeneratedMonitorTest.isEnterIf(method) ? Outcome.FAILURE : Outcome.HANG) : Outcome.SUCCESS);
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_AND_OCCUPIED_BEFORE_ENTERING, TimeoutsToUse.FINITE, GeneratedMonitorTest.isBoolean(method) ? Outcome.FAILURE : Outcome.HANG);
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_AND_OCCUPIED_BEFORE_ENTERING, TimeoutsToUse.INFINITE, GeneratedMonitorTest.isGuarded(method) ? Outcome.HANG : (GeneratedMonitorTest.isTryEnter(method) ? Outcome.FAILURE : Outcome.HANG));
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_UNOCCUPIED_AND_INTERRUPTED_BEFORE_ENTERING, TimeoutsToUse.ANY, GeneratedMonitorTest.isInterruptible(method) ? Outcome.INTERRUPT : Outcome.SUCCESS);
        } else {
            suite.addTest((Test)GeneratedMonitorTest.generateWaitForWhenNotOccupyingTestCase(method, true));
            suite.addTest((Test)GeneratedMonitorTest.generateWaitForWhenNotOccupyingTestCase(method, false));
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_BEFORE_WAITING, TimeoutsToUse.ANY, Outcome.SUCCESS);
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_WHILE_WAITING, TimeoutsToUse.INFINITE, Outcome.SUCCESS);
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_WHILE_WAITING, TimeoutsToUse.PAST, Outcome.FAILURE);
            GeneratedMonitorTest.addTests(suite, method, Scenario.SATISFIED_AND_INTERRUPTED_BEFORE_WAITING, TimeoutsToUse.ANY, Outcome.SUCCESS);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_BEFORE_AND_WHILE_WAITING, TimeoutsToUse.FINITE, Outcome.FAILURE);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_BEFORE_AND_WHILE_WAITING, TimeoutsToUse.INFINITE, Outcome.HANG);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_AND_INTERRUPTED_BEFORE_WAITING, TimeoutsToUse.PAST, GeneratedMonitorTest.isInterruptible(method) ? Outcome.INTERRUPT : Outcome.FAILURE);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_AND_INTERRUPTED_BEFORE_WAITING, TimeoutsToUse.SMALL, GeneratedMonitorTest.isInterruptible(method) ? Outcome.INTERRUPT : Outcome.FAILURE);
            GeneratedMonitorTest.addTests(suite, method, Scenario.UNSATISFIED_AND_INTERRUPTED_BEFORE_WAITING, TimeoutsToUse.INFINITE, GeneratedMonitorTest.isInterruptible(method) ? Outcome.INTERRUPT : Outcome.HANG);
        }
    }

    private static void addTests(TestSuite suite, Method method, Scenario scenario, TimeoutsToUse timeoutsToUse, Outcome expectedOutcome) {
        for (boolean fair : new boolean[]{true, false}) {
            Timeout implicitTimeout;
            if (GeneratedMonitorTest.isTimed(method)) {
                for (Timeout timeout : timeoutsToUse.timeouts) {
                    suite.addTest((Test)new GeneratedMonitorTest(method, scenario, fair, timeout, expectedOutcome));
                }
                continue;
            }
            Timeout timeout = implicitTimeout = GeneratedMonitorTest.isTryEnter(method) ? Timeout.ZERO : Timeout.MAX;
            if (!timeoutsToUse.timeouts.contains((Object)implicitTimeout)) continue;
            suite.addTest((Test)new GeneratedMonitorTest(method, scenario, fair, null, expectedOutcome));
        }
    }

    private GeneratedMonitorTest(Method method, Scenario scenario, boolean fair, Timeout timeout, Outcome expectedOutcome) {
        super(GeneratedMonitorTest.nameFor(method, scenario, fair, timeout, expectedOutcome));
        this.method = method;
        this.scenario = scenario;
        this.timeout = timeout;
        this.expectedOutcome = expectedOutcome;
        this.monitor = new Monitor(fair);
        this.guard = new FlagGuard(this.monitor);
        this.tearDownLatch = new CountDownLatch(1);
        this.doingCallLatch = new CountDownLatch(1);
        this.callCompletedLatch = new CountDownLatch(1);
    }

    private static String nameFor(Method method, Scenario scenario, boolean fair, Timeout timeout, Outcome expectedOutcome) {
        return String.format(Locale.ROOT, "%s%s(%s)/%s->%s", new Object[]{method.getName(), fair ? "(fair)" : "(nonfair)", timeout == null ? "untimed" : timeout, scenario, expectedOutcome});
    }

    protected void runTest() throws Throwable {
        boolean hung;
        Runnable runChosenTest = new Runnable(){

            @Override
            public void run() {
                GeneratedMonitorTest.this.runChosenTest();
            }
        };
        final FutureTask<Object> task = new FutureTask<Object>(runChosenTest, null);
        GeneratedMonitorTest.startThread(new Runnable(){

            @Override
            public void run() {
                task.run();
            }
        });
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.doingCallLatch);
        long hangDelayMillis = this.expectedOutcome == Outcome.HANG ? 75L : 10000L;
        boolean bl = hung = !Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.callCompletedLatch, (long)hangDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        if (hung) {
            GeneratedMonitorTest.assertEquals((Object)((Object)this.expectedOutcome), (Object)((Object)Outcome.HANG));
        } else {
            GeneratedMonitorTest.assertNull(task.get(10000L, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        this.tearDownLatch.countDown();
        GeneratedMonitorTest.assertTrue((String)"Monitor still occupied in tearDown()", (boolean)this.monitor.enter(10000L, TimeUnit.MILLISECONDS));
        try {
            this.guard.setSatisfied(true);
        }
        finally {
            this.monitor.leave();
        }
    }

    private void runChosenTest() {
        if (GeneratedMonitorTest.isAnyEnter(this.method)) {
            this.runEnterTest();
        } else {
            this.runWaitTest();
        }
    }

    private void runEnterTest() {
        GeneratedMonitorTest.assertFalse((boolean)Thread.currentThread().isInterrupted());
        GeneratedMonitorTest.assertFalse((boolean)this.monitor.isOccupiedByCurrentThread());
        this.doEnterScenarioSetUp();
        boolean interruptedBeforeCall = Thread.currentThread().isInterrupted();
        Outcome actualOutcome = this.doCall();
        boolean occupiedAfterCall = this.monitor.isOccupiedByCurrentThread();
        boolean interruptedAfterCall = Thread.currentThread().isInterrupted();
        if (occupiedAfterCall) {
            this.guard.setSatisfied(true);
            this.monitor.leave();
            GeneratedMonitorTest.assertFalse((boolean)this.monitor.isOccupiedByCurrentThread());
        }
        GeneratedMonitorTest.assertEquals((Object)((Object)this.expectedOutcome), (Object)((Object)actualOutcome));
        GeneratedMonitorTest.assertEquals((this.expectedOutcome == Outcome.SUCCESS ? 1 : 0) != 0, (boolean)occupiedAfterCall);
        GeneratedMonitorTest.assertEquals((interruptedBeforeCall && this.expectedOutcome != Outcome.INTERRUPT ? 1 : 0) != 0, (boolean)interruptedAfterCall);
    }

    private void doEnterScenarioSetUp() {
        switch (this.scenario) {
            case SATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING: {
                this.enterSatisfyGuardAndLeaveInCurrentThread();
                break;
            }
            case UNSATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING: {
                break;
            }
            case SATISFIED_AND_OCCUPIED_BEFORE_ENTERING: {
                this.enterSatisfyGuardAndLeaveInCurrentThread();
                this.enterAndRemainOccupyingInAnotherThread();
                break;
            }
            case SATISFIED_UNOCCUPIED_AND_INTERRUPTED_BEFORE_ENTERING: {
                this.enterSatisfyGuardAndLeaveInCurrentThread();
                Thread.currentThread().interrupt();
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported scenario: " + (Object)((Object)this.scenario)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWaitTest() {
        GeneratedMonitorTest.assertFalse((boolean)Thread.currentThread().isInterrupted());
        GeneratedMonitorTest.assertFalse((boolean)this.monitor.isOccupiedByCurrentThread());
        this.monitor.enter();
        try {
            GeneratedMonitorTest.assertTrue((boolean)this.monitor.isOccupiedByCurrentThread());
            this.doWaitScenarioSetUp();
            boolean interruptedBeforeCall = Thread.currentThread().isInterrupted();
            Outcome actualOutcome = this.doCall();
            boolean occupiedAfterCall = this.monitor.isOccupiedByCurrentThread();
            boolean interruptedAfterCall = Thread.currentThread().isInterrupted();
            GeneratedMonitorTest.assertEquals((Object)((Object)this.expectedOutcome), (Object)((Object)actualOutcome));
            GeneratedMonitorTest.assertTrue((boolean)occupiedAfterCall);
            GeneratedMonitorTest.assertEquals((interruptedBeforeCall && this.expectedOutcome != Outcome.INTERRUPT ? 1 : 0) != 0, (boolean)interruptedAfterCall);
        }
        finally {
            this.guard.setSatisfied(true);
            this.monitor.leave();
            GeneratedMonitorTest.assertFalse((boolean)this.monitor.isOccupiedByCurrentThread());
        }
    }

    private void doWaitScenarioSetUp() {
        switch (this.scenario) {
            case SATISFIED_BEFORE_WAITING: {
                this.guard.setSatisfied(true);
                break;
            }
            case SATISFIED_WHILE_WAITING: {
                this.guard.setSatisfied(false);
                this.enterSatisfyGuardAndLeaveInAnotherThread();
                break;
            }
            case UNSATISFIED_BEFORE_AND_WHILE_WAITING: {
                this.guard.setSatisfied(false);
                break;
            }
            case SATISFIED_AND_INTERRUPTED_BEFORE_WAITING: {
                this.guard.setSatisfied(true);
                Thread.currentThread().interrupt();
                break;
            }
            case UNSATISFIED_AND_INTERRUPTED_BEFORE_WAITING: {
                this.guard.setSatisfied(false);
                Thread.currentThread().interrupt();
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported scenario: " + (Object)((Object)this.scenario)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Outcome doCall() {
        boolean guarded = GeneratedMonitorTest.isGuarded(this.method);
        boolean timed = GeneratedMonitorTest.isTimed(this.method);
        Object[] arguments = new Object[(guarded ? 1 : 0) + (timed ? 2 : 0)];
        if (guarded) {
            arguments[0] = this.guard;
        }
        if (timed) {
            arguments[arguments.length - 2] = this.timeout.millis;
            arguments[arguments.length - 1] = TimeUnit.MILLISECONDS;
        }
        try {
            Object result;
            this.doingCallLatch.countDown();
            try {
                result = this.method.invoke((Object)this.monitor, arguments);
            }
            finally {
                this.callCompletedLatch.countDown();
            }
            if (result == null) {
                return Outcome.SUCCESS;
            }
            if (((Boolean)result).booleanValue()) {
                return Outcome.SUCCESS;
            }
            return Outcome.FAILURE;
        }
        catch (InvocationTargetException targetException) {
            Throwable actualException = targetException.getTargetException();
            if (actualException instanceof InterruptedException) {
                return Outcome.INTERRUPT;
            }
            throw GeneratedMonitorTest.newAssertionError("unexpected exception", targetException);
        }
        catch (IllegalAccessException e) {
            throw GeneratedMonitorTest.newAssertionError("unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterSatisfyGuardAndLeaveInCurrentThread() {
        this.monitor.enter();
        try {
            this.guard.setSatisfied(true);
        }
        finally {
            this.monitor.leave();
        }
    }

    private void enterSatisfyGuardAndLeaveInAnotherThread() {
        final CountDownLatch startedLatch = new CountDownLatch(1);
        GeneratedMonitorTest.startThread(new Runnable(){

            @Override
            public void run() {
                startedLatch.countDown();
                GeneratedMonitorTest.this.enterSatisfyGuardAndLeaveInCurrentThread();
            }
        });
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)startedLatch);
    }

    private void enterAndRemainOccupyingInAnotherThread() {
        final CountDownLatch enteredLatch = new CountDownLatch(1);
        GeneratedMonitorTest.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GeneratedMonitorTest.this.monitor.enter();
                try {
                    enteredLatch.countDown();
                    Uninterruptibles.awaitUninterruptibly((CountDownLatch)GeneratedMonitorTest.this.tearDownLatch);
                    GeneratedMonitorTest.this.guard.setSatisfied(true);
                }
                finally {
                    GeneratedMonitorTest.this.monitor.leave();
                }
            }
        });
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)enteredLatch);
    }

    static Thread startThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private static TestCase generateGuardWithWrongMonitorTestCase(final Method method, final boolean fair1, final boolean fair2) {
        final boolean timed = GeneratedMonitorTest.isTimed(method);
        return new TestCase(method.getName() + (timed ? "(0ms)" : "()") + "/WrongMonitor->IMSE"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runTest() throws Throwable {
                Object[] objectArray;
                Monitor monitor1 = new Monitor(fair1);
                Monitor monitor2 = new Monitor(fair2);
                FlagGuard guard = new FlagGuard(monitor2);
                if (timed) {
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = guard;
                    objectArray2[1] = 0L;
                    objectArray = objectArray2;
                    objectArray2[2] = TimeUnit.MILLISECONDS;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = guard;
                }
                Object[] arguments = objectArray;
                boolean occupyMonitor = GeneratedMonitorTest.isWaitFor(method);
                if (occupyMonitor) {
                    monitor1.enter();
                }
                try {
                    method.invoke((Object)monitor1, arguments);
                    6.fail((String)"expected IllegalMonitorStateException");
                }
                catch (InvocationTargetException e) {
                    6.assertEquals(IllegalMonitorStateException.class, e.getTargetException().getClass());
                }
                finally {
                    if (occupyMonitor) {
                        monitor1.leave();
                    }
                }
            }
        };
    }

    private static TestCase generateWaitForWhenNotOccupyingTestCase(final Method method, final boolean fair) {
        final boolean timed = GeneratedMonitorTest.isTimed(method);
        String testName = method.getName() + (fair ? "(fair)" : "(nonfair)") + (timed ? "(0ms)" : "()") + "/NotOccupying->IMSE";
        return new TestCase(testName){

            protected void runTest() throws Throwable {
                Object[] objectArray;
                Monitor monitor = new Monitor(fair);
                FlagGuard guard = new FlagGuard(monitor);
                if (timed) {
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = guard;
                    objectArray2[1] = 0L;
                    objectArray = objectArray2;
                    objectArray2[2] = TimeUnit.MILLISECONDS;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = guard;
                }
                Object[] arguments = objectArray;
                try {
                    method.invoke((Object)monitor, arguments);
                    7.fail((String)"expected IllegalMonitorStateException");
                }
                catch (InvocationTargetException e) {
                    7.assertEquals(IllegalMonitorStateException.class, e.getTargetException().getClass());
                }
            }
        };
    }

    private static AssertionError newAssertionError(String message, Throwable cause) {
        AssertionError e = new AssertionError((Object)message);
        ((Throwable)((Object)e)).initCause(cause);
        return e;
    }

    static class FlagGuard
    extends Monitor.Guard {
        private boolean satisfied;

        protected FlagGuard(Monitor monitor) {
            super(monitor);
        }

        public boolean isSatisfied() {
            return this.satisfied;
        }

        public void setSatisfied(boolean satisfied) {
            this.satisfied = satisfied;
        }
    }

    private static enum Outcome {
        SUCCESS,
        FAILURE,
        INTERRUPT,
        HANG;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    private static enum TimeoutsToUse {
        ANY(Timeout.values()),
        PAST(Timeout.MIN, Timeout.MINUS_SMALL, Timeout.ZERO),
        FUTURE(Timeout.SMALL, Timeout.MAX),
        SMALL(Timeout.SMALL),
        FINITE(Timeout.MIN, Timeout.MINUS_SMALL, Timeout.ZERO, Timeout.SMALL),
        INFINITE(Timeout.LARGE, Timeout.MAX);

        final ImmutableList<Timeout> timeouts;

        private TimeoutsToUse(Timeout ... timeouts) {
            this.timeouts = ImmutableList.copyOf((Object[])timeouts);
        }
    }

    private static enum Timeout {
        MIN(Long.MIN_VALUE, "-oo"),
        MINUS_SMALL(-10L, "-10ms"),
        ZERO(0L, "0ms"),
        SMALL(10L, "10ms"),
        LARGE(20000L, "20000ms"),
        MAX(Long.MAX_VALUE, "+oo");

        final long millis;
        final String label;

        private Timeout(long millis, String label) {
            this.millis = millis;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    private static enum Scenario {
        SATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING,
        UNSATISFIED_AND_UNOCCUPIED_BEFORE_ENTERING,
        SATISFIED_AND_OCCUPIED_BEFORE_ENTERING,
        SATISFIED_UNOCCUPIED_AND_INTERRUPTED_BEFORE_ENTERING,
        SATISFIED_BEFORE_WAITING,
        SATISFIED_WHILE_WAITING,
        SATISFIED_AND_INTERRUPTED_BEFORE_WAITING,
        UNSATISFIED_BEFORE_AND_WHILE_WAITING,
        UNSATISFIED_AND_INTERRUPTED_BEFORE_WAITING;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

