/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.testing.ClassSanityTester;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.FuturesTest;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class JdkFutureAdaptersTest
extends TestCase {
    private static final String DATA1 = "data";

    public void testListenInPoolThreadReturnsSameFuture() throws Exception {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)DATA1);
        JdkFutureAdaptersTest.assertSame((Object)listenableFuture, (Object)JdkFutureAdapters.listenInPoolThread((Future)listenableFuture));
    }

    public void testListenInPoolThreadIgnoresExecutorWhenDelegateIsDone() throws Exception {
        NonListenableSettableFuture<String> abstractFuture = NonListenableSettableFuture.create();
        abstractFuture.set(DATA1);
        FuturesTest.ExecutorSpy spy = new FuturesTest.ExecutorSpy(MoreExecutors.directExecutor());
        ListenableFuture listenableFuture = JdkFutureAdapters.listenInPoolThread(abstractFuture, (Executor)spy);
        FuturesTest.SingleCallListener singleCallListener = new FuturesTest.SingleCallListener();
        singleCallListener.expectCall();
        JdkFutureAdaptersTest.assertFalse((boolean)spy.wasExecuted);
        JdkFutureAdaptersTest.assertFalse((boolean)singleCallListener.wasCalled());
        JdkFutureAdaptersTest.assertTrue((boolean)listenableFuture.isDone());
        listenableFuture.addListener((Runnable)singleCallListener, MoreExecutors.directExecutor());
        JdkFutureAdaptersTest.assertEquals((String)DATA1, (String)((String)listenableFuture.get()));
        JdkFutureAdaptersTest.assertFalse((boolean)spy.wasExecuted);
        JdkFutureAdaptersTest.assertTrue((boolean)singleCallListener.wasCalled());
        JdkFutureAdaptersTest.assertTrue((boolean)listenableFuture.isDone());
    }

    public void testListenInPoolThreadUsesGivenExecutor() throws Exception {
        ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).build());
        NonListenableSettableFuture<String> abstractFuture = NonListenableSettableFuture.create();
        FuturesTest.ExecutorSpy spy = new FuturesTest.ExecutorSpy(executorService);
        ListenableFuture listenableFuture = JdkFutureAdapters.listenInPoolThread(abstractFuture, (Executor)spy);
        FuturesTest.SingleCallListener singleCallListener = new FuturesTest.SingleCallListener();
        singleCallListener.expectCall();
        JdkFutureAdaptersTest.assertFalse((boolean)spy.wasExecuted);
        JdkFutureAdaptersTest.assertFalse((boolean)singleCallListener.wasCalled());
        JdkFutureAdaptersTest.assertFalse((boolean)listenableFuture.isDone());
        listenableFuture.addListener((Runnable)singleCallListener, (Executor)executorService);
        abstractFuture.set(DATA1);
        JdkFutureAdaptersTest.assertEquals((String)DATA1, (String)((String)listenableFuture.get()));
        singleCallListener.waitForCall();
        JdkFutureAdaptersTest.assertTrue((boolean)spy.wasExecuted);
        JdkFutureAdaptersTest.assertTrue((boolean)singleCallListener.wasCalled());
        JdkFutureAdaptersTest.assertTrue((boolean)listenableFuture.isDone());
    }

    public void testListenInPoolThreadCustomExecutorInterrupted() throws Exception {
        final CountDownLatch submitSuccessful = new CountDownLatch(1);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue(), new ThreadFactoryBuilder().setDaemon(true).build()){

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                submitSuccessful.countDown();
            }
        };
        NonListenableSettableFuture<String> abstractFuture = NonListenableSettableFuture.create();
        ListenableFuture listenableFuture = JdkFutureAdapters.listenInPoolThread(abstractFuture, (Executor)executorService);
        FuturesTest.SingleCallListener singleCallListener = new FuturesTest.SingleCallListener();
        singleCallListener.expectCall();
        JdkFutureAdaptersTest.assertFalse((boolean)singleCallListener.wasCalled());
        JdkFutureAdaptersTest.assertFalse((boolean)listenableFuture.isDone());
        listenableFuture.addListener((Runnable)singleCallListener, MoreExecutors.directExecutor());
        submitSuccessful.await();
        executorService.shutdownNow();
        abstractFuture.set(DATA1);
        JdkFutureAdaptersTest.assertEquals((String)DATA1, (String)((String)listenableFuture.get()));
        singleCallListener.waitForCall();
        JdkFutureAdaptersTest.assertTrue((boolean)singleCallListener.wasCalled());
        JdkFutureAdaptersTest.assertTrue((boolean)listenableFuture.isDone());
    }

    public void testListenInPoolThreadRunsListenerAfterRuntimeException() throws Exception {
        RuntimeExceptionThrowingFuture input = new RuntimeExceptionThrowingFuture();
        JdkFutureAdaptersTest.assertFalse((String)"Can't test the main listenInPoolThread path if the input is already a ListenableFuture", (boolean)ListenableFuture.class.isInstance(input));
        ListenableFuture listenable = JdkFutureAdapters.listenInPoolThread(input);
        RecordingRunnable earlyListener = new RecordingRunnable();
        listenable.addListener((Runnable)earlyListener, MoreExecutors.directExecutor());
        input.allowGetToComplete.countDown();
        JdkFutureAdaptersTest.assertTrue((boolean)earlyListener.wasRun.await(1L, TimeUnit.SECONDS));
        RecordingRunnable lateListener = new RecordingRunnable();
        listenable.addListener((Runnable)lateListener, MoreExecutors.directExecutor());
        JdkFutureAdaptersTest.assertTrue((boolean)lateListener.wasRun.await(1L, TimeUnit.SECONDS));
    }

    public void testAdapters_nullChecks() throws Exception {
        new ClassSanityTester().forAllPublicStaticMethods(JdkFutureAdapters.class).thatReturn(Future.class).testNulls();
    }

    private static final class RecordingRunnable
    implements Runnable {
        final CountDownLatch wasRun = new CountDownLatch(1);

        private RecordingRunnable() {
        }

        @Override
        public synchronized void run() {
            Preconditions.checkState((this.wasRun.getCount() > 0L ? 1 : 0) != 0);
            this.wasRun.countDown();
        }
    }

    private static final class RuntimeExceptionThrowingFuture<V>
    implements Future<V> {
        final CountDownLatch allowGetToComplete = new CountDownLatch(1);

        private RuntimeExceptionThrowingFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new AssertionFailedError();
        }

        @Override
        public V get() throws InterruptedException {
            this.allowGetToComplete.await(1L, TimeUnit.SECONDS);
            throw new RuntimeException("expected, should be caught");
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            throw new AssertionFailedError();
        }

        @Override
        public boolean isCancelled() {
            throw new AssertionFailedError();
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }

    private static final class NonListenableSettableFuture<V>
    extends ForwardingFuture<V> {
        final SettableFuture<V> delegate = SettableFuture.create();

        private NonListenableSettableFuture() {
        }

        static <V> NonListenableSettableFuture<V> create() {
            return new NonListenableSettableFuture<V>();
        }

        protected Future<V> delegate() {
            return this.delegate;
        }

        void set(V value) {
            this.delegate.set(value);
        }
    }
}

