/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class SimpleTimeLimiterTest
extends TestCase {
    private static final int DELAY_MS = 50;
    private static final int ENOUGH_MS = 500;
    private static final int NOT_ENOUGH_MS = 5;
    private TimeLimiter service;
    private static final ExecutorService executor = Executors.newFixedThreadPool(1);

    private static String someGoodStaticMethod() throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(50L);
        return "yes";
    }

    private static String someBadStaticMethod() throws InterruptedException, SampleException {
        TimeUnit.MILLISECONDS.sleep(50L);
        throw new SampleException();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.service = new SimpleTimeLimiter(executor);
    }

    public void testGoodCallableWithEnoughTime() throws Exception {
        long start = System.nanoTime();
        String result = (String)this.service.callWithTimeout((Callable)new Callable<String>(){

            @Override
            public String call() throws InterruptedException {
                return SimpleTimeLimiterTest.someGoodStaticMethod();
            }
        }, 500L, TimeUnit.MILLISECONDS, true);
        SimpleTimeLimiterTest.assertEquals((String)"yes", (String)result);
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 50, 500);
    }

    public void testGoodCallableWithNotEnoughTime() throws Exception {
        long start = System.nanoTime();
        try {
            this.service.callWithTimeout((Callable)new Callable<String>(){

                @Override
                public String call() throws InterruptedException {
                    return SimpleTimeLimiterTest.someGoodStaticMethod();
                }
            }, 5L, TimeUnit.MILLISECONDS, true);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedTimeoutException uncheckedTimeoutException) {
            // empty catch block
        }
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 5, 50);
    }

    public void testBadCallableWithEnoughTime() throws Exception {
        long start = System.nanoTime();
        try {
            this.service.callWithTimeout((Callable)new Callable<String>(){

                @Override
                public String call() throws SampleException, InterruptedException {
                    return SimpleTimeLimiterTest.someBadStaticMethod();
                }
            }, 500L, TimeUnit.MILLISECONDS, true);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (SampleException sampleException) {
            // empty catch block
        }
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 50, 500);
    }

    public void testBadCallableWithNotEnoughTime() throws Exception {
        long start = System.nanoTime();
        try {
            this.service.callWithTimeout((Callable)new Callable<String>(){

                @Override
                public String call() throws SampleException, InterruptedException {
                    return SimpleTimeLimiterTest.someBadStaticMethod();
                }
            }, 5L, TimeUnit.MILLISECONDS, true);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedTimeoutException uncheckedTimeoutException) {
            // empty catch block
        }
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 5, 50);
    }

    public void testGoodMethodWithEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl();
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 500L, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        SimpleTimeLimiterTest.assertEquals((String)"x", (String)proxy.sleepThenReturnInput("x"));
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 50, 500);
        SimpleTimeLimiterTest.assertTrue((boolean)target.finished);
    }

    public void testGoodMethodWithNotEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl();
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 5L, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        try {
            proxy.sleepThenReturnInput("x");
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedTimeoutException expected) {
            // empty catch block
        }
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 5, 50);
        SimpleTimeLimiterTest.assertFalse((boolean)target.finished);
        TimeUnit.MILLISECONDS.sleep(500L);
        SimpleTimeLimiterTest.assertFalse((boolean)target.finished);
    }

    public void testBadMethodWithEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl();
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 500L, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        try {
            proxy.sleepThenThrowException();
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (SampleException expected) {
            // empty catch block
        }
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 50, 500);
    }

    public void testBadMethodWithNotEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl();
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 5L, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        try {
            proxy.sleepThenThrowException();
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedTimeoutException expected) {
            // empty catch block
        }
        SimpleTimeLimiterTest.assertTheCallTookBetween(start, 5, 50);
    }

    private static void assertTheCallTookBetween(long startNanos, int atLeastMillis, int atMostMillis) {
        long nanos = System.nanoTime() - startNanos;
        SimpleTimeLimiterTest.assertTrue((nanos >= (long)(atLeastMillis * 1000000) ? 1 : 0) != 0);
        SimpleTimeLimiterTest.assertTrue((nanos <= (long)(atMostMillis * 1000000) ? 1 : 0) != 0);
    }

    public static class SampleImpl
    implements Sample {
        boolean finished;

        @Override
        public String sleepThenReturnInput(String input) {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
                this.finished = true;
                return input;
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        @Override
        public void sleepThenThrowException() throws SampleException {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SampleException();
        }
    }

    public static class SampleException
    extends Exception {
    }

    public static interface Sample {
        public String sleepThenReturnInput(String var1);

        public void sleepThenThrowException() throws SampleException;
    }
}

