/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CodingConventions {
    private CodingConventions() {
    }

    public static CodingConvention getDefault() {
        return new DefaultCodingConvention();
    }

    private static class DefaultCodingConvention
    implements CodingConvention {
        private static final long serialVersionUID = 1L;

        private DefaultCodingConvention() {
        }

        @Override
        public boolean isConstant(String variableName) {
            return false;
        }

        @Override
        public boolean isConstantKey(String variableName) {
            return false;
        }

        @Override
        public boolean isValidEnumKey(String key) {
            return key != null && key.length() > 0;
        }

        @Override
        public boolean isOptionalParameter(Node parameter) {
            return false;
        }

        @Override
        public boolean isVarArgsParameter(Node parameter) {
            return false;
        }

        @Override
        public boolean isExported(String name, boolean local) {
            return local && name.startsWith("$super");
        }

        @Override
        public boolean isExported(String name) {
            return this.isExported(name, false) || this.isExported(name, true);
        }

        @Override
        public boolean isPrivate(String name) {
            return false;
        }

        @Override
        public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
            return null;
        }

        @Override
        public boolean isSuperClassReference(String propertyName) {
            return false;
        }

        @Override
        public String extractClassNameIfProvide(Node node, Node parent) {
            String message = "only implemented in GoogleCodingConvention";
            throw new UnsupportedOperationException(message);
        }

        @Override
        public String extractClassNameIfRequire(Node node, Node parent) {
            String message = "only implemented in GoogleCodingConvention";
            throw new UnsupportedOperationException(message);
        }

        @Override
        public String getExportPropertyFunction() {
            return null;
        }

        @Override
        public String getExportSymbolFunction() {
            return null;
        }

        @Override
        public List<String> identifyTypeDeclarationCall(Node n) {
            return null;
        }

        @Override
        public void applySubclassRelationship(FunctionType parentCtor, FunctionType childCtor, CodingConvention.SubclassType type) {
        }

        @Override
        public String getAbstractMethodName() {
            return null;
        }

        @Override
        public String getSingletonGetterClassName(Node callNode) {
            return null;
        }

        @Override
        public void applySingletonGetter(FunctionType functionType, FunctionType getterType, ObjectType objectType) {
        }

        @Override
        public boolean isInlinableFunction(Node n) {
            Preconditions.checkState((boolean)n.isFunction());
            return true;
        }

        @Override
        public CodingConvention.DelegateRelationship getDelegateRelationship(Node callNode) {
            return null;
        }

        @Override
        public void applyDelegateRelationship(ObjectType delegateSuperclass, ObjectType delegateBase, ObjectType delegator, FunctionType delegateProxy, FunctionType findDelegate) {
        }

        @Override
        public String getDelegateSuperclassName() {
            return null;
        }

        @Override
        public void checkForCallingConventionDefiningCalls(Node n, Map<String, String> delegateCallingConventions) {
        }

        @Override
        public void defineDelegateProxyPrototypeProperties(JSTypeRegistry registry, StaticScope<JSType> scope, List<ObjectType> delegateProxyPrototypes, Map<String, String> delegateCallingConventions) {
        }

        @Override
        public String getGlobalObject() {
            return "window";
        }

        @Override
        public boolean isPropertyTestFunction(Node call) {
            return false;
        }

        @Override
        public boolean isPrototypeAlias(Node getProp) {
            return false;
        }

        @Override
        public CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
            return null;
        }

        @Override
        public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
            return Collections.emptySet();
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n) {
            return this.describeFunctionBind(n, false);
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n, boolean useTypeInfo) {
            if (!n.isCall()) {
                return null;
            }
            Node callTarget = n.getFirstChild();
            String name = callTarget.getQualifiedName();
            if (name != null && name.equals("Function.prototype.bind.call")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = this.safeNext(fn);
                Node parameters = this.safeNext(thisValue);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
            if (callTarget.isGetProp() && callTarget.getLastChild().getString().equals("bind")) {
                Node maybeFn = callTarget.getFirstChild();
                JSType maybeFnType = maybeFn.getJSType();
                FunctionType fnType = null;
                if (useTypeInfo && maybeFnType != null) {
                    fnType = maybeFnType.restrictByNotNullOrUndefined().toMaybeFunctionType();
                }
                if (fnType != null || maybeFn.isFunction()) {
                    Node thisValue = callTarget.getNext();
                    Node parameters = this.safeNext(thisValue);
                    return new CodingConvention.Bind(maybeFn, thisValue, parameters);
                }
            }
            return null;
        }

        @Override
        public Collection<String> getIndirectlyDeclaredProperties() {
            return ImmutableList.of();
        }

        private Node safeNext(Node n) {
            if (n != null) {
                return n.getNext();
            }
            return null;
        }
    }

    public static class Proxy
    implements CodingConvention {
        protected final CodingConvention nextConvention;

        protected Proxy(CodingConvention convention) {
            this.nextConvention = convention;
        }

        @Override
        public boolean isConstant(String variableName) {
            return this.nextConvention.isConstant(variableName);
        }

        @Override
        public boolean isConstantKey(String keyName) {
            return this.nextConvention.isConstantKey(keyName);
        }

        @Override
        public boolean isValidEnumKey(String key) {
            return this.nextConvention.isValidEnumKey(key);
        }

        @Override
        public boolean isOptionalParameter(Node parameter) {
            return this.nextConvention.isOptionalParameter(parameter);
        }

        @Override
        public boolean isVarArgsParameter(Node parameter) {
            return this.nextConvention.isVarArgsParameter(parameter);
        }

        @Override
        public boolean isExported(String name, boolean local) {
            return this.nextConvention.isExported(name, local);
        }

        @Override
        public final boolean isExported(String name) {
            return this.isExported(name, false) || this.isExported(name, true);
        }

        @Override
        public boolean isPrivate(String name) {
            return this.nextConvention.isPrivate(name);
        }

        @Override
        public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
            return this.nextConvention.getClassesDefinedByCall(callNode);
        }

        @Override
        public boolean isSuperClassReference(String propertyName) {
            return this.nextConvention.isSuperClassReference(propertyName);
        }

        @Override
        public String extractClassNameIfProvide(Node node, Node parent) {
            return this.nextConvention.extractClassNameIfProvide(node, parent);
        }

        @Override
        public String extractClassNameIfRequire(Node node, Node parent) {
            return this.nextConvention.extractClassNameIfRequire(node, parent);
        }

        @Override
        public String getExportPropertyFunction() {
            return this.nextConvention.getExportPropertyFunction();
        }

        @Override
        public String getExportSymbolFunction() {
            return this.nextConvention.getExportSymbolFunction();
        }

        @Override
        public List<String> identifyTypeDeclarationCall(Node n) {
            return this.nextConvention.identifyTypeDeclarationCall(n);
        }

        @Override
        public void applySubclassRelationship(FunctionType parentCtor, FunctionType childCtor, CodingConvention.SubclassType type) {
            this.nextConvention.applySubclassRelationship(parentCtor, childCtor, type);
        }

        @Override
        public String getAbstractMethodName() {
            return this.nextConvention.getAbstractMethodName();
        }

        @Override
        public String getSingletonGetterClassName(Node callNode) {
            return this.nextConvention.getSingletonGetterClassName(callNode);
        }

        @Override
        public void applySingletonGetter(FunctionType functionType, FunctionType getterType, ObjectType objectType) {
            this.nextConvention.applySingletonGetter(functionType, getterType, objectType);
        }

        @Override
        public boolean isInlinableFunction(Node n) {
            return this.nextConvention.isInlinableFunction(n);
        }

        @Override
        public CodingConvention.DelegateRelationship getDelegateRelationship(Node callNode) {
            return this.nextConvention.getDelegateRelationship(callNode);
        }

        @Override
        public void applyDelegateRelationship(ObjectType delegateSuperclass, ObjectType delegateBase, ObjectType delegator, FunctionType delegateProxy, FunctionType findDelegate) {
            this.nextConvention.applyDelegateRelationship(delegateSuperclass, delegateBase, delegator, delegateProxy, findDelegate);
        }

        @Override
        public String getDelegateSuperclassName() {
            return this.nextConvention.getDelegateSuperclassName();
        }

        @Override
        public void checkForCallingConventionDefiningCalls(Node n, Map<String, String> delegateCallingConventions) {
            this.nextConvention.checkForCallingConventionDefiningCalls(n, delegateCallingConventions);
        }

        @Override
        public void defineDelegateProxyPrototypeProperties(JSTypeRegistry registry, StaticScope<JSType> scope, List<ObjectType> delegateProxyPrototypes, Map<String, String> delegateCallingConventions) {
            this.nextConvention.defineDelegateProxyPrototypeProperties(registry, scope, delegateProxyPrototypes, delegateCallingConventions);
        }

        @Override
        public String getGlobalObject() {
            return this.nextConvention.getGlobalObject();
        }

        @Override
        public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
            return this.nextConvention.getAssertionFunctions();
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n) {
            return this.describeFunctionBind(n, false);
        }

        @Override
        public CodingConvention.Bind describeFunctionBind(Node n, boolean useTypeInfo) {
            return this.nextConvention.describeFunctionBind(n, useTypeInfo);
        }

        @Override
        public boolean isPropertyTestFunction(Node call) {
            return this.nextConvention.isPropertyTestFunction(call);
        }

        @Override
        public boolean isPrototypeAlias(Node getProp) {
            return false;
        }

        @Override
        public CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
            return this.nextConvention.getObjectLiteralCast(callNode);
        }

        @Override
        public Collection<String> getIndirectlyDeclaredProperties() {
            return this.nextConvention.getIndirectlyDeclaredProperties();
        }
    }
}

