/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_REDECLARED_PROPERTY", "Found two declarations for property {0} of type {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType INTERFACE_WITH_A_BODY = DiagnosticType.warning("JSC_INTERFACE_WITH_A_BODY", "Interface definitions should have an empty body.");
    static final DiagnosticType INHERITANCE_CYCLE = DiagnosticType.warning("JSC_INHERITANCE_CYCLE", "Cycle detected in inheritance chain of type {0}");
    private final Deque<Scope> scopes = Lists.newLinkedList();
    private Scope globalScope;
    private final Deque<Scope> scopeWorkset = Lists.newLinkedList();
    private final Set<JSError> warnings = Sets.newHashSet();
    private final JSTypeCreatorFromJSDoc typeParser = new JSTypeCreatorFromJSDoc();
    private final AbstractCompiler compiler;
    private final Map<Node, String> anonFunNames = Maps.newHashMap();
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private int freshId = 1;
    private Map<Node, NominalType.RawNominalType> nominaltypesByNode = Maps.newHashMap();
    private HashBasedTable<Integer, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private Map<Node, JSType> castTypes = Maps.newHashMap();
    private Map<Node, JSType> declaredObjLitProps = Maps.newHashMap();

    GlobalTypeInfo(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    Collection<Scope> getScopes() {
        return this.scopes;
    }

    Scope getGlobalScope() {
        return this.globalScope;
    }

    Collection<JSError> getWarnings() {
        return this.warnings;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        String nonAnonFnName = NodeUtil.getFunctionName(n);
        if (nonAnonFnName != null && !nonAnonFnName.contains(".")) {
            return nonAnonFnName;
        }
        return this.anonFunNames.get(n);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((externs == null || externs.isSyntheticBlock() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isSyntheticBlock());
        this.globalScope = new Scope(root, null, new ArrayList(), null);
        this.scopes.addFirst(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootCnt).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootCnt).traverse(root);
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        if (externs != null) {
            new NodeTraversal(this.compiler, rootPs).traverse(externs);
        }
        new NodeTraversal(this.compiler, rootPs).traverse(root);
        rootPs.finishProcessingScope();
        while (!this.scopeWorkset.isEmpty()) {
            Scope s = this.scopeWorkset.removeFirst();
            Node scopeBody = s.getBody();
            new NodeTraversal(this.compiler, new CollectNamedTypes(s)).traverse(scopeBody);
            ProcessScope ps = new ProcessScope(s);
            new NodeTraversal(this.compiler, ps).traverse(scopeBody);
            ps.finishProcessingScope();
        }
        this.reportInheritanceErrors();
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (Scope s : this.scopes) {
            s.finalizeScope();
        }
        Map<Node, String> unknownTypes = this.typeParser.getUnknownTypesMap();
        for (Node unknownTypeNode : unknownTypes.keySet()) {
            this.warnings.add(JSError.make(unknownTypeNode, UNRECOGNIZED_TYPE_NAME, unknownTypes.get(unknownTypeNode)));
        }
        for (String warningText : this.typeParser.getWarnings()) {
            this.warnings.add(JSError.make(root, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, warningText));
        }
        this.compiler.setSymbolTable(this);
    }

    private Collection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFinalized());
        Preconditions.checkArgument((boolean)nominalType.isInterface());
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            return ImmutableSet.of((Object)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFinalized());
        Preconditions.checkArgument((boolean)nominalType.isClass());
        if (nominalType.getPropDeclaredType(pname) == null) {
            return null;
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            return (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
        }
        return this.getPropDefFromClass(nominalType.getInstantiatedSuperclass(), pname);
    }

    private void reportInheritanceErrors() {
        LinkedList workset = Lists.newLinkedList(this.nominaltypesByNode.keySet());
        int iterations = 0;
        int MAX_ITERATIONS = 50000;
        block0: while (!workset.isEmpty()) {
            Preconditions.checkState((iterations < 50000 ? 1 : 0) != 0);
            Node funNode = (Node)workset.removeFirst();
            NominalType.RawNominalType rawNominalType = this.nominaltypesByNode.get(funNode);
            NominalType superClass = rawNominalType.getSuperClass();
            Set<String> nonInheritedPropNames = rawNominalType.getAllOwnProps();
            if (superClass != null && !superClass.isFinalized()) {
                workset.addLast(funNode);
                ++iterations;
                continue;
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                if (superInterf.isFinalized()) continue;
                workset.addLast(funNode);
                ++iterations;
                continue block0;
            }
            HashMultimap propMethodTypesToProcess = HashMultimap.create();
            HashMultimap propTypesToProcess = HashMultimap.create();
            if (superClass != null) {
                Preconditions.checkState((boolean)superClass.isFinalized());
                for (String pname : superClass.getAllPropsOfClass()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superClass, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (NominalType superInterf : rawNominalType.getInterfaces()) {
                Preconditions.checkState((boolean)superInterf.isFinalized());
                for (String pname : superInterf.getAllPropsOfInterface()) {
                    nonInheritedPropNames.remove(pname);
                    this.checkSuperProperty(rawNominalType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
                }
            }
            for (String pname : propMethodTypesToProcess.keySet()) {
                Collection methodTypes = propMethodTypesToProcess.get((Object)pname);
                Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
                PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawNominalType.getId(), (Object)pname);
                DeclaredFunctionType propDeclType = localPropDef.methodScope.getDeclaredType();
                DeclaredFunctionType superMethodType = DeclaredFunctionType.meet(methodTypes);
                propDeclType = propDeclType.withTypeInfoFromSuper(superMethodType);
                localPropDef.methodScope.setDeclaredType(propDeclType);
                propTypesToProcess.put((Object)pname, (Object)JSType.fromFunctionType(propDeclType.toFunctionType()));
            }
            block6: for (String pname : propTypesToProcess.keySet()) {
                Collection defs = propTypesToProcess.get((Object)pname);
                Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
                JSType resultType = JSType.TOP;
                for (JSType inheritedType : defs) {
                    if (inheritedType.isSubtypeOf(resultType)) {
                        resultType = inheritedType;
                        continue;
                    }
                    if (resultType.isSubtypeOf(inheritedType)) continue;
                    this.warnings.add(JSError.make(funNode, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, NodeUtil.getFunctionName(funNode), pname, "", ""));
                    continue block6;
                }
                rawNominalType.addProtoProperty(pname, resultType);
            }
            for (String pname : nonInheritedPropNames) {
                Node defSite = ((PropertyDef)this.propertyDefs.get((Object)Integer.valueOf((int)rawNominalType.getId()), (Object)pname)).defSite;
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
                if (jsdoc == null || !jsdoc.isOverride()) continue;
                this.warnings.add(JSError.make(defSite, TypeCheck.UNKNOWN_OVERRIDE, pname, rawNominalType.getName()));
            }
            rawNominalType.finalizeNominalType();
        }
    }

    private void checkSuperProperty(NominalType.RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> propMethodTypesToProcess, Multimap<String, JSType> propTypesToProcess) {
        JSType localPropType;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        ImmutableSet inheritedPropDefs = superType.isInterface() ? this.getPropDefsFromInterface(superType, pname) : ImmutableSet.of((Object)this.getPropDefFromClass(superType, pname));
        if (superType.isInterface() && current.isClass() && !current.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
            return;
        }
        PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)current.getId(), (Object)pname);
        JSType jSType = localPropType = localPropDef == null ? null : current.getPropDeclaredType(pname);
        if (localPropType != null && !localPropType.isSubtypeOf(inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
        } else if (localPropType == null) {
            propTypesToProcess.put((Object)pname, (Object)inheritedPropType);
        } else if (localPropDef.methodScope != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                propMethodTypesToProcess.put((Object)pname, (Object)inheritedPropDef.methodScope.getDeclaredType());
            }
        }
    }

    private JSType getTypeDeclarationFromJsdoc(JSDocInfo jsdoc, Scope s) {
        return this.typeParser.getNodeTypeDeclaration(jsdoc, null, s);
    }

    static class Scope
    implements DeclaredTypeRegistry {
        private final Scope parent;
        private final Node root;
        private final String name;
        private final String readableName;
        private final Map<String, JSType> locals = Maps.newHashMap();
        private final ArrayList<String> formals;
        private final Set<String> outerVars = Sets.newHashSet();
        private final Map<String, Scope> localFunDefs = Maps.newHashMap();
        private Map<String, NominalType.RawNominalType> localClassDefs = Maps.newHashMap();
        private Set<String> localNamespaces = Sets.newHashSet();
        private DeclaredFunctionType declaredType;

        private Scope(Node root, Scope parent, ArrayList<String> formals, DeclaredFunctionType declaredType) {
            if (parent == null) {
                this.name = null;
                this.readableName = null;
            } else {
                String nameOnAst = root.getFirstChild().getString();
                this.name = nameOnAst.equals("") ? null : nameOnAst;
                this.readableName = NodeUtil.getFunctionName(root);
            }
            this.root = root;
            this.parent = parent;
            this.formals = formals;
            this.declaredType = declaredType;
        }

        Node getRoot() {
            return this.root;
        }

        private Node getBody() {
            Preconditions.checkArgument((boolean)this.root.isFunction());
            return NodeUtil.getFunctionBody(this.root);
        }

        String getReadableName() {
            return this.readableName;
        }

        String getName() {
            return this.name;
        }

        private void setDeclaredType(DeclaredFunctionType declaredType) {
            this.declaredType = declaredType;
        }

        DeclaredFunctionType getDeclaredType() {
            return this.declaredType;
        }

        boolean isFunction() {
            return this.root.isFunction();
        }

        private boolean isConstructor() {
            if (!this.root.isFunction()) {
                return false;
            }
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(this.root);
            return fnDoc != null && fnDoc.isConstructor();
        }

        private boolean isPrototypeMethod() {
            Preconditions.checkArgument((this.root != null ? 1 : 0) != 0);
            return NodeUtil.isPrototypeMethod(this.root);
        }

        private void addLocalFunDef(String name, Scope scope) {
            this.localFunDefs.put(name, scope);
        }

        boolean isFormalParam(String name) {
            return this.formals.contains(name);
        }

        boolean isLocalVar(String name) {
            return this.locals.containsKey(name);
        }

        boolean isLocalFunDef(String name) {
            return this.localFunDefs.containsKey(name);
        }

        boolean isDefinedLocally(String name) {
            Preconditions.checkNotNull((Object)name);
            return this.locals.containsKey(name) || this.formals.contains(name) || this.localFunDefs.containsKey(name) || "this".equals(name);
        }

        private boolean isNamespace(String name) {
            return this.localNamespaces.contains(name);
        }

        private boolean isVisibleInScope(String name) {
            Preconditions.checkNotNull((Object)name);
            return this.isDefinedLocally(name) || name.equals(this.name) || this.parent != null && this.parent.isVisibleInScope(name);
        }

        private boolean isOuterVarEarly(String name) {
            return !this.isDefinedLocally(name) && this.parent != null && this.parent.isVisibleInScope(name);
        }

        boolean isUndeclaredFormal(String name) {
            return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
        }

        List<String> getFormals() {
            return Lists.newArrayList(this.formals);
        }

        Set<String> getOuterVars() {
            return Sets.newHashSet(this.outerVars);
        }

        Set<String> getLocalFunDefs() {
            return Sets.newHashSet(this.localFunDefs.keySet());
        }

        boolean isOuterVar(String name) {
            return this.outerVars.contains(name);
        }

        boolean hasThis() {
            return this.isFunction() && this.getDeclaredType().getThisType() != null;
        }

        private NominalType.RawNominalType getLocalNominalType(String name) {
            return this.localClassDefs.get(name);
        }

        @Override
        public JSType lookupTypeByName(String name) {
            NominalType.RawNominalType rawNominalType;
            if (this.declaredType != null && this.declaredType.isGeneric() && this.declaredType.getTypeParameters().contains((Object)name)) {
                return JSType.fromTypeVar(name);
            }
            if (this.localClassDefs != null && (rawNominalType = this.localClassDefs.get(name)) != null) {
                return JSType.fromObjectType(ObjectType.fromNominalType(NominalType.fromRaw(rawNominalType)));
            }
            return this.parent == null ? null : this.parent.lookupTypeByName(name);
        }

        JSType getDeclaredTypeOf(String name) {
            Preconditions.checkArgument((name.indexOf(46) == -1 ? 1 : 0) != 0);
            if ("this".equals(name)) {
                if (!this.hasThis()) {
                    return null;
                }
                return JSType.fromObjectType(ObjectType.fromNominalType(this.getDeclaredType().getThisType()));
            }
            int formalIndex = this.formals.indexOf(name);
            if (formalIndex != -1) {
                JSType formalType = this.declaredType.getFormalType(formalIndex);
                if (formalType != null && formalType.isBottom()) {
                    return null;
                }
                return formalType;
            }
            JSType localType = this.locals.get(name);
            if (localType != null) {
                return localType;
            }
            Scope s = this.localFunDefs.get(name);
            if (s != null) {
                return JSType.fromFunctionType(s.getDeclaredType().toFunctionType());
            }
            if (name.equals(this.name)) {
                return JSType.fromFunctionType(this.getDeclaredType().toFunctionType());
            }
            if (this.parent != null) {
                return this.parent.getDeclaredTypeOf(name);
            }
            return null;
        }

        private Scope getScopeHelper(String fnName) {
            Scope s = this.localFunDefs.get(fnName);
            if (s != null) {
                return s;
            }
            if (this.parent != null) {
                return this.parent.getScopeHelper(fnName);
            }
            return null;
        }

        boolean isKnownFunction(String fnName) {
            return this.getScopeHelper(fnName) != null;
        }

        Scope getScope(String fnName) {
            Scope s = this.getScopeHelper(fnName);
            Preconditions.checkState((s != null ? 1 : 0) != 0);
            return s;
        }

        Set<String> getLocals() {
            return ImmutableSet.copyOf(this.locals.keySet());
        }

        private void addLocal(String name, JSType declType) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.locals.put(name, declType);
        }

        private void addNamespace(String name) {
            Preconditions.checkArgument((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.locals.put(name, JSType.TOP_OBJECT);
            this.localNamespaces.add(name);
        }

        private void updateTypeOfLocal(String name, JSType newDeclType) {
            this.locals.put(name, newDeclType);
        }

        private void addOuterVar(String name) {
            this.outerVars.add(name);
        }

        private void addNominalType(String name, NominalType.RawNominalType rawNominalType) {
            this.localClassDefs.put(name, rawNominalType);
        }

        private void finalizeScope() {
            Iterator<String> it = this.localFunDefs.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                if (!name.contains(".")) continue;
                it.remove();
            }
            this.localNamespaces = null;
            this.localClassDefs = null;
        }
    }

    private static class PropertyDef {
        Node defSite;
        Scope methodScope;

        PropertyDef(Node defSite, Scope methodScope) {
            Preconditions.checkArgument((boolean)defSite.isGetProp());
            this.defSite = defSite;
            this.methodScope = methodScope;
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;
        private final Multimap<String, Node> undeclaredVars;

        ProcessScope(Scope currentScope) {
            this.currentScope = currentScope;
            this.undeclaredVars = HashMultimap.create();
        }

        void finishProcessingScope() {
            for (Node nameNode : this.undeclaredVars.values()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, VarCheck.UNDEFINED_VAR_ERROR, nameNode.getString()));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && (grandparent.isVar() || NodeUtil.isPrototypePropertyDeclaration(grandparent))) break;
                    this.visitFunctionDef(n, null);
                    break;
                }
                case 38: {
                    String name = n.getString();
                    if (name == null || "undefined".equals(name) || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        if (this.currentScope.isDefinedLocally(name)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(n, VariableReferenceCheck.REDECLARED_VARIABLE, name));
                            break;
                        }
                        for (Node useBeforeDeclNode : this.undeclaredVars.get((Object)name)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(useBeforeDeclNode, VariableReferenceCheck.UNDECLARED_REFERENCE, name));
                        }
                        this.undeclaredVars.removeAll((Object)name);
                        Node initializer = n.getFirstChild();
                        if (initializer != null && initializer.isFunction()) {
                            this.visitFunctionDef(initializer, null);
                            break;
                        }
                        if (initializer != null && NodeUtil.isNamespaceDecl(n)) {
                            this.currentScope.addNamespace(name);
                            break;
                        }
                        this.currentScope.addLocal(name, parent.isVar() ? this.getVarTypeFromAnnotation(n) : JSType.UNKNOWN);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name)) break;
                    this.undeclaredVars.put((Object)name, (Object)n);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult()) break;
                    this.visitPropertyDeclaration(n);
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case 155: {
                    GlobalTypeInfo.this.castTypes.put(n, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(n.getJSDocInfo(), this.currentScope));
                    break;
                }
                case 64: {
                    for (Node prop : n.children()) {
                        if (prop.getJSDocInfo() == null) continue;
                        GlobalTypeInfo.this.declaredObjLitProps.put(prop, GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(prop.getJSDocInfo(), this.currentScope));
                    }
                    break;
                }
            }
        }

        private void visitPropertyDeclaration(Node getProp) {
            if (this.isClassPropAccess(getProp, this.currentScope)) {
                this.visitClassPropertyDeclaration(getProp);
                return;
            }
            if (this.isPropDecl(getProp) && NodeUtil.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
                return;
            }
            if (this.isPropDecl(getProp) && this.isStaticCtorProp(getProp, this.currentScope)) {
                this.visitConstructorPropertyDeclaration(getProp);
                return;
            }
            if (this.isPropDecl(getProp) && this.currentScope.isNamespace(getProp.getFirstChild().getQualifiedName())) {
                this.visitNamespacePropertyDeclaration(getProp);
            }
        }

        private boolean isClassPropAccess(Node n, Scope s) {
            return n.isGetProp() && n.getFirstChild().isThis() && (s.isConstructor() || s.isPrototypeMethod());
        }

        private boolean isStaticCtorProp(Node getProp, Scope s) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            String receiverObjName = getProp.getFirstChild().getQualifiedName();
            return s.isLocalFunDef(receiverObjName) && s.getScope(receiverObjName).getDeclaredType().getNominalType() != null;
        }

        private boolean isPropDecl(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            return parent.isExprResult() || parent.isAssign() && parent.getParent().isExprResult();
        }

        private Scope visitFunctionDef(Node fn, NominalType.RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            Scope fnScope = this.computeFnDeclaredType(fn, ownerType, this.currentScope);
            GlobalTypeInfo.this.scopes.addFirst(fnScope);
            String fnName = NodeUtil.getFunctionName(fn);
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            if (fnName != null && this.currentScope.isDefinedLocally(fnName)) {
                if (!fnName.contains(".")) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, VariableReferenceCheck.REDECLARED_VARIABLE, fnName));
                }
                if (internalName.startsWith(GlobalTypeInfo.ANON_FUN_PREFIX)) {
                    this.currentScope.addLocalFunDef(internalName, this.currentScope.getScope(fnName));
                }
            } else {
                this.currentScope.addLocalFunDef(internalName, fnScope);
                if (fnName != null && fnName.contains(".")) {
                    this.currentScope.addLocalFunDef(fnName, fnScope);
                }
            }
            if (fnName != null && !fnName.contains(".")) {
                this.undeclaredVars.removeAll((Object)fnName);
            }
            GlobalTypeInfo.this.scopeWorkset.add(fnScope);
            return fnScope;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            JSType propDeclType;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node initializer = parent.isAssign() ? parent.getLastChild() : null;
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            String ctorName = ctorNameNode.getQualifiedName();
            if (!this.currentScope.isDefinedLocally(ctorName)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
                return;
            }
            NominalType.RawNominalType rawType = this.currentScope.getLocalNominalType(ctorName);
            if (rawType == null) {
                return;
            }
            String pname = NodeUtil.getPrototypePropertyName(getProp);
            Scope methodScope = null;
            if (initializer != null && initializer.isFunction()) {
                methodScope = this.visitFunctionDef(initializer, rawType);
                propDeclType = JSType.fromFunctionType(methodScope.getDeclaredType().toFunctionType());
            } else {
                propDeclType = GlobalTypeInfo.this.typeParser.getNodeTypeDeclaration(NodeUtil.getBestJSDocInfo(getProp), rawType, this.currentScope);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawType.getId(), (Object)pname, (Object)new PropertyDef(getProp, methodScope));
            if (propDeclType != null) {
                if (this.mayWarnAboutExistingProp(rawType, pname, getProp)) {
                    return;
                }
                rawType.addProtoProperty(pname, propDeclType);
            } else {
                rawType.addUndeclaredProtoProperty(pname);
            }
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            String ctorName = getProp.getFirstChild().getQualifiedName();
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            NominalType.RawNominalType classType = this.currentScope.getLocalNominalType(ctorName);
            String pname = getProp.getLastChild().getString();
            JSType propDeclType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            if (propDeclType != null) {
                if (classType.hasCtorProp(pname) && classType.getCtorPropDeclaredType(pname) != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, classType.toString()));
                    return;
                }
                classType.addCtorProperty(pname, propDeclType);
            } else {
                classType.addUndeclaredCtorProperty(pname);
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            QualifiedName qname = QualifiedName.fromGetprop(getProp);
            String leftmost = qname.getLeftmostName();
            QualifiedName allButLeftmost = qname.getAllButLeftmost();
            JSType typeInJsdoc = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            JSType currentType = this.currentScope.getDeclaredTypeOf(leftmost);
            if (typeInJsdoc == null) {
                this.currentScope.updateTypeOfLocal(leftmost, currentType.withProperty(allButLeftmost, JSType.UNKNOWN));
                return;
            }
            if (currentType.mayHaveProp(allButLeftmost) && currentType.getDeclaredProp(allButLeftmost) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, getProp.getQualifiedName(), currentType.toString()));
                return;
            }
            this.currentScope.updateTypeOfLocal(leftmost, currentType.withDeclaredProperty(allButLeftmost, typeInJsdoc));
        }

        private void visitClassPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            NominalType thisType = this.currentScope.getDeclaredType().getThisType();
            NominalType.RawNominalType rawNominalType = thisType.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declaredType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            if (declaredType != null) {
                this.mayWarnAboutExistingProp(rawNominalType, pname, getProp);
                rawNominalType.addClassProperty(pname, declaredType);
            } else {
                rawNominalType.addUndeclaredClassProperty(pname);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawNominalType.getId(), (Object)pname, (Object)new PropertyDef(getProp, null));
        }

        private boolean mayWarnAboutExistingProp(NominalType.RawNominalType classType, String pname, Node propCreationNode) {
            if (classType.mayHaveOwnProp(pname) && classType.getPropDeclaredType(pname) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, classType.toString()));
                return true;
            }
            return false;
        }

        private Scope computeFnDeclaredType(Node fn, NominalType.RawNominalType ownerType, Scope parentScope) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            ImmutableList<String> typeParameters = fnDoc == null ? null : fnDoc.getTemplateTypeNames();
            FunctionTypeBuilder builder = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, fn, ownerType, parentScope);
            String functionName = GlobalTypeInfo.this.getFunInternalName(fn);
            if (fnDoc != null) {
                NominalType parentClass = null;
                if (fnDoc.hasBaseType()) {
                    if (!fnDoc.isConstructor()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
                    } else {
                        Node docNode = fnDoc.getBaseType().getRootNode();
                        if (GlobalTypeInfo.this.typeParser.hasKnownType(docNode, ownerType, parentScope, typeParameters)) {
                            parentClass = GlobalTypeInfo.this.typeParser.getNominalType(docNode, ownerType, parentScope, typeParameters);
                            if (parentClass == null) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(fn, EXTENDS_NON_OBJECT, functionName, docNode.toStringTree()));
                            } else if (!parentClass.isClass()) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(fn, TypeCheck.CONFLICTING_EXTENDED_TYPE, "constructor", functionName));
                                parentClass = null;
                            }
                        }
                    }
                }
                NominalType.RawNominalType rawNominalType = (NominalType.RawNominalType)GlobalTypeInfo.this.nominaltypesByNode.get(fn);
                if (fnDoc.isConstructor()) {
                    if (parentClass != null && !rawNominalType.addSuperClass(parentClass)) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, INHERITANCE_CYCLE, rawNominalType.toString()));
                    }
                    boolean noCycles = rawNominalType.addInterfaces(GlobalTypeInfo.this.typeParser.getImplementedInterfaces(fnDoc, ownerType, parentScope, typeParameters));
                    Preconditions.checkState((boolean)noCycles);
                    builder.addNominalType(NominalType.fromRaw(rawNominalType));
                } else if (fnDoc.isInterface()) {
                    boolean noCycles;
                    ImmutableSet<NominalType> implemented;
                    if (!NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(fn))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, INTERFACE_WITH_A_BODY, new String[0]));
                    }
                    if (!(implemented = GlobalTypeInfo.this.typeParser.getImplementedInterfaces(fnDoc, ownerType, parentScope, typeParameters)).isEmpty()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, TypeCheck.CONFLICTING_IMPLEMENTED_TYPE, functionName));
                    }
                    if (!(noCycles = rawNominalType.addInterfaces(GlobalTypeInfo.this.typeParser.getExtendedInterfaces(fnDoc, ownerType, parentScope, typeParameters)))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, INHERITANCE_CYCLE, rawNominalType.toString()));
                    }
                    builder.addNominalType(NominalType.fromRaw(rawNominalType));
                }
            }
            if (NodeUtil.isPrototypeMethod(fn)) {
                Node lhsNode = fn.getParent().getFirstChild();
                String className = NodeUtil.getPrototypeClassName(lhsNode).getQualifiedName();
                builder.addReceiverType(parentScope.getScope(className).getDeclaredType().getNominalType());
            }
            DeclaredFunctionType declFunType = builder.buildDeclaration();
            ArrayList formals = Lists.newArrayList();
            Node param = NodeUtil.getFunctionParameters(fn).getFirstChild();
            int optionalArity = declFunType.getOptionalArity();
            int formalIndex = 0;
            while (param != null) {
                if (!GlobalTypeInfo.this.typeParser.isRestArg(fnDoc, param.getString()) || formalIndex < optionalArity) {
                    formals.add(param.getString());
                }
                param = param.getNext();
                ++formalIndex;
            }
            return new Scope(fn, parentScope, formals, declFunType);
        }

        private JSType getVarTypeFromAnnotation(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
            Node varNode = nameNode.getParent();
            JSType varType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(varNode.getJSDocInfo(), this.currentScope);
            if (varNode.getChildCount() > 1 && varType != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(varNode, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
            }
            String varName = nameNode.getString();
            JSType nameNodeType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(nameNode.getJSDocInfo(), this.currentScope);
            if (nameNodeType != null) {
                if (varType != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
                }
                return nameNodeType;
            }
            return varType;
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;

        CollectNamedTypes(Scope s) {
            this.currentScope = s;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                this.initFnScope(n, this.currentScope);
            }
        }

        private void initFnScope(Node fn, Scope parentScope) {
            JSDocInfo fnDoc;
            String qname = NodeUtil.getFunctionName(fn);
            if (qname == null || qname.contains(".")) {
                GlobalTypeInfo.this.anonFunNames.put(fn, GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId);
                GlobalTypeInfo.this.freshId++;
            }
            if ((fnDoc = NodeUtil.getFunctionJSDocInfo(fn)) != null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                ImmutableList<String> typeParameters = fnDoc.getTemplateTypeNames();
                NominalType.RawNominalType rawNominalType = fnDoc.isInterface() ? NominalType.RawNominalType.makeInterface(qname, typeParameters) : (fnDoc.makesStructs() ? NominalType.RawNominalType.makeStructClass(qname, typeParameters) : (fnDoc.makesDicts() ? NominalType.RawNominalType.makeDictClass(qname, typeParameters) : NominalType.RawNominalType.makeUnrestrictedClass(qname, typeParameters)));
                GlobalTypeInfo.this.nominaltypesByNode.put(fn, rawNominalType);
                parentScope.addNominalType(qname, rawNominalType);
            }
        }
    }
}

