/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.BlockFuzzer;
import com.google.javascript.jscomp.fuzzing.Dispatcher;
import com.google.javascript.jscomp.fuzzing.ExpressionFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.jscomp.fuzzing.VarFuzzer;
import com.google.javascript.rhino.Node;
import java.util.Set;

class ForFuzzer
extends AbstractFuzzer {
    ForFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 2;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int totalHeaderBudget = (int)((double)(budget - 1) * this.getOwnConfig().optDouble("headBudget"));
        int bodyBudget = budget - 1 - totalHeaderBudget;
        ExpressionFuzzer exprFuzzer = new ExpressionFuzzer(this.context);
        AbstractFuzzer[] fuzzers = new AbstractFuzzer[]{new ForInitializerFuzzer(this.context), exprFuzzer, exprFuzzer};
        Node[] headers = this.distribute(totalHeaderBudget, fuzzers);
        Node node = new Node(115, headers);
        ++this.context.scopeManager.localScope().loopNesting;
        Node body = new BlockFuzzer(this.context).generate(bodyBudget);
        --this.context.scopeManager.localScope().loopNesting;
        node.addChildToBack(body);
        return node;
    }

    @Override
    protected Node fuzz(AbstractFuzzer fuzzer, int budget) {
        if (fuzzer.isEnough(budget)) {
            return fuzzer.generate(budget);
        }
        return new Node(124);
    }

    @Override
    protected String getConfigName() {
        return "for";
    }

    private class ForInitializerFuzzer
    extends Dispatcher {
        ForInitializerFuzzer(FuzzingContext context) {
            super(context);
        }

        @Override
        protected void initCandidates() {
            this.candidates = new AbstractFuzzer[]{new VarFuzzer(this.context), new ExpressionFuzzer(this.context)};
        }

        @Override
        protected String getConfigName() {
            return "forInitializer";
        }
    }
}

