/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ModuleImportTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;

abstract class NewTypeSafeDispatcher<T> {
    NewTypeSafeDispatcher() {
    }

    abstract T processArrayLiteral(ArrayLiteralExpressionTree var1);

    abstract T processAstRoot(ProgramTree var1);

    abstract T processBlock(BlockTree var1);

    abstract T processBreakStatement(BreakStatementTree var1);

    abstract T processCatchClause(CatchTree var1);

    abstract T processConditionalExpression(ConditionalExpressionTree var1);

    abstract T processContinueStatement(ContinueStatementTree var1);

    abstract T processDoLoop(DoWhileStatementTree var1);

    abstract T processElementGet(MemberLookupExpressionTree var1);

    abstract T processEmptyStatement(EmptyStatementTree var1);

    abstract T processExpressionStatement(ExpressionStatementTree var1);

    abstract T processForInLoop(ForInStatementTree var1);

    abstract T processForLoop(ForStatementTree var1);

    abstract T processFunctionCall(CallExpressionTree var1);

    abstract T processFunction(FunctionDeclarationTree var1);

    abstract T processIfStatement(IfStatementTree var1);

    abstract T processBinaryExpression(BinaryOperatorTree var1);

    abstract T processLabeledStatement(LabelledStatementTree var1);

    abstract T processName(IdentifierExpressionTree var1);

    abstract T processNewExpression(NewExpressionTree var1);

    abstract T processNumberLiteral(LiteralExpressionTree var1);

    abstract T processObjectLiteral(ObjectLiteralExpressionTree var1);

    abstract T processParenthesizedExpression(ParenExpressionTree var1);

    abstract T processPropertyGet(MemberExpressionTree var1);

    abstract T processRegExpLiteral(LiteralExpressionTree var1);

    abstract T processReturnStatement(ReturnStatementTree var1);

    abstract T processStringLiteral(LiteralExpressionTree var1);

    abstract T processSwitchCase(CaseClauseTree var1);

    abstract T processSwitchStatement(SwitchStatementTree var1);

    abstract T processThrowStatement(ThrowStatementTree var1);

    abstract T processTryStatement(TryStatementTree var1);

    abstract T processUnaryExpression(UnaryExpressionTree var1);

    abstract T processVariableStatement(VariableStatementTree var1);

    abstract T processVariableDeclarationList(VariableDeclarationListTree var1);

    abstract T processVariableDeclaration(VariableDeclarationTree var1);

    abstract T processWhileLoop(WhileStatementTree var1);

    abstract T processWithStatement(WithStatementTree var1);

    abstract T processDebuggerStatement(DebuggerStatementTree var1);

    abstract T processThisExpression(ThisExpressionTree var1);

    abstract T processSwitchDefault(DefaultClauseTree var1);

    abstract T processBooleanLiteral(LiteralExpressionTree var1);

    abstract T processNullLiteral(LiteralExpressionTree var1);

    abstract T processNull(NullTree var1);

    abstract T processPostfixExpression(PostfixExpressionTree var1);

    abstract T processCommaExpression(CommaExpressionTree var1);

    abstract T processFinally(FinallyTree var1);

    abstract T processGetAccessor(GetAccessorTree var1);

    abstract T processSetAccessor(SetAccessorTree var1);

    abstract T processPropertyNameAssignment(PropertyNameAssignmentTree var1);

    abstract T processFormalParameterList(FormalParameterListTree var1);

    abstract T processClassDeclaration(ClassDeclarationTree var1);

    abstract T processSuper(SuperExpressionTree var1);

    abstract T processYield(YieldExpressionTree var1);

    abstract T processForOf(ForOfStatementTree var1);

    abstract T processExportDecl(ExportDeclarationTree var1);

    abstract T processExportSpec(ExportSpecifierTree var1);

    abstract T processImportDecl(ImportDeclarationTree var1);

    abstract T processImportSpec(ImportSpecifierTree var1);

    abstract T processModuleImport(ModuleImportTree var1);

    abstract T processMissingExpression(MissingPrimaryExpressionTree var1);

    abstract T processIllegalToken(ParseTree var1);

    abstract T unsupportedLanguageFeature(ParseTree var1, String var2);

    final T processLiteralExpression(LiteralExpressionTree expr) {
        switch (expr.literalToken.type) {
            case NUMBER: {
                return this.processNumberLiteral(expr);
            }
            case STRING: {
                return this.processStringLiteral(expr);
            }
            case FALSE: 
            case TRUE: {
                return this.processBooleanLiteral(expr);
            }
            case NULL: {
                return this.processNullLiteral(expr);
            }
            case REGULAR_EXPRESSION: {
                return this.processRegExpLiteral(expr);
            }
        }
        throw new IllegalStateException("Unexpected literal type: " + expr.literalToken.getClass() + " type: " + expr.literalToken.type.toString());
    }

    public T process(ParseTree node) {
        switch (node.type) {
            case BINARY_OPERATOR: {
                return this.processBinaryExpression(node.asBinaryOperator());
            }
            case ARRAY_LITERAL_EXPRESSION: {
                return this.processArrayLiteral(node.asArrayLiteralExpression());
            }
            case UNARY_EXPRESSION: {
                return this.processUnaryExpression(node.asUnaryExpression());
            }
            case BLOCK: {
                return this.processBlock(node.asBlock());
            }
            case BREAK_STATEMENT: {
                return this.processBreakStatement(node.asBreakStatement());
            }
            case CALL_EXPRESSION: {
                return this.processFunctionCall(node.asCallExpression());
            }
            case CASE_CLAUSE: {
                return this.processSwitchCase(node.asCaseClause());
            }
            case DEFAULT_CLAUSE: {
                return this.processSwitchDefault(node.asDefaultClause());
            }
            case CATCH: {
                return this.processCatchClause(node.asCatch());
            }
            case CONTINUE_STATEMENT: {
                return this.processContinueStatement(node.asContinueStatement());
            }
            case DO_WHILE_STATEMENT: {
                return this.processDoLoop(node.asDoWhileStatement());
            }
            case EMPTY_STATEMENT: {
                return this.processEmptyStatement(node.asEmptyStatement());
            }
            case EXPRESSION_STATEMENT: {
                return this.processExpressionStatement(node.asExpressionStatement());
            }
            case DEBUGGER_STATEMENT: {
                return this.processDebuggerStatement(node.asDebuggerStatement());
            }
            case THIS_EXPRESSION: {
                return this.processThisExpression(node.asThisExpression());
            }
            case FOR_STATEMENT: {
                return this.processForLoop(node.asForStatement());
            }
            case FOR_IN_STATEMENT: {
                return this.processForInLoop(node.asForInStatement());
            }
            case FUNCTION_DECLARATION: {
                return this.processFunction(node.asFunctionDeclaration());
            }
            case MEMBER_LOOKUP_EXPRESSION: {
                return this.processElementGet(node.asMemberLookupExpression());
            }
            case MEMBER_EXPRESSION: {
                return this.processPropertyGet(node.asMemberExpression());
            }
            case CONDITIONAL_EXPRESSION: {
                return this.processConditionalExpression(node.asConditionalExpression());
            }
            case IF_STATEMENT: {
                return this.processIfStatement(node.asIfStatement());
            }
            case LABELLED_STATEMENT: {
                return this.processLabeledStatement(node.asLabelledStatement());
            }
            case PAREN_EXPRESSION: {
                return this.processParenthesizedExpression(node.asParenExpression());
            }
            case IDENTIFIER_EXPRESSION: {
                return this.processName(node.asIdentifierExpression());
            }
            case NEW_EXPRESSION: {
                return this.processNewExpression(node.asNewExpression());
            }
            case OBJECT_LITERAL_EXPRESSION: {
                return this.processObjectLiteral(node.asObjectLiteralExpression());
            }
            case RETURN_STATEMENT: {
                return this.processReturnStatement(node.asReturnStatement());
            }
            case POSTFIX_EXPRESSION: {
                return this.processPostfixExpression(node.asPostfixExpression());
            }
            case PROGRAM: {
                return this.processAstRoot(node.asProgram());
            }
            case LITERAL_EXPRESSION: {
                return this.processLiteralExpression(node.asLiteralExpression());
            }
            case SWITCH_STATEMENT: {
                return this.processSwitchStatement(node.asSwitchStatement());
            }
            case THROW_STATEMENT: {
                return this.processThrowStatement(node.asThrowStatement());
            }
            case TRY_STATEMENT: {
                return this.processTryStatement(node.asTryStatement());
            }
            case VARIABLE_STATEMENT: {
                return this.processVariableStatement(node.asVariableStatement());
            }
            case VARIABLE_DECLARATION_LIST: {
                return this.processVariableDeclarationList(node.asVariableDeclarationList());
            }
            case VARIABLE_DECLARATION: {
                return this.processVariableDeclaration(node.asVariableDeclaration());
            }
            case WHILE_STATEMENT: {
                return this.processWhileLoop(node.asWhileStatement());
            }
            case WITH_STATEMENT: {
                return this.processWithStatement(node.asWithStatement());
            }
            case COMMA_EXPRESSION: {
                return this.processCommaExpression(node.asCommaExpression());
            }
            case NULL: {
                return this.processNull(node.asNull());
            }
            case FINALLY: {
                return this.processFinally(node.asFinally());
            }
            case MISSING_PRIMARY_EXPRESSION: {
                return this.processMissingExpression(node.asMissingPrimaryExpression());
            }
            case PROPERTY_NAME_ASSIGNMENT: {
                return this.processPropertyNameAssignment(node.asPropertyNameAssignment());
            }
            case GET_ACCESSOR: {
                return this.processGetAccessor(node.asGetAccessor());
            }
            case SET_ACCESSOR: {
                return this.processSetAccessor(node.asSetAccessor());
            }
            case FORMAL_PARAMETER_LIST: {
                return this.processFormalParameterList(node.asFormalParameterList());
            }
            case CLASS_DECLARATION: {
                return this.processClassDeclaration(node.asClassDeclaration());
            }
            case SUPER_EXPRESSION: {
                return this.processSuper(node.asSuperExpression());
            }
            case YIELD_EXPRESSION: {
                return this.processYield(node.asYieldStatement());
            }
            case FOR_OF_STATEMENT: {
                return this.processForOf(node.asForOfStatement());
            }
            case EXPORT_DECLARATION: {
                return this.processExportDecl(node.asExportDeclaration());
            }
            case EXPORT_SPECIFIER: {
                return this.processExportSpec(node.asExportSpecifier());
            }
            case IMPORT_DECLARATION: {
                return this.processImportDecl(node.asImportDeclaration());
            }
            case IMPORT_SPECIFIER: {
                return this.processImportSpec(node.asImportSpecifier());
            }
            case MODULE_IMPORT: {
                return this.processModuleImport(node.asModuleImport());
            }
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: 
            case OBJECT_PATTERN_FIELD: 
            case SPREAD_PATTERN_ELEMENT: {
                return this.unsupportedLanguageFeature(node, "destructuring");
            }
            case DEFAULT_PARAMETER: {
                return this.unsupportedLanguageFeature(node, "default parameters");
            }
            case REST_PARAMETER: {
                return this.unsupportedLanguageFeature(node, "rest parameters");
            }
            case SPREAD_EXPRESSION: {
                return this.unsupportedLanguageFeature(node, "spread parameters");
            }
            case ARGUMENT_LIST: {
                break;
            }
        }
        return this.processIllegalToken(node);
    }
}

