/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashSet;
import java.util.Set;

class DeclaredGlobalExternsOnWindow
extends NodeTraversal.AbstractShallowStatementCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<String> names = new LinkedHashSet<String>();

    public DeclaredGlobalExternsOnWindow(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        this.addWindowProperties();
    }

    private void addWindowProperties() {
        if (this.names.size() > 0) {
            Node declRoot = this.getSynthesizedExternsRoot();
            for (String prop : this.names) {
                this.addExtern(declRoot, prop);
            }
            this.compiler.reportCodeChange();
        }
    }

    private void addExtern(Node declRoot, String export) {
        Node propstmt = IR.exprResult(IR.getprop(IR.name("window"), IR.string(export)));
        declRoot.addChildToBack(propstmt);
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isFunction()) {
            this.names.add(n.getFirstChild().getString());
        } else if (n.isVar()) {
            for (Node c : n.children()) {
                this.names.add(c.getString());
            }
        }
    }
}

