/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.parsing.Comment;
import com.google.javascript.jscomp.parsing.CommentWrapper;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.IRFactory;
import com.google.javascript.jscomp.parsing.NewIRFactory;
import com.google.javascript.jscomp.parsing.parser.Parser;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.head.CompilerEnvirons;
import com.google.javascript.rhino.head.Context;
import com.google.javascript.rhino.head.EvaluatorException;
import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.AstRoot;
import com.google.javascript.rhino.head.ast.NodeVisitor;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;

public class ParserRunner {
    private static final String CONFIG_RESOURCE = "com.google.javascript.jscomp.parsing.ParserConfig";
    private static Set<String> annotationNames = null;
    private static Set<String> suppressionNames = null;
    private static Set<String> reservedVars = null;
    private static boolean useExperimentalParser = false;

    private ParserRunner() {
    }

    public static Config createConfig(boolean isIdeMode, Config.LanguageMode languageMode, boolean acceptConstKeyword) {
        return ParserRunner.createConfig(isIdeMode, languageMode, acceptConstKeyword, null);
    }

    public static Config createConfig(boolean isIdeMode, Config.LanguageMode languageMode, boolean acceptConstKeyword, Set<String> extraAnnotationNames) {
        return ParserRunner.createConfig(isIdeMode, languageMode, acceptConstKeyword, extraAnnotationNames, false);
    }

    public static Config createConfig(boolean isIdeMode, Config.LanguageMode languageMode, boolean acceptConstKeyword, Set<String> extraAnnotationNames, boolean useExperimentalParser) {
        Set<String> effectiveAnnotationNames;
        ParserRunner.initResourceConfig();
        if (extraAnnotationNames == null) {
            effectiveAnnotationNames = annotationNames;
        } else {
            effectiveAnnotationNames = new HashSet<String>(annotationNames);
            effectiveAnnotationNames.addAll(extraAnnotationNames);
        }
        return new Config(effectiveAnnotationNames, suppressionNames, isIdeMode, languageMode, acceptConstKeyword, useExperimentalParser);
    }

    public static Set<String> getReservedVars() {
        ParserRunner.initResourceConfig();
        return reservedVars;
    }

    private static synchronized void initResourceConfig() {
        if (annotationNames != null) {
            return;
        }
        ResourceBundle config = ResourceBundle.getBundle(CONFIG_RESOURCE);
        annotationNames = ParserRunner.extractList(config.getString("jsdoc.annotations"));
        suppressionNames = ParserRunner.extractList(config.getString("jsdoc.suppressions"));
        reservedVars = ParserRunner.extractList(config.getString("compiler.reserved.vars"));
    }

    private static Set<String> extractList(String configProp) {
        String[] names = configProp.split(",");
        HashSet trimmedNames = Sets.newHashSet();
        for (String name : names) {
            trimmedNames.add(name.trim());
        }
        return ImmutableSet.copyOf((Collection)trimmedNames);
    }

    public static ParseResult parse(StaticSourceFile sourceFile, String sourceString, Config config, com.google.javascript.rhino.head.ErrorReporter errorReporter, Logger logger) throws IOException {
        if (!ParserRunner.useExperimentalParser(config)) {
            return ParserRunner.parseEs5(sourceFile, sourceString, config, errorReporter, logger);
        }
        return ParserRunner.parseEs6(sourceFile, sourceString, config, errorReporter, logger);
    }

    private static boolean useExperimentalParser(Config config) {
        return useExperimentalParser || config.languageMode == Config.LanguageMode.ECMASCRIPT6 || config.languageMode == Config.LanguageMode.ECMASCRIPT6_STRICT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult parseEs5(StaticSourceFile sourceFile, String sourceString, Config config, com.google.javascript.rhino.head.ErrorReporter errorReporter, Logger logger) throws IOException {
        Context cx = Context.enter();
        cx.setErrorReporter(errorReporter);
        cx.setLanguageVersion(150);
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        compilerEnv.initFromContext(cx);
        compilerEnv.setRecordingComments(true);
        compilerEnv.setRecordingLocalJsDocComments(true);
        compilerEnv.setWarnTrailingComma(config.languageMode == Config.LanguageMode.ECMASCRIPT3);
        compilerEnv.setReservedKeywordAsIdentifier(true);
        compilerEnv.setAllowMemberExprAsFunctionName(false);
        compilerEnv.setIdeMode(config.isIdeMode);
        compilerEnv.setRecoverFromErrors(config.isIdeMode);
        com.google.javascript.rhino.head.Parser p = new com.google.javascript.rhino.head.Parser(compilerEnv, errorReporter);
        AstRoot astRoot = null;
        try {
            astRoot = p.parse(sourceString, sourceFile.getName(), 1);
        }
        catch (EvaluatorException e) {
            logger.info("Error parsing " + sourceFile.getName() + ": " + e.getMessage());
        }
        finally {
            Context.exit();
        }
        Node root = null;
        final ArrayList comments = Lists.newArrayList();
        if (astRoot != null) {
            root = IRFactory.transformTree(astRoot, sourceFile, sourceString, config, errorReporter);
            root.setIsSyntheticBlock(true);
            if (config.isIdeMode) {
                astRoot.visitAll(new NodeVisitor(){

                    @Override
                    public boolean visit(AstNode node) {
                        if (node.getType() == 161) {
                            comments.add(new CommentWrapper((com.google.javascript.rhino.head.ast.Comment)node));
                        }
                        return true;
                    }
                });
            }
        }
        return new ParseResult(root, comments);
    }

    public static ParseResult parseEs6(StaticSourceFile sourceFile, String sourceString, Config config, com.google.javascript.rhino.head.ErrorReporter errorReporter, Logger logger) throws IOException {
        SourceFile file = new SourceFile(sourceFile.getName(), sourceString);
        Es6ErrorReporter es6ErrorReporter = new Es6ErrorReporter(errorReporter, file, config);
        Parser.Config es6config = new Parser.Config(ParserRunner.mode(config.languageMode));
        Parser p = new Parser(es6config, es6ErrorReporter, file);
        ProgramTree tree = null;
        try {
            tree = p.parseProgram();
        }
        catch (EvaluatorException e) {
            logger.info("Error parsing " + sourceFile.getName() + ": " + e.getMessage());
        }
        Node root = null;
        Object comments = ImmutableList.of();
        if (tree != null && (!es6ErrorReporter.hadError() || config.isIdeMode)) {
            root = NewIRFactory.transformTree(tree, sourceFile, sourceString, config, errorReporter);
            root.setIsSyntheticBlock(true);
            if (config.isIdeMode) {
                List<com.google.javascript.jscomp.parsing.parser.trees.Comment> parserComments = p.getComments();
                comments = Lists.newArrayListWithCapacity((int)parserComments.size());
                for (com.google.javascript.jscomp.parsing.parser.trees.Comment c : parserComments) {
                    comments.add(new CommentWrapper(c));
                }
            }
        }
        return new ParseResult(root, (List<Comment>)comments);
    }

    private static Parser.Config.Mode mode(Config.LanguageMode mode) {
        switch (mode) {
            case ECMASCRIPT3: {
                return Parser.Config.Mode.ES3;
            }
            case ECMASCRIPT5: {
                return Parser.Config.Mode.ES5;
            }
            case ECMASCRIPT5_STRICT: {
                return Parser.Config.Mode.ES5_STRICT;
            }
            case ECMASCRIPT6: {
                return Parser.Config.Mode.ES6;
            }
            case ECMASCRIPT6_STRICT: {
                return Parser.Config.Mode.ES5_STRICT;
            }
        }
        throw new IllegalStateException("unexpected");
    }

    public static class ParseResult {
        public final Node ast;
        public final List<Comment> comments;

        public ParseResult(Node ast, List<Comment> comments) {
            this.ast = ast;
            this.comments = comments;
        }
    }

    private static class Es6ErrorReporter
    extends ErrorReporter {
        private com.google.javascript.rhino.head.ErrorReporter reporter;
        private boolean errorSeen = false;
        private boolean isIdeMode;
        private SourceFile source;

        Es6ErrorReporter(com.google.javascript.rhino.head.ErrorReporter reporter, SourceFile source, Config config) {
            this.reporter = reporter;
            this.isIdeMode = config.isIdeMode;
            this.source = source;
        }

        @Override
        protected void reportMessage(SourcePosition location, String kind, String format, Object ... arguments) {
            String message = SimpleFormat.format("%s", SimpleFormat.format(format, arguments));
            String sourceLine = this.source.getSnippet(location);
            switch (kind) {
                case "Error": {
                    if (!this.isIdeMode && this.errorSeen) break;
                    this.errorSeen = true;
                    this.reporter.error(message, location.source.name, location.line + 1, sourceLine, location.column);
                    break;
                }
                case "Warning": {
                    this.reporter.warning(message, location.source.name, location.line + 1, sourceLine, location.column);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected:" + kind);
                }
            }
        }

        @Override
        protected void reportMessage(SourcePosition location, String message) {
            throw new IllegalStateException("Not called directly");
        }
    }
}

