/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.SimpleRegion;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SourceFile
implements StaticSourceFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SOURCE_EXCERPT_REGION_LENGTH = 5;
    private final String fileName;
    private boolean isExternFile = false;
    private String originalPath = null;
    private int[] lineOffsets = null;
    private String code = null;

    public SourceFile(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("a source must have a name");
        }
        this.fileName = fileName;
    }

    @Override
    public int getLineOffset(int lineno) {
        this.findLineOffsets();
        if (lineno < 1 || lineno > this.lineOffsets.length) {
            throw new IllegalArgumentException("Expected line number between 1 and " + this.lineOffsets.length + "\nActual: " + lineno);
        }
        return this.lineOffsets[lineno - 1];
    }

    int getNumLines() {
        this.findLineOffsets();
        return this.lineOffsets.length;
    }

    private void findLineOffsets() {
        if (this.lineOffsets != null) {
            return;
        }
        try {
            String[] sourceLines = this.getCode().split("\n");
            this.lineOffsets = new int[sourceLines.length];
            for (int ii = 1; ii < sourceLines.length; ++ii) {
                this.lineOffsets[ii] = this.lineOffsets[ii - 1] + sourceLines[ii - 1].length() + 1;
            }
        }
        catch (IOException e) {
            this.lineOffsets = new int[1];
            this.lineOffsets[0] = 0;
        }
    }

    public String getCode() throws IOException {
        return this.code;
    }

    public Reader getCodeReader() throws IOException {
        return new StringReader(this.getCode());
    }

    @VisibleForTesting
    String getCodeNoCache() {
        return this.code;
    }

    private void setCode(String sourceCode) {
        this.code = sourceCode;
    }

    public String getOriginalPath() {
        return this.originalPath != null ? this.originalPath : this.fileName;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public void clearCachedSource() {
    }

    boolean hasSourceInMemory() {
        return this.code != null;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean isExtern() {
        return this.isExternFile;
    }

    void setIsExtern(boolean newVal) {
        this.isExternFile = newVal;
    }

    @Override
    public int getLineOfOffset(int offset) {
        this.findLineOffsets();
        int search = Arrays.binarySearch(this.lineOffsets, offset);
        if (search >= 0) {
            return search + 1;
        }
        int insertionPoint = -1 * (search + 1);
        return Math.min(insertionPoint - 1, this.lineOffsets.length - 1) + 1;
    }

    @Override
    public int getColumnOfOffset(int offset) {
        int line = this.getLineOfOffset(offset);
        return offset - this.lineOffsets[line - 1];
    }

    public String getLine(int lineNumber) {
        this.findLineOffsets();
        if (lineNumber > this.lineOffsets.length) {
            return null;
        }
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        int pos = this.lineOffsets[lineNumber - 1];
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        if (js.indexOf(10, pos) == -1) {
            if (pos >= js.length()) {
                return null;
            }
            return js.substring(pos, js.length());
        }
        return js.substring(pos, js.indexOf(10, pos));
    }

    public Region getRegion(int lineNumber) {
        int nextpos;
        String js = "";
        try {
            js = this.getCode();
        }
        catch (IOException e) {
            return null;
        }
        int pos = 0;
        int startLine = Math.max(1, lineNumber - 3 + 1);
        for (int n = 1; n < startLine && (nextpos = js.indexOf(10, pos)) != -1; ++n) {
            pos = nextpos + 1;
        }
        int end = pos;
        int endLine = startLine;
        int n = 0;
        while (n < 5 && (end = js.indexOf(10, end)) != -1) {
            ++end;
            ++n;
            ++endLine;
        }
        if (lineNumber >= endLine) {
            return null;
        }
        if (end == -1) {
            int last = js.length() - 1;
            if (js.charAt(last) == '\n') {
                return new SimpleRegion(startLine, endLine, js.substring(pos, last));
            }
            return new SimpleRegion(startLine, endLine, js.substring(pos));
        }
        return new SimpleRegion(startLine, endLine, js.substring(pos, end));
    }

    public String toString() {
        return this.fileName;
    }

    public static SourceFile fromFile(String fileName, Charset c) {
        return SourceFile.builder().withCharset(c).buildFromFile(fileName);
    }

    public static SourceFile fromFile(String fileName) {
        return SourceFile.builder().buildFromFile(fileName);
    }

    public static SourceFile fromFile(File file, Charset c) {
        return SourceFile.builder().withCharset(c).buildFromFile(file);
    }

    public static SourceFile fromFile(File file) {
        return SourceFile.builder().buildFromFile(file);
    }

    public static SourceFile fromCode(String fileName, String code) {
        return SourceFile.builder().buildFromCode(fileName, code);
    }

    public static SourceFile fromCode(String fileName, String originalPath, String code) {
        return SourceFile.builder().withOriginalPath(originalPath).buildFromCode(fileName, code);
    }

    public static SourceFile fromInputStream(String fileName, InputStream s) throws IOException {
        return SourceFile.builder().buildFromInputStream(fileName, s);
    }

    public static SourceFile fromInputStream(String fileName, String originalPath, InputStream s) throws IOException {
        return SourceFile.builder().withOriginalPath(originalPath).buildFromInputStream(fileName, s);
    }

    public static SourceFile fromReader(String fileName, Reader r) throws IOException {
        return SourceFile.builder().buildFromReader(fileName, r);
    }

    public static SourceFile fromGenerator(String fileName, Generator generator) {
        return SourceFile.builder().buildFromGenerator(fileName, generator);
    }

    public static Builder builder() {
        return new Builder();
    }

    static class OnDisk
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final File file;
        private String inputCharset = StandardCharsets.UTF_8.name();

        OnDisk(File file, String originalPath, Charset c) {
            super(file.getPath());
            this.file = file;
            super.setOriginalPath(originalPath);
            if (c != null) {
                this.setCharset(c);
            }
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = Files.toString((File)this.file, (Charset)this.getCharset());
                ((SourceFile)this).setCode(cachedCode);
            }
            return cachedCode;
        }

        @Override
        public Reader getCodeReader() throws IOException {
            if (this.hasSourceInMemory()) {
                return super.getCodeReader();
            }
            return new FileReader(this.file);
        }

        @Override
        public void clearCachedSource() {
            ((SourceFile)this).setCode(null);
        }

        public void setCharset(Charset c) {
            this.inputCharset = c.name();
        }

        public Charset getCharset() {
            return Charset.forName(this.inputCharset);
        }
    }

    static class Generated
    extends SourceFile {
        private static final long serialVersionUID = 1L;
        private final Generator generator;

        Generated(String fileName, String originalPath, Generator generator) {
            super(fileName);
            super.setOriginalPath(originalPath);
            this.generator = generator;
        }

        @Override
        public synchronized String getCode() throws IOException {
            String cachedCode = super.getCode();
            if (cachedCode == null) {
                cachedCode = this.generator.getCode();
                ((SourceFile)this).setCode(cachedCode);
            }
            return cachedCode;
        }

        @Override
        public void clearCachedSource() {
            ((SourceFile)this).setCode(null);
        }
    }

    static class Preloaded
    extends SourceFile {
        private static final long serialVersionUID = 1L;

        Preloaded(String fileName, String originalPath, String code) {
            super(fileName);
            super.setOriginalPath(originalPath);
            ((SourceFile)this).setCode(code);
        }
    }

    public static class Builder {
        private Charset charset = StandardCharsets.UTF_8;
        private String originalPath = null;

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withOriginalPath(String originalPath) {
            this.originalPath = originalPath;
            return this;
        }

        public SourceFile buildFromFile(String fileName) {
            return this.buildFromFile(new File(fileName));
        }

        public SourceFile buildFromFile(File file) {
            return new OnDisk(file, this.originalPath, this.charset);
        }

        public SourceFile buildFromCode(String fileName, String code) {
            return new Preloaded(fileName, this.originalPath, code);
        }

        public SourceFile buildFromInputStream(String fileName, InputStream s) throws IOException {
            return this.buildFromCode(fileName, CharStreams.toString((Readable)new InputStreamReader(s, this.charset)));
        }

        public SourceFile buildFromReader(String fileName, Reader r) throws IOException {
            return this.buildFromCode(fileName, CharStreams.toString((Readable)r));
        }

        public SourceFile buildFromGenerator(String fileName, Generator generator) {
            return new Generated(fileName, this.originalPath, generator);
        }
    }

    public static interface Generator {
        public String getCode();
    }
}

