/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.StatementFuzzer;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Arrays;
import java.util.Set;

class BlockFuzzer
extends AbstractFuzzer {
    BlockFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        return budget >= 1;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        int numStmts;
        if (budget < 1) {
            budget = 1;
        }
        if ((numStmts = this.generateLength(budget - 1)) == 0) {
            return new Node(125);
        }
        Object[] stmtFuzzers = new StatementFuzzer[numStmts];
        Arrays.fill(stmtFuzzers, new StatementFuzzer(this.context));
        Node[] statements = this.distribute(budget - 1, (AbstractFuzzer[])stmtFuzzers);
        return new Node(125, statements);
    }

    @Override
    protected String getConfigName() {
        return "block";
    }
}

