/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NaivePersistentMap<K, V>
extends PersistentMap<K, V> {
    private Map map;

    private NaivePersistentMap(Map<K, V> m) {
        this.map = m;
    }

    public static <K, V> PersistentMap<K, V> create() {
        return new NaivePersistentMap<K, V>(Maps.newHashMap());
    }

    @Override
    public PersistentMap<K, V> with(K key, V value) {
        HashMap newMap = Maps.newHashMap((Map)this);
        newMap.put(key, value);
        return new NaivePersistentMap<K, V>(newMap);
    }

    @Override
    public PersistentMap<K, V> without(K key) {
        HashMap newMap = Maps.newHashMap((Map)this);
        newMap.remove(key);
        return new NaivePersistentMap<K, V>(newMap);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

