/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.places.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PlaceName
implements ResourceName {
    private static final PathTemplate PLACE_ID = PathTemplate.createWithoutUrlEncoding((String)"places/{place_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String placeId;

    @Deprecated
    protected PlaceName() {
        this.placeId = null;
    }

    private PlaceName(Builder builder) {
        this.placeId = (String)Preconditions.checkNotNull((Object)builder.getPlaceId());
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PlaceName of(String placeId) {
        return PlaceName.newBuilder().setPlaceId(placeId).build();
    }

    public static String format(String placeId) {
        return PlaceName.newBuilder().setPlaceId(placeId).build().toString();
    }

    public static PlaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PLACE_ID.validatedMatch(formattedString, "PlaceName.parse: formattedString not in valid format");
        return PlaceName.of((String)matchMap.get("place_id"));
    }

    public static List<PlaceName> parseList(List<String> formattedStrings) {
        ArrayList<PlaceName> list = new ArrayList<PlaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PlaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PlaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PlaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PLACE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PlaceName placeName = this;
            synchronized (placeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.placeId != null) {
                        fieldMapBuilder.put((Object)"place_id", (Object)this.placeId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PLACE_ID.instantiate(new String[]{"place_id", this.placeId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            PlaceName that = (PlaceName)o;
            return Objects.equals(this.placeId, that.placeId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.placeId);
    }

    public static class Builder {
        private String placeId;

        protected Builder() {
        }

        public String getPlaceId() {
            return this.placeId;
        }

        public Builder setPlaceId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        private Builder(PlaceName placeName) {
            this.placeId = placeName.placeId;
        }

        public PlaceName build() {
            return new PlaceName(this);
        }
    }
}

