/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubjectFactory;
import com.google.testing.compile.JavaFileObjectSubject;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public final class CompilationSubject
extends Subject<CompilationSubject, Compilation> {
    private static final SubjectFactory<CompilationSubject, Compilation> FACTORY = new CompilationSubjectFactory();

    public static SubjectFactory<CompilationSubject, Compilation> compilations() {
        return FACTORY;
    }

    public static CompilationSubject assertThat(Compilation actual) {
        return (CompilationSubject)Truth.assertAbout(CompilationSubject.compilations()).that((Object)actual);
    }

    CompilationSubject(FailureStrategy failureStrategy, Compilation actual) {
        super(failureStrategy, (Object)actual);
    }

    public void succeeded() {
        if (((Compilation)this.actual()).status().equals((Object)Compilation.Status.FAILURE)) {
            this.failureStrategy.fail(((Compilation)this.actual()).describeErrors() + ((Compilation)this.actual()).describeGeneratedSourceFiles());
        }
    }

    public void succeededWithoutWarnings() {
        this.succeeded();
        this.hadWarningCount(0);
    }

    public void failed() {
        if (((Compilation)this.actual()).status().equals((Object)Compilation.Status.SUCCESS)) {
            this.failureStrategy.fail("Compilation was expected to fail, but contained no errors.\n\n" + ((Compilation)this.actual()).describeGeneratedSourceFiles());
        }
    }

    public void hadErrorCount(int expectedCount) {
        this.checkDiagnosticCount(expectedCount, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadErrorContaining(String expectedSubstring) {
        return this.hadDiagnosticContaining(expectedSubstring, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadErrorContainingMatch(String expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadErrorContainingMatch(Pattern expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.ERROR, new Diagnostic.Kind[0]);
    }

    public void hadWarningCount(int expectedCount) {
        this.checkDiagnosticCount(expectedCount, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadWarningContaining(String expectedSubstring) {
        return this.hadDiagnosticContaining(expectedSubstring, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadWarningContainingMatch(String expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadWarningContainingMatch(Pattern expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.WARNING, Diagnostic.Kind.MANDATORY_WARNING);
    }

    public void hadNoteCount(int expectedCount) {
        this.checkDiagnosticCount(expectedCount, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadNoteContaining(String expectedSubstring) {
        return this.hadDiagnosticContaining(expectedSubstring, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadNoteContainingMatch(String expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    @CanIgnoreReturnValue
    public DiagnosticInFile hadNoteContainingMatch(Pattern expectedPattern) {
        return this.hadDiagnosticContainingMatch(expectedPattern, Diagnostic.Kind.NOTE, new Diagnostic.Kind[0]);
    }

    private void checkDiagnosticCount(int expectedCount, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics = ((Compilation)this.actual()).diagnosticsOfKind(kind, more);
        int actualCount = Iterables.size(diagnostics);
        if (actualCount != expectedCount) {
            this.failureStrategy.fail(CompilationSubject.messageListing(diagnostics, "Expected %d %s, but found the following %d %s:", new Object[]{expectedCount, CompilationSubject.kindToString(kind, true), actualCount, CompilationSubject.kindToString(kind, true)}));
        }
    }

    private static String messageListing(Iterable<? extends Diagnostic<?>> diagnostics, String headingFormat, Object ... formatArgs) {
        StringBuilder listing = new StringBuilder(String.format(headingFormat, formatArgs)).append('\n');
        for (Diagnostic<?> diagnostic : diagnostics) {
            listing.append(diagnostic.getMessage(null)).append('\n');
        }
        return listing.toString();
    }

    private static String kindToString(Diagnostic.Kind kind, boolean expectingSpecificCount) {
        switch (kind) {
            case ERROR: {
                return expectingSpecificCount ? "errors" : "an error";
            }
            case MANDATORY_WARNING: 
            case WARNING: {
                return expectingSpecificCount ? "warnings" : "a warning";
            }
            case NOTE: {
                return expectingSpecificCount ? "notes" : "a note";
            }
            case OTHER: {
                return expectingSpecificCount ? "diagnostic messages" : "a diagnostic message";
            }
        }
        throw new AssertionError((Object)kind);
    }

    private DiagnosticInFile hadDiagnosticContaining(String expectedSubstring, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        return this.hadDiagnosticContainingMatch(String.format("containing \"%s\"", expectedSubstring), Pattern.compile(Pattern.quote(expectedSubstring)), kind, more);
    }

    private DiagnosticInFile hadDiagnosticContainingMatch(String expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        return this.hadDiagnosticContainingMatch(Pattern.compile(expectedPattern), kind, more);
    }

    private DiagnosticInFile hadDiagnosticContainingMatch(Pattern expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        return this.hadDiagnosticContainingMatch(String.format("containing match for /%s/", expectedPattern), expectedPattern, kind, more);
    }

    private DiagnosticInFile hadDiagnosticContainingMatch(String verb, Pattern expectedPattern, Diagnostic.Kind kind, Diagnostic.Kind ... more) {
        ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsOfKind = ((Compilation)this.actual()).diagnosticsOfKind(kind, more);
        ImmutableList diagnosticsWithMessage = diagnosticsOfKind.stream().filter(diagnostic -> expectedPattern.matcher(diagnostic.getMessage(null)).find()).collect(CompilationSubject.toImmutableList());
        if (diagnosticsWithMessage.isEmpty()) {
            this.failureStrategy.fail(CompilationSubject.messageListing(diagnosticsOfKind, "Expected %s %s, but only found:", new Object[]{CompilationSubject.kindToString(kind, false), verb}));
        }
        return new DiagnosticInFile(kind, (Iterable)diagnosticsWithMessage);
    }

    @CanIgnoreReturnValue
    public JavaFileObjectSubject generatedFile(JavaFileManager.Location location, String packageName, String fileName) {
        return this.checkGeneratedFile(((Compilation)this.actual()).generatedFile(location, packageName, fileName), location, "named \"%s\" in %s", fileName, packageName.isEmpty() ? "the default package" : String.format("package \"%s\"", packageName));
    }

    @CanIgnoreReturnValue
    public JavaFileObjectSubject generatedFile(JavaFileManager.Location location, String path) {
        return this.checkGeneratedFile(((Compilation)this.actual()).generatedFile(location, path), location, path, new Object[0]);
    }

    @CanIgnoreReturnValue
    public JavaFileObjectSubject generatedSourceFile(String qualifiedName) {
        return this.generatedFile(StandardLocation.SOURCE_OUTPUT, qualifiedName.replaceAll("\\.", "/") + ".java");
    }

    private JavaFileObjectSubject checkGeneratedFile(Optional<JavaFileObject> generatedFile, JavaFileManager.Location location, String format, Object ... args) {
        if (!generatedFile.isPresent()) {
            StringBuilder builder = new StringBuilder("generated the file ");
            builder.append(args.length == 0 ? format : String.format(format, args));
            builder.append("; it generated:\n");
            for (JavaFileObject generated : ((Compilation)this.actual()).generatedFiles()) {
                if (!generated.toUri().getPath().contains(location.getName())) continue;
                builder.append("  ").append(generated.toUri().getPath()).append('\n');
            }
            this.fail(builder.toString());
        }
        return (JavaFileObjectSubject)this.check().about(JavaFileObjectSubject.javaFileObjects()).that((Object)generatedFile.get());
    }

    private static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    public final class DiagnosticAtColumn
    extends DiagnosticsAssertions {
        private final Diagnostic.Kind kind;
        private final JavaFileObject file;
        private final long line;

        private DiagnosticAtColumn(Diagnostic.Kind kind, JavaFileObject file, long line, ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics) {
            super((Iterable<Diagnostic<? extends JavaFileObject>>)diagnostics);
            this.kind = kind;
            this.file = file;
            this.line = line;
        }

        public void atColumn(long expectedColumn) {
            if (this.diagnosticsMatching(diagnostic -> diagnostic.getColumnNumber() == expectedColumn).isEmpty()) {
                CompilationSubject.this.failureStrategy.fail(String.format("Expected %s at %d:%d of %s, but only found them at column(s) %s", CompilationSubject.kindToString(this.kind, false), this.line, expectedColumn, this.file.getName(), this.columnsWithDiagnostics()));
            }
        }

        private ImmutableSet<String> columnsWithDiagnostics() {
            return this.mapDiagnostics(diagnostic -> diagnostic.getColumnNumber() == -1L ? "(no associated position)" : Long.toString(diagnostic.getColumnNumber()));
        }
    }

    public final class DiagnosticOnLine
    extends DiagnosticsAssertions {
        private final Diagnostic.Kind kind;
        private final JavaFileObject file;

        private DiagnosticOnLine(Diagnostic.Kind kind, JavaFileObject file, ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics) {
            super((Iterable<Diagnostic<? extends JavaFileObject>>)diagnostics);
            this.kind = kind;
            this.file = file;
        }

        @CanIgnoreReturnValue
        public DiagnosticAtColumn onLine(long expectedLine) {
            ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsOnLine = this.diagnosticsMatching(diagnostic -> diagnostic.getLineNumber() == expectedLine);
            if (diagnosticsOnLine.isEmpty()) {
                CompilationSubject.this.failureStrategy.fail(String.format("Expected %s on line %d of %s, but only found them on line(s) %s", CompilationSubject.kindToString(this.kind, false), expectedLine, this.file.getName(), this.linesWithDiagnostics()));
            }
            return new DiagnosticAtColumn(this.kind, this.file, expectedLine, diagnosticsOnLine);
        }

        private ImmutableSet<String> linesWithDiagnostics() {
            return this.mapDiagnostics(diagnostic -> diagnostic.getLineNumber() == -1L ? "(no associated position)" : Long.toString(diagnostic.getLineNumber()));
        }
    }

    public final class DiagnosticInFile
    extends DiagnosticsAssertions {
        private final Diagnostic.Kind kind;

        private DiagnosticInFile(Diagnostic.Kind kind, Iterable<Diagnostic<? extends JavaFileObject>> diagnosticsWithMessage) {
            super(diagnosticsWithMessage);
            this.kind = kind;
        }

        @CanIgnoreReturnValue
        public DiagnosticOnLine inFile(JavaFileObject expectedFile) {
            ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsInFile = this.diagnosticsInFile(expectedFile);
            if (diagnosticsInFile.isEmpty()) {
                CompilationSubject.this.failureStrategy.fail(String.format("Expected %s in %s, but only found them in %s", CompilationSubject.kindToString(this.kind, false), expectedFile.getName(), this.sourceFilesWithDiagnostics()));
            }
            return new DiagnosticOnLine(this.kind, expectedFile, diagnosticsInFile);
        }

        private ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsInFile(JavaFileObject expectedFile) {
            String expectedFilePath = expectedFile.toUri().getPath();
            return this.diagnosticsMatching(diagnostic -> {
                JavaFileObject source = (JavaFileObject)diagnostic.getSource();
                return source != null && source.toUri().getPath().equals(expectedFilePath);
            });
        }

        private ImmutableSet<String> sourceFilesWithDiagnostics() {
            return this.mapDiagnostics(diagnostic -> diagnostic.getSource() == null ? "(no associated file)" : ((JavaFileObject)diagnostic.getSource()).getName());
        }
    }

    private static class DiagnosticsAssertions {
        private final ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics;

        DiagnosticsAssertions(Iterable<Diagnostic<? extends JavaFileObject>> diagnostics) {
            this.diagnostics = ImmutableList.copyOf(diagnostics);
        }

        ImmutableList<Diagnostic<? extends JavaFileObject>> diagnosticsMatching(Predicate<? super Diagnostic<? extends JavaFileObject>> predicate) {
            return (ImmutableList)this.diagnostics.stream().filter(predicate).collect(CompilationSubject.toImmutableList());
        }

        ImmutableSet<String> mapDiagnostics(Function<? super Diagnostic<? extends JavaFileObject>, ? extends String> mapper) {
            return this.diagnostics.stream().map(mapper).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf));
        }
    }
}

