/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Functions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.testing.compile.AutoValue_Compiler;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationFailureException;
import com.google.testing.compile.InMemoryJavaFileManager;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public abstract class Compiler {
    public static Compiler javac() {
        return Compiler.compiler(ToolProvider.getSystemJavaCompiler());
    }

    public static Compiler compiler(JavaCompiler javaCompiler) {
        return new AutoValue_Compiler(javaCompiler, (ImmutableList<Processor>)ImmutableList.of(), (ImmutableList<String>)ImmutableList.of());
    }

    abstract JavaCompiler javaCompiler();

    public abstract ImmutableList<Processor> processors();

    public abstract ImmutableList<String> options();

    public final Compiler withProcessors(Processor ... processors) {
        return this.withProcessors((Iterable<? extends Processor>)ImmutableList.copyOf((Object[])processors));
    }

    public final Compiler withProcessors(Iterable<? extends Processor> processors) {
        return this.copy((ImmutableList<Processor>)ImmutableList.copyOf(processors), this.options());
    }

    public final Compiler withOptions(Object ... options) {
        return this.withOptions((Iterable<?>)ImmutableList.copyOf((Object[])options));
    }

    public final Compiler withOptions(Iterable<?> options) {
        return this.copy(this.processors(), (ImmutableList<String>)FluentIterable.from(options).transform(Functions.toStringFunction()).toList());
    }

    public final Compilation compile(JavaFileObject ... files) {
        return this.compile((Iterable<? extends JavaFileObject>)ImmutableList.copyOf((Object[])files));
    }

    public final Compilation compile(Iterable<? extends JavaFileObject> files) {
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        InMemoryJavaFileManager fileManager = new InMemoryJavaFileManager(this.javaCompiler().getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8));
        JavaCompiler.CompilationTask task = this.javaCompiler().getTask(null, fileManager, diagnosticCollector, (Iterable<String>)this.options(), (Iterable<String>)ImmutableSet.of(), files);
        task.setProcessors((Iterable<? extends Processor>)this.processors());
        boolean succeeded = task.call();
        Compilation compilation = new Compilation(this, files, succeeded, (Iterable<Diagnostic<? extends JavaFileObject>>)diagnosticCollector.getDiagnostics(), (Iterable<JavaFileObject>)fileManager.getOutputFiles());
        if (compilation.status().equals((Object)Compilation.Status.FAILURE) && compilation.errors().isEmpty()) {
            throw new CompilationFailureException(compilation);
        }
        return compilation;
    }

    private Compiler copy(ImmutableList<Processor> processors, ImmutableList<String> options) {
        return new AutoValue_Compiler(this.javaCompiler(), processors, options);
    }
}

