/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.testing.compile.JavaFileObjectSubjectFactory;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.Parser;
import com.google.testing.compile.TreeContext;
import com.google.testing.compile.TreeDiffer;
import com.google.testing.compile.TreeDifference;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.tools.JavaFileObject;

public final class JavaFileObjectSubject
extends Subject<JavaFileObjectSubject, JavaFileObject> {
    private static final Subject.Factory<JavaFileObjectSubject, JavaFileObject> FACTORY = new JavaFileObjectSubjectFactory();

    public static Subject.Factory<JavaFileObjectSubject, JavaFileObject> javaFileObjects() {
        return FACTORY;
    }

    public static JavaFileObjectSubject assertThat(JavaFileObject actual) {
        return (JavaFileObjectSubject)Truth.assertAbout(FACTORY).that((Object)actual);
    }

    JavaFileObjectSubject(FailureMetadata failureMetadata, JavaFileObject actual) {
        super(failureMetadata, (Object)actual);
    }

    protected String actualCustomStringRepresentation() {
        return ((JavaFileObject)this.actual()).toUri().getPath();
    }

    public void isEqualTo(@Nullable Object other) {
        if (!(other instanceof JavaFileObject)) {
            super.isEqualTo(other);
        }
        JavaFileObject otherFile = (JavaFileObject)other;
        try {
            if (!JavaFileObjects.asByteSource((JavaFileObject)this.actual()).contentEquals(JavaFileObjects.asByteSource(otherFile))) {
                this.failWithActual("expected to be equal to", other);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void hasContents(ByteSource expected) {
        try {
            if (!JavaFileObjects.asByteSource((JavaFileObject)this.actual()).contentEquals(expected)) {
                this.failWithActual("expected to have contents", expected);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StringSubject contentsAsString(Charset charset) {
        try {
            return (StringSubject)this.check().that(JavaFileObjects.asByteSource((JavaFileObject)this.actual()).asCharSource(charset).read()).named("the contents of " + this.actualAsString(), new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public StringSubject contentsAsUtf8String() {
        return this.contentsAsString(StandardCharsets.UTF_8);
    }

    public void hasSourceEquivalentTo(JavaFileObject expectedSource) {
        this.performTreeDifference(expectedSource, "is equivalent to", "Expected Source", (expectedResult, actualResult) -> TreeDiffer.diffCompilationUnits((CompilationUnitTree)Iterables.getOnlyElement(expectedResult.compilationUnits()), (CompilationUnitTree)Iterables.getOnlyElement(actualResult.compilationUnits())));
    }

    public void containsElementsIn(JavaFileObject expectedPattern) {
        this.performTreeDifference(expectedPattern, "contains elements in", "Expected Pattern", (expectedResult, actualResult) -> TreeDiffer.matchCompilationUnits((CompilationUnitTree)Iterables.getOnlyElement(expectedResult.compilationUnits()), actualResult.trees(), (CompilationUnitTree)Iterables.getOnlyElement(actualResult.compilationUnits()), expectedResult.trees()));
    }

    private void performTreeDifference(JavaFileObject expected, String failureVerb, String expectedTitle, BiFunction<Parser.ParseResult, Parser.ParseResult, TreeDifference> differencingFunction) {
        Parser.ParseResult actualResult = Parser.parse((Iterable<? extends JavaFileObject>)ImmutableList.of((Object)this.actual()));
        CompilationUnitTree actualTree = (CompilationUnitTree)Iterables.getOnlyElement(actualResult.compilationUnits());
        Parser.ParseResult expectedResult = Parser.parse((Iterable<? extends JavaFileObject>)ImmutableList.of((Object)expected));
        CompilationUnitTree expectedTree = (CompilationUnitTree)Iterables.getOnlyElement(expectedResult.compilationUnits());
        TreeDifference treeDifference = differencingFunction.apply(expectedResult, actualResult);
        if (!treeDifference.isEmpty()) {
            String diffReport = treeDifference.getDiffReport(new TreeContext(expectedTree, expectedResult.trees()), new TreeContext(actualTree, actualResult.trees()));
            try {
                this.fail(Joiner.on((char)'\n').join((Object)String.format("%s <%s>.", failureVerb, expected.toUri().getPath()), (Object)"", new Object[]{"Diffs:", "======", "", diffReport, "", expectedTitle + ":", "================", "", expected.getCharContent(false), "", "Actual Source:", "==============", "", ((JavaFileObject)this.actual()).getCharContent(false)}));
            }
            catch (IOException e) {
                throw new IllegalStateException("Couldn't read from JavaFileObject when it was already in memory.", e);
            }
        }
    }
}

