/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.Iterator;
import javax.annotation.Nullable;

final class EqualityScanner
extends SimpleTreeVisitor<Boolean, Tree> {
    EqualityScanner() {
    }

    private <T extends Tree> Optional<T> checkTypeAndCast(T reference, Tree tree) {
        Tree.Kind treeKind;
        Tree.Kind referenceKind = ((Tree)Preconditions.checkNotNull(reference)).getKind();
        if (referenceKind == (treeKind = ((Tree)Preconditions.checkNotNull((Object)tree)).getKind())) {
            Tree treeAsReferenceType = tree;
            return Optional.of((Object)treeAsReferenceType);
        }
        return Optional.absent();
    }

    private boolean scan(@Nullable Tree reference, @Nullable Tree tree) {
        return reference == null ? tree == null : reference.accept(this, tree);
    }

    private boolean parallelScan(Iterable<? extends Tree> reference, Iterable<? extends Tree> trees) {
        if (reference == null && trees == null) {
            return true;
        }
        if (reference != null && trees != null) {
            Iterator<? extends Tree> referenceIterator = reference.iterator();
            Iterator<? extends Tree> treesIterator = trees.iterator();
            while (referenceIterator.hasNext() && treesIterator.hasNext()) {
                if (referenceIterator.next().accept(this, treesIterator.next()).booleanValue()) continue;
                return false;
            }
            return referenceIterator.hasNext() == treesIterator.hasNext();
        }
        return false;
    }

    @Override
    public Boolean visitAnnotation(AnnotationTree reference, Tree tree) {
        Optional<AnnotationTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getAnnotationType(), ((AnnotationTree)other.get()).getAnnotationType()) && this.parallelScan(reference.getArguments(), ((AnnotationTree)other.get()).getArguments());
    }

    @Override
    public Boolean visitMethodInvocation(MethodInvocationTree reference, Tree tree) {
        Optional<MethodInvocationTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.parallelScan(reference.getTypeArguments(), ((MethodInvocationTree)other.get()).getTypeArguments()) && this.scan(reference.getMethodSelect(), ((MethodInvocationTree)other.get()).getMethodSelect()) && this.parallelScan(reference.getArguments(), ((MethodInvocationTree)other.get()).getArguments());
    }

    @Override
    public Boolean visitAssert(AssertTree reference, Tree tree) {
        Optional<AssertTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getCondition(), ((AssertTree)other.get()).getCondition()) && this.scan(reference.getDetail(), ((AssertTree)other.get()).getDetail());
    }

    @Override
    public Boolean visitAssignment(AssignmentTree reference, Tree tree) {
        Optional<AssignmentTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getVariable(), ((AssignmentTree)other.get()).getVariable()) && this.scan(reference.getExpression(), ((AssignmentTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitCompoundAssignment(CompoundAssignmentTree reference, Tree tree) {
        Optional<CompoundAssignmentTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getVariable(), ((CompoundAssignmentTree)other.get()).getVariable()) && this.scan(reference.getExpression(), ((CompoundAssignmentTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitBinary(BinaryTree reference, Tree tree) {
        Optional<BinaryTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getLeftOperand(), ((BinaryTree)other.get()).getLeftOperand()) && this.scan(reference.getRightOperand(), ((BinaryTree)other.get()).getRightOperand());
    }

    @Override
    public Boolean visitBlock(BlockTree reference, Tree tree) {
        Optional<BlockTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.isStatic() == ((BlockTree)other.get()).isStatic() && this.parallelScan(reference.getStatements(), ((BlockTree)other.get()).getStatements());
    }

    @Override
    public Boolean visitBreak(BreakTree reference, Tree tree) {
        Optional<BreakTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.getLabel().contentEquals(((BreakTree)other.get()).getLabel());
    }

    @Override
    public Boolean visitCase(CaseTree reference, Tree tree) {
        Optional<CaseTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((CaseTree)other.get()).getExpression()) && this.parallelScan(reference.getStatements(), ((CaseTree)other.get()).getStatements());
    }

    @Override
    public Boolean visitCatch(CatchTree reference, Tree tree) {
        Optional<CatchTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getParameter(), ((CatchTree)other.get()).getParameter()) && this.scan(reference.getBlock(), ((CatchTree)other.get()).getBlock());
    }

    @Override
    public Boolean visitClass(ClassTree reference, Tree tree) {
        Optional<ClassTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getModifiers(), ((ClassTree)other.get()).getModifiers()) && reference.getSimpleName().contentEquals(((ClassTree)other.get()).getSimpleName()) && this.parallelScan(reference.getTypeParameters(), ((ClassTree)other.get()).getTypeParameters()) && this.scan(reference.getExtendsClause(), ((ClassTree)other.get()).getExtendsClause()) && this.parallelScan(reference.getImplementsClause(), ((ClassTree)other.get()).getImplementsClause()) && this.parallelScan(reference.getMembers(), ((ClassTree)other.get()).getMembers());
    }

    @Override
    public Boolean visitConditionalExpression(ConditionalExpressionTree reference, Tree tree) {
        Optional<ConditionalExpressionTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getCondition(), ((ConditionalExpressionTree)other.get()).getCondition()) && this.scan(reference.getTrueExpression(), ((ConditionalExpressionTree)other.get()).getTrueExpression()) && this.scan(reference.getFalseExpression(), ((ConditionalExpressionTree)other.get()).getFalseExpression());
    }

    @Override
    public Boolean visitContinue(ContinueTree reference, Tree tree) {
        Optional<ContinueTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.getLabel().contentEquals(((ContinueTree)other.get()).getLabel());
    }

    @Override
    public Boolean visitDoWhileLoop(DoWhileLoopTree reference, Tree tree) {
        Optional<DoWhileLoopTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getCondition(), ((DoWhileLoopTree)other.get()).getCondition()) && this.scan(reference.getStatement(), ((DoWhileLoopTree)other.get()).getStatement());
    }

    @Override
    public Boolean visitErroneous(ErroneousTree reference, Tree tree) {
        Optional<ErroneousTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.parallelScan(reference.getErrorTrees(), ((ErroneousTree)other.get()).getErrorTrees());
    }

    @Override
    public Boolean visitExpressionStatement(ExpressionStatementTree reference, Tree tree) {
        Optional<ExpressionStatementTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((ExpressionStatementTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitEnhancedForLoop(EnhancedForLoopTree reference, Tree tree) {
        Optional<EnhancedForLoopTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getVariable(), ((EnhancedForLoopTree)other.get()).getVariable()) && this.scan(reference.getExpression(), ((EnhancedForLoopTree)other.get()).getExpression()) && this.scan(reference.getStatement(), ((EnhancedForLoopTree)other.get()).getStatement());
    }

    @Override
    public Boolean visitForLoop(ForLoopTree reference, Tree tree) {
        Optional<ForLoopTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.parallelScan(reference.getInitializer(), ((ForLoopTree)other.get()).getInitializer()) && this.scan(reference.getCondition(), ((ForLoopTree)other.get()).getCondition()) && this.parallelScan(reference.getUpdate(), ((ForLoopTree)other.get()).getUpdate()) && this.scan(reference.getStatement(), ((ForLoopTree)other.get()).getStatement());
    }

    @Override
    public Boolean visitIdentifier(IdentifierTree reference, Tree tree) {
        Optional<IdentifierTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.getName().contentEquals(((IdentifierTree)other.get()).getName());
    }

    @Override
    public Boolean visitIf(IfTree reference, Tree tree) {
        Optional<IfTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getCondition(), ((IfTree)other.get()).getCondition()) && this.scan(reference.getThenStatement(), ((IfTree)other.get()).getThenStatement()) && this.scan(reference.getElseStatement(), ((IfTree)other.get()).getElseStatement());
    }

    @Override
    public Boolean visitImport(ImportTree reference, Tree tree) {
        Optional<ImportTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.isStatic() == ((ImportTree)other.get()).isStatic() && this.scan(reference.getQualifiedIdentifier(), ((ImportTree)other.get()).getQualifiedIdentifier());
    }

    @Override
    public Boolean visitArrayAccess(ArrayAccessTree reference, Tree tree) {
        Optional<ArrayAccessTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((ArrayAccessTree)other.get()).getExpression()) && this.scan(reference.getIndex(), ((ArrayAccessTree)other.get()).getIndex());
    }

    @Override
    public Boolean visitLabeledStatement(LabeledStatementTree reference, Tree tree) {
        Optional<LabeledStatementTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.getLabel().contentEquals(((LabeledStatementTree)other.get()).getLabel()) && this.scan(reference.getStatement(), ((LabeledStatementTree)other.get()).getStatement());
    }

    @Override
    public Boolean visitLiteral(LiteralTree reference, Tree tree) {
        Optional<LiteralTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && Objects.equal((Object)reference.getValue(), (Object)((LiteralTree)other.get()).getValue());
    }

    @Override
    public Boolean visitMethod(MethodTree reference, Tree tree) {
        Optional<MethodTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getModifiers(), ((MethodTree)other.get()).getModifiers()) && reference.getName().contentEquals(((MethodTree)other.get()).getName()) && this.scan(reference.getReturnType(), ((MethodTree)other.get()).getReturnType()) && this.parallelScan(reference.getTypeParameters(), ((MethodTree)other.get()).getTypeParameters()) && this.parallelScan(reference.getParameters(), ((MethodTree)other.get()).getParameters()) && this.parallelScan(reference.getThrows(), ((MethodTree)other.get()).getThrows()) && this.scan(reference.getBody(), ((MethodTree)other.get()).getBody()) && this.scan(reference.getDefaultValue(), ((MethodTree)other.get()).getDefaultValue());
    }

    @Override
    public Boolean visitModifiers(ModifiersTree reference, Tree tree) {
        Optional<ModifiersTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && ((Object)reference.getFlags()).equals(((ModifiersTree)other.get()).getFlags()) && this.parallelScan(reference.getAnnotations(), ((ModifiersTree)other.get()).getAnnotations());
    }

    @Override
    public Boolean visitNewArray(NewArrayTree reference, Tree tree) {
        Optional<NewArrayTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getType(), ((NewArrayTree)other.get()).getType()) && this.parallelScan(reference.getDimensions(), ((NewArrayTree)other.get()).getDimensions()) && this.parallelScan(reference.getInitializers(), ((NewArrayTree)other.get()).getInitializers());
    }

    @Override
    public Boolean visitNewClass(NewClassTree reference, Tree tree) {
        Optional<NewClassTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getEnclosingExpression(), ((NewClassTree)other.get()).getEnclosingExpression()) && this.parallelScan(reference.getTypeArguments(), ((NewClassTree)other.get()).getTypeArguments()) && this.scan(reference.getIdentifier(), ((NewClassTree)other.get()).getIdentifier()) && this.parallelScan(reference.getArguments(), ((NewClassTree)other.get()).getArguments()) && this.scan(reference.getClassBody(), ((NewClassTree)other.get()).getClassBody());
    }

    @Override
    public Boolean visitParenthesized(ParenthesizedTree reference, Tree tree) {
        Optional<ParenthesizedTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((ParenthesizedTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitReturn(ReturnTree reference, Tree tree) {
        Optional<ReturnTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((ReturnTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitMemberSelect(MemberSelectTree reference, Tree tree) {
        Optional<MemberSelectTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((MemberSelectTree)other.get()).getExpression()) && reference.getIdentifier().contentEquals(((MemberSelectTree)other.get()).getIdentifier());
    }

    @Override
    public Boolean visitEmptyStatement(EmptyStatementTree reference, Tree tree) {
        return this.checkTypeAndCast(reference, tree).isPresent();
    }

    @Override
    public Boolean visitSwitch(SwitchTree reference, Tree tree) {
        Optional<SwitchTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((SwitchTree)other.get()).getExpression()) && this.parallelScan(reference.getCases(), ((SwitchTree)other.get()).getCases());
    }

    @Override
    public Boolean visitSynchronized(SynchronizedTree reference, Tree tree) {
        Optional<SynchronizedTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((SynchronizedTree)other.get()).getExpression()) && this.scan(reference.getBlock(), ((SynchronizedTree)other.get()).getBlock());
    }

    @Override
    public Boolean visitThrow(ThrowTree reference, Tree tree) {
        Optional<ThrowTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((ThrowTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitCompilationUnit(CompilationUnitTree reference, Tree tree) {
        Optional<CompilationUnitTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.parallelScan(reference.getPackageAnnotations(), ((CompilationUnitTree)other.get()).getPackageAnnotations()) && this.scan(reference.getPackageName(), ((CompilationUnitTree)other.get()).getPackageName()) && this.parallelScan(reference.getImports(), ((CompilationUnitTree)other.get()).getImports()) && this.parallelScan(reference.getTypeDecls(), ((CompilationUnitTree)other.get()).getTypeDecls());
    }

    @Override
    public Boolean visitTry(TryTree reference, Tree tree) {
        Optional<TryTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getBlock(), ((TryTree)other.get()).getBlock()) && this.parallelScan(reference.getCatches(), ((TryTree)other.get()).getCatches()) && this.scan(reference.getFinallyBlock(), ((TryTree)other.get()).getFinallyBlock());
    }

    @Override
    public Boolean visitParameterizedType(ParameterizedTypeTree reference, Tree tree) {
        Optional<ParameterizedTypeTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getType(), ((ParameterizedTypeTree)other.get()).getType()) && this.parallelScan(reference.getTypeArguments(), ((ParameterizedTypeTree)other.get()).getTypeArguments());
    }

    @Override
    public Boolean visitArrayType(ArrayTypeTree reference, Tree tree) {
        Optional<ArrayTypeTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getType(), ((ArrayTypeTree)other.get()).getType());
    }

    @Override
    public Boolean visitTypeCast(TypeCastTree reference, Tree tree) {
        Optional<TypeCastTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getType(), ((TypeCastTree)other.get()).getType()) && this.scan(reference.getExpression(), ((TypeCastTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitPrimitiveType(PrimitiveTypeTree reference, Tree tree) {
        Optional<PrimitiveTypeTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.getPrimitiveTypeKind() == ((PrimitiveTypeTree)other.get()).getPrimitiveTypeKind();
    }

    @Override
    public Boolean visitTypeParameter(TypeParameterTree reference, Tree tree) {
        Optional<TypeParameterTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && reference.getName().contentEquals(((TypeParameterTree)other.get()).getName()) && this.parallelScan(reference.getBounds(), ((TypeParameterTree)other.get()).getBounds());
    }

    @Override
    public Boolean visitInstanceOf(InstanceOfTree reference, Tree tree) {
        Optional<InstanceOfTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((InstanceOfTree)other.get()).getExpression()) && this.scan(reference.getType(), ((InstanceOfTree)other.get()).getType());
    }

    @Override
    public Boolean visitUnary(UnaryTree reference, Tree tree) {
        Optional<UnaryTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getExpression(), ((UnaryTree)other.get()).getExpression());
    }

    @Override
    public Boolean visitVariable(VariableTree reference, Tree tree) {
        Optional<VariableTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getModifiers(), ((VariableTree)other.get()).getModifiers()) && reference.getName().contentEquals(((VariableTree)other.get()).getName()) && this.scan(reference.getType(), ((VariableTree)other.get()).getType()) && this.scan(reference.getInitializer(), ((VariableTree)other.get()).getInitializer());
    }

    @Override
    public Boolean visitWhileLoop(WhileLoopTree reference, Tree tree) {
        Optional<WhileLoopTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getCondition(), ((WhileLoopTree)other.get()).getCondition()) && this.scan(reference.getStatement(), ((WhileLoopTree)other.get()).getStatement());
    }

    @Override
    public Boolean visitWildcard(WildcardTree reference, Tree tree) {
        Optional<WildcardTree> other = this.checkTypeAndCast(reference, tree);
        return other.isPresent() && this.scan(reference.getBound(), ((WildcardTree)other.get()).getBound());
    }

    @Override
    public Boolean visitOther(Tree reference, Tree tree) {
        throw new UnsupportedOperationException("cannot compare unknown trees");
    }
}

