/*
 * Decompiled with CFR 0.152.
 */
package com.google.testing.compile;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.EqualityScanner;
import com.google.testing.compile.ProcessedCompileTesterFactory;
import com.sun.source.tree.CompilationUnitTree;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import org.truth0.FailureStrategy;
import org.truth0.subjects.Subject;

public final class JavaSourcesSubject
extends Subject<JavaSourcesSubject, Iterable<? extends JavaFileObject>>
implements CompileTester,
ProcessedCompileTesterFactory {
    JavaSourcesSubject(FailureStrategy failureStrategy, Iterable<? extends JavaFileObject> subject) {
        super(failureStrategy, subject);
    }

    @Override
    public CompileTester processedWith(Processor first, Processor ... rest) {
        return this.processedWith(Lists.asList((Object)first, (Object[])rest));
    }

    @Override
    public CompileTester processedWith(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    @Override
    public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
        return new CompilationClause().compilesWithoutError();
    }

    @Override
    public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
        return new CompilationClause().failsToCompile();
    }

    private CompilationClause newCompilationClause(Iterable<? extends Processor> processors) {
        return new CompilationClause(processors);
    }

    public static final class SingleSourceAdapter
    extends Subject<SingleSourceAdapter, JavaFileObject>
    implements CompileTester,
    ProcessedCompileTesterFactory {
        private final JavaSourcesSubject delegate;

        SingleSourceAdapter(FailureStrategy failureStrategy, JavaFileObject subject) {
            super(failureStrategy, (Object)subject);
            this.delegate = new JavaSourcesSubject(failureStrategy, (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)subject));
        }

        @Override
        public CompileTester processedWith(Processor first, Processor ... rest) {
            return this.delegate.newCompilationClause(Lists.asList((Object)first, (Object[])rest));
        }

        @Override
        public CompileTester processedWith(Iterable<? extends Processor> processors) {
            return this.delegate.newCompilationClause(processors);
        }

        @Override
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            return this.delegate.compilesWithoutError();
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            return this.delegate.failsToCompile();
        }
    }

    private final class SuccessfulCompilationBuilder
    implements CompileTester.SuccessfulCompilationClause,
    CompileTester.GeneratedPredicateClause {
        private final Compilation.Result result;

        SuccessfulCompilationBuilder(Compilation.Result result) {
            Preconditions.checkArgument((boolean)result.successful());
            this.result = result;
        }

        @Override
        public CompileTester.GeneratedPredicateClause and() {
            return this;
        }

        @Override
        public CompileTester.SuccessfulCompilationClause generatesSources(JavaFileObject first, JavaFileObject ... rest) {
            ImmutableList<JavaFileObject> generatedSources = this.result.generatedSources();
            Iterable<? extends CompilationUnitTree> actualCompilationUnits = Compilation.parse(generatedSources);
            final EqualityScanner scanner = new EqualityScanner();
            for (final CompilationUnitTree compilationUnitTree : Compilation.parse(Lists.asList((Object)first, (Object[])rest))) {
                Optional found = Iterables.tryFind(actualCompilationUnits, (Predicate)new Predicate<CompilationUnitTree>(){

                    public boolean apply(CompilationUnitTree actualTree) {
                        return scanner.visitCompilationUnit(compilationUnitTree, actualTree);
                    }
                });
                if (found.isPresent()) continue;
                final JavaFileObject expected = compilationUnitTree.getSourceFile();
                Optional actual = FluentIterable.from(generatedSources).firstMatch((Predicate)new Predicate<JavaFileObject>(){

                    public boolean apply(JavaFileObject generatedFile) {
                        return generatedFile.toUri().getPath().endsWith(expected.toUri().getPath());
                    }
                });
                if (actual.isPresent()) {
                    CharSequence actualSource = null;
                    try {
                        actualSource = ((JavaFileObject)actual.get()).getCharContent(false);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception reading source content.", e);
                    }
                    JavaSourcesSubject.this.failureStrategy.fail("Generated file " + expected.getName() + " did not match expectation. Found:\n" + (actualSource == null ? "no source found" : actualSource));
                    continue;
                }
                JavaSourcesSubject.this.failureStrategy.fail("Did not find a source file named " + expected.getName());
            }
            return this;
        }

        @Override
        public CompileTester.SuccessfulCompilationClause generatesFiles(JavaFileObject first, JavaFileObject ... rest) {
            for (JavaFileObject expected : Lists.asList((Object)first, (Object[])rest)) {
                if (this.wasGenerated(this.result, expected)) continue;
                JavaSourcesSubject.this.failureStrategy.fail("Did not find a generated file corresponding to " + expected.getName());
            }
            return this;
        }

        boolean wasGenerated(Compilation.Result result, JavaFileObject expected) {
            for (JavaFileObject generated : result.generatedFilesByKind().get((Object)expected.getKind())) {
                try {
                    if (!Arrays.equals(ByteStreams.toByteArray((InputStream)expected.openInputStream()), ByteStreams.toByteArray((InputStream)generated.openInputStream()))) continue;
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
    }

    private final class UnsuccessfulCompilationBuilder
    implements CompileTester.UnsuccessfulCompilationClause {
        private final Compilation.Result result;

        UnsuccessfulCompilationBuilder(Compilation.Result result) {
            Preconditions.checkArgument((!result.successful() ? 1 : 0) != 0);
            this.result = result;
        }

        @Override
        public CompileTester.FileClause withErrorContaining(final String messageFragment) {
            FluentIterable diagnostics = FluentIterable.from((Iterable)this.result.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR));
            final FluentIterable diagnosticsWithMessage = diagnostics.filter(new Predicate<Diagnostic<?>>(){

                public boolean apply(Diagnostic<?> input) {
                    return input.getMessage(null).contains(messageFragment);
                }
            });
            if (diagnosticsWithMessage.isEmpty()) {
                JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error containing \"%s\", but only found %s", messageFragment, diagnostics.transform(new Function<Diagnostic<?>, String>(){

                    public String apply(Diagnostic<?> input) {
                        return "\"" + input.getMessage(null) + "\"";
                    }
                })));
            }
            return new CompileTester.FileClause(){

                @Override
                public CompileTester.UnsuccessfulCompilationClause and() {
                    return UnsuccessfulCompilationBuilder.this;
                }

                @Override
                public CompileTester.LineClause in(final JavaFileObject file) {
                    final FluentIterable diagnosticsInFile = diagnosticsWithMessage.filter((Predicate)new Predicate<Diagnostic<? extends FileObject>>(){

                        public boolean apply(Diagnostic<? extends FileObject> input) {
                            return file.toUri().getPath().equals(input.getSource().toUri().getPath());
                        }
                    });
                    if (diagnosticsInFile.isEmpty()) {
                        JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error in %s, but only found errors in %s", file.getName(), diagnosticsWithMessage.transform((Function)new Function<Diagnostic<? extends FileObject>, String>(){

                            public String apply(Diagnostic<? extends FileObject> input) {
                                return input.getSource().getName();
                            }
                        })));
                    }
                    return new CompileTester.LineClause(){

                        @Override
                        public CompileTester.UnsuccessfulCompilationClause and() {
                            return UnsuccessfulCompilationBuilder.this;
                        }

                        @Override
                        public CompileTester.ColumnClause onLine(final long lineNumber) {
                            final FluentIterable diagnosticsOnLine = diagnosticsWithMessage.filter(new Predicate<Diagnostic<?>>(){

                                public boolean apply(Diagnostic<?> input) {
                                    return lineNumber == input.getLineNumber();
                                }
                            });
                            if (diagnosticsOnLine.isEmpty()) {
                                JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error on line %d of %s, but only found errors on line(s) %s", lineNumber, file.getName(), diagnosticsInFile.transform(new Function<Diagnostic<?>, Long>(){

                                    public Long apply(Diagnostic<?> input) {
                                        return input.getLineNumber();
                                    }
                                })));
                            }
                            return new CompileTester.ColumnClause(){

                                @Override
                                public CompileTester.UnsuccessfulCompilationClause and() {
                                    return UnsuccessfulCompilationBuilder.this;
                                }

                                @Override
                                public CompileTester.ChainingClause<CompileTester.UnsuccessfulCompilationClause> atColumn(final long columnNumber) {
                                    FluentIterable diagnosticsAtColumn = diagnosticsOnLine.filter(new Predicate<Diagnostic<?>>(){

                                        public boolean apply(Diagnostic<?> input) {
                                            return columnNumber == input.getColumnNumber();
                                        }
                                    });
                                    if (diagnosticsAtColumn.isEmpty()) {
                                        JavaSourcesSubject.this.failureStrategy.fail(String.format("Expected an error at %d:%d of %s, but only found errors at column(s) %s", lineNumber, columnNumber, file.getName(), diagnosticsOnLine.transform(new Function<Diagnostic<?>, Long>(){

                                            public Long apply(Diagnostic<?> input) {
                                                return input.getColumnNumber();
                                            }
                                        })));
                                    }
                                    return new CompileTester.ChainingClause<CompileTester.UnsuccessfulCompilationClause>(){

                                        @Override
                                        public CompileTester.UnsuccessfulCompilationClause and() {
                                            return UnsuccessfulCompilationBuilder.this;
                                        }
                                    };
                                }
                            };
                        }
                    };
                }
            };
        }
    }

    private final class CompilationClause
    implements CompileTester {
        private final ImmutableSet<Processor> processors;

        private CompilationClause() {
            this((Iterable<? extends Processor>)ImmutableSet.of());
        }

        private CompilationClause(Iterable<? extends Processor> processors) {
            this.processors = ImmutableSet.copyOf(processors);
        }

        @Override
        public CompileTester.SuccessfulCompilationClause compilesWithoutError() {
            Compilation.Result result = Compilation.compile(this.processors, (Iterable)JavaSourcesSubject.this.getSubject());
            if (!result.successful()) {
                ImmutableList errors = result.diagnosticsByKind().get((Object)Diagnostic.Kind.ERROR);
                StringBuilder message = new StringBuilder("Compilation produced the following errors:\n");
                Joiner.on((char)'\n').appendTo(message, (Iterable)errors);
                JavaSourcesSubject.this.failureStrategy.fail(message.toString());
            }
            return new SuccessfulCompilationBuilder(result);
        }

        @Override
        public CompileTester.UnsuccessfulCompilationClause failsToCompile() {
            Compilation.Result result = Compilation.compile(this.processors, (Iterable)JavaSourcesSubject.this.getSubject());
            if (result.successful()) {
                JavaSourcesSubject.this.failureStrategy.fail("Compilation was expected to fail, but contained no errors");
            }
            return new UnsuccessfulCompilationBuilder(result);
        }
    }
}

