/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.Capabilities;
import com.google.visualization.datasource.DataSourceRequest;
import com.google.visualization.datasource.DataTableGenerator;
import com.google.visualization.datasource.QueryPair;
import com.google.visualization.datasource.QuerySplitter;
import com.google.visualization.datasource.ResponseWriter;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.LocaleUtil;
import com.google.visualization.datasource.base.MessagesEnum;
import com.google.visualization.datasource.base.OutputType;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.base.StatusType;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.engine.QueryEngine;
import com.google.visualization.datasource.query.parser.QueryBuilder;
import com.google.visualization.datasource.render.CsvRenderer;
import com.google.visualization.datasource.render.HtmlRenderer;
import com.google.visualization.datasource.render.JsonRenderer;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceHelper {
    private static final Log log = LogFactory.getLog((String)DataSourceHelper.class.getName());
    static final String LOCALE_REQUEST_PARAMETER = "hl";

    private DataSourceHelper() {
    }

    public static void executeDataSourceServletFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DataTableGenerator dataTableGenerator) throws IOException {
        DataSourceHelper.executeDataSourceServletFlow(httpServletRequest, httpServletResponse, dataTableGenerator, true);
    }

    public static void executeDataSourceServletFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DataTableGenerator dataTableGenerator, boolean bl) throws IOException {
        DataSourceRequest dataSourceRequest = null;
        try {
            dataSourceRequest = new DataSourceRequest(httpServletRequest);
            if (bl) {
                DataSourceHelper.verifyAccessApproved(dataSourceRequest);
            }
            QueryPair queryPair = DataSourceHelper.splitQuery(dataSourceRequest.getQuery(), dataTableGenerator.getCapabilities());
            DataTable dataTable = dataTableGenerator.generateDataTable(queryPair.getDataSourceQuery(), httpServletRequest);
            DataTable dataTable2 = DataSourceHelper.applyQuery(queryPair.getCompletionQuery(), dataTable, dataSourceRequest.getUserLocale());
            DataSourceHelper.setServletResponse(dataTable2, dataSourceRequest, httpServletResponse);
        }
        catch (DataSourceException dataSourceException) {
            if (dataSourceRequest != null) {
                DataSourceHelper.setServletErrorResponse(dataSourceException, dataSourceRequest, httpServletResponse);
            } else {
                DataSourceHelper.setServletErrorResponse(dataSourceException, httpServletRequest, httpServletResponse);
            }
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)"A runtime exception has occured", (Throwable)runtimeException);
            ResponseStatus responseStatus = new ResponseStatus(StatusType.ERROR, ReasonType.INTERNAL_ERROR, runtimeException.getMessage());
            if (dataSourceRequest == null) {
                dataSourceRequest = DataSourceRequest.getDefaultDataSourceRequest(httpServletRequest);
            }
            DataSourceHelper.setServletErrorResponse(responseStatus, dataSourceRequest, httpServletResponse);
        }
    }

    public static void verifyAccessApproved(DataSourceRequest dataSourceRequest) throws DataSourceException {
        OutputType outputType = dataSourceRequest.getDataSourceParameters().getOutputType();
        if (outputType != OutputType.CSV && outputType != OutputType.TSV_EXCEL && outputType != OutputType.HTML && !dataSourceRequest.isSameOrigin()) {
            throw new DataSourceException(ReasonType.ACCESS_DENIED, "Unauthorized request. Cross domain requests are not supported.");
        }
    }

    public static void setServletResponse(DataTable dataTable, DataSourceRequest dataSourceRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = DataSourceHelper.generateResponse(dataTable, dataSourceRequest);
        DataSourceHelper.setServletResponse(string, dataSourceRequest, httpServletResponse);
    }

    public static void setServletResponse(String string, DataSourceRequest dataSourceRequest, HttpServletResponse httpServletResponse) throws IOException {
        DataSourceParameters dataSourceParameters = dataSourceRequest.getDataSourceParameters();
        ResponseWriter.setServletResponse(string, dataSourceParameters, httpServletResponse);
    }

    public static void setServletErrorResponse(DataSourceException dataSourceException, DataSourceRequest dataSourceRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = DataSourceHelper.generateErrorResponse(dataSourceException, dataSourceRequest);
        DataSourceHelper.setServletResponse(string, dataSourceRequest, httpServletResponse);
    }

    public static void setServletErrorResponse(ResponseStatus responseStatus, DataSourceRequest dataSourceRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = DataSourceHelper.generateErrorResponse(responseStatus, dataSourceRequest);
        DataSourceHelper.setServletResponse(string, dataSourceRequest, httpServletResponse);
    }

    public static void setServletErrorResponse(DataSourceException dataSourceException, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        DataSourceRequest dataSourceRequest = DataSourceRequest.getDefaultDataSourceRequest(httpServletRequest);
        DataSourceHelper.setServletErrorResponse(dataSourceException, dataSourceRequest, httpServletResponse);
    }

    public static String generateResponse(DataTable dataTable, DataSourceRequest dataSourceRequest) {
        CharSequence charSequence;
        ResponseStatus responseStatus = null;
        if (!dataTable.getWarnings().isEmpty()) {
            responseStatus = new ResponseStatus(StatusType.WARNING);
        }
        switch (dataSourceRequest.getDataSourceParameters().getOutputType()) {
            case CSV: {
                charSequence = CsvRenderer.renderDataTable(dataTable, dataSourceRequest.getUserLocale(), ",");
                break;
            }
            case TSV_EXCEL: {
                charSequence = CsvRenderer.renderDataTable(dataTable, dataSourceRequest.getUserLocale(), "\t");
                break;
            }
            case HTML: {
                charSequence = HtmlRenderer.renderDataTable(dataTable, dataSourceRequest.getUserLocale());
                break;
            }
            case JSONP: {
                charSequence = JsonRenderer.renderJsonResponse(dataSourceRequest.getDataSourceParameters(), responseStatus, dataTable);
                break;
            }
            case JSON: {
                charSequence = JsonRenderer.renderJsonResponse(dataSourceRequest.getDataSourceParameters(), responseStatus, dataTable);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
        return ((Object)charSequence).toString();
    }

    public static String generateErrorResponse(DataSourceException dataSourceException, DataSourceRequest dataSourceRequest) throws IOException {
        ResponseStatus responseStatus = ResponseStatus.createResponseStatus(dataSourceException);
        responseStatus = ResponseStatus.getModifiedResponseStatus(responseStatus);
        return DataSourceHelper.generateErrorResponse(responseStatus, dataSourceRequest);
    }

    public static String generateErrorResponse(ResponseStatus responseStatus, DataSourceRequest dataSourceRequest) throws IOException {
        CharSequence charSequence;
        DataSourceParameters dataSourceParameters = dataSourceRequest.getDataSourceParameters();
        switch (dataSourceParameters.getOutputType()) {
            case CSV: 
            case TSV_EXCEL: {
                charSequence = CsvRenderer.renderCsvError(responseStatus);
                break;
            }
            case HTML: {
                charSequence = HtmlRenderer.renderHtmlError(responseStatus);
                break;
            }
            case JSONP: {
                charSequence = JsonRenderer.renderJsonResponse(dataSourceParameters, responseStatus, null);
                break;
            }
            case JSON: {
                charSequence = JsonRenderer.renderJsonResponse(dataSourceParameters, responseStatus, null);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
        return charSequence.toString();
    }

    public static Query parseQuery(String string) throws InvalidQueryException {
        return DataSourceHelper.parseQuery(string, null);
    }

    public static Query parseQuery(String string, ULocale uLocale) throws InvalidQueryException {
        QueryBuilder queryBuilder = QueryBuilder.getInstance();
        Query query = queryBuilder.parseQuery(string, uLocale);
        return query;
    }

    public static DataTable applyQuery(Query query, DataTable dataTable, ULocale uLocale) throws InvalidQueryException, DataSourceException {
        dataTable.setLocaleForUserMessages(uLocale);
        DataSourceHelper.validateQueryAgainstColumnStructure(query, dataTable);
        dataTable = QueryEngine.executeQuery(query, dataTable, uLocale);
        dataTable.setLocaleForUserMessages(uLocale);
        return dataTable;
    }

    public static QueryPair splitQuery(Query query, Capabilities capabilities) throws DataSourceException {
        return QuerySplitter.splitQuery(query, capabilities);
    }

    public static void validateQueryAgainstColumnStructure(Query query, DataTable dataTable) throws InvalidQueryException {
        Set<String> set = query.getAllColumnIds();
        for (String object22 : set) {
            if (dataTable.containsColumn(object22)) continue;
            String string = MessagesEnum.NO_COLUMN.getMessageWithArgs(dataTable.getLocaleForUserMessages(), object22);
            log.error((Object)string);
            throw new InvalidQueryException(string);
        }
        Set<AggregationColumn> set2 = query.getAllAggregations();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            AggregationColumn aggregationColumn = (AggregationColumn)iterator.next();
            try {
                aggregationColumn.validateColumn(dataTable);
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)"A runtime exception has occured", (Throwable)runtimeException);
                throw new InvalidQueryException(runtimeException.getMessage());
            }
        }
        Set<ScalarFunctionColumn> set3 = query.getAllScalarFunctionsColumns();
        for (ScalarFunctionColumn scalarFunctionColumn : set3) {
            scalarFunctionColumn.validateColumn(dataTable);
        }
    }

    public static ULocale getLocaleFromRequest(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter(LOCALE_REQUEST_PARAMETER);
        Locale locale = string != null ? LocaleUtil.getLocaleFromLocaleString(string) : httpServletRequest.getLocale();
        return ULocale.forLocale((Locale)locale);
    }
}

