/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.Capabilities;
import com.google.visualization.datasource.QueryPair;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QuerySplitter {
    private static final Log log = LogFactory.getLog((String)QuerySplitter.class.getName());

    private QuerySplitter() {
    }

    public static QueryPair splitQuery(Query query, Capabilities capabilities) throws DataSourceException {
        switch (capabilities) {
            case ALL: {
                return QuerySplitter.splitAll(query);
            }
            case NONE: {
                return QuerySplitter.splitNone(query);
            }
            case SQL: {
                return QuerySplitter.splitSQL(query);
            }
            case SORT_AND_PAGINATION: {
                return QuerySplitter.splitSortAndPagination(query);
            }
            case SELECT: {
                return QuerySplitter.splitSelect(query);
            }
        }
        log.error((Object)"Capabilities not supported.");
        throw new DataSourceException(ReasonType.NOT_SUPPORTED, "Capabilities not supported.");
    }

    private static QueryPair splitAll(Query query) {
        Query query2 = new Query();
        query2.copyFrom(query);
        Query query3 = new Query();
        return new QueryPair(query2, query3);
    }

    private static QueryPair splitNone(Query query) {
        Query query2 = new Query();
        query2.copyFrom(query);
        return new QueryPair(null, query2);
    }

    private static QueryPair splitSQL(Query query) {
        if (!query.getAllScalarFunctionsColumns().isEmpty() || query.hasPivot() && (query.hasUserFormatOptions() && !query.getUserFormatOptions().getAggregationColumns().isEmpty() || query.hasLabels() && !query.getLabels().getAggregationColumns().isEmpty())) {
            Query query2 = new Query();
            query2.copyFrom(query);
            return new QueryPair(new Query(), query2);
        }
        Query query3 = new Query();
        Query query4 = new Query();
        if (query.hasPivot()) {
            Object object3;
            Object object22;
            List<AbstractColumn> list = query.getPivot().getColumns();
            query3.copyFrom(query);
            query3.setPivot(null);
            query3.setSort(null);
            query3.setOptions(null);
            query3.setLabels(null);
            query3.setUserFormatOptions(null);
            try {
                query3.setRowSkipping(0);
                query3.setRowLimit(-1);
                query3.setRowOffset(0);
            }
            catch (InvalidQueryException invalidQueryException) {
                // empty catch block
            }
            ArrayList arrayList = Lists.newArrayList();
            ArrayList arrayList2 = Lists.newArrayList();
            if (query3.hasGroup()) {
                arrayList.addAll(query3.getGroup().getColumns());
            }
            arrayList.addAll(list);
            if (query3.hasSelection()) {
                arrayList2.addAll(query3.getSelection().getColumns());
            }
            arrayList2.addAll(list);
            QueryGroup queryGroup = new QueryGroup();
            for (Object object22 : arrayList) {
                queryGroup.addColumn((AbstractColumn)object22);
            }
            query3.setGroup(queryGroup);
            QuerySelection querySelection = new QuerySelection();
            for (Object object3 : arrayList2) {
                querySelection.addColumn((AbstractColumn)object3);
            }
            query3.setSelection(querySelection);
            query4.copyFrom(query);
            query4.setFilter(null);
            object22 = new QuerySelection();
            object3 = query.getSelection().getColumns();
            for (int i = 0; i < object3.size(); ++i) {
                AbstractColumn abstractColumn = (AbstractColumn)object3.get(i);
                if (query.getGroup().getColumns().contains(abstractColumn)) {
                    ((QuerySelection)object22).addColumn(abstractColumn);
                    continue;
                }
                String string = abstractColumn.getId();
                ((QuerySelection)object22).addColumn(new AggregationColumn(new SimpleColumn(string), AggregationType.MIN));
            }
            query4.setSelection((QuerySelection)object22);
        } else {
            query3.copyFrom(query);
            query3.setOptions(null);
            query4.setOptions(query.getOptions());
            try {
                Object object;
                Object object4;
                if (query.hasRowSkipping()) {
                    query3.setRowSkipping(0);
                    query3.setRowLimit(-1);
                    query3.setRowOffset(0);
                    query4.copyRowSkipping(query);
                    query4.copyRowLimit(query);
                    query4.copyRowOffset(query);
                }
                if (query.hasLabels()) {
                    query3.setLabels(null);
                    object4 = query.getLabels();
                    object = new QueryLabels();
                    for (AbstractColumn abstractColumn : ((QueryLabels)object4).getColumns()) {
                        ((QueryLabels)object).addLabel(new SimpleColumn(abstractColumn.getId()), ((QueryLabels)object4).getLabel(abstractColumn));
                    }
                    query4.setLabels((QueryLabels)object);
                }
                if (query.hasUserFormatOptions()) {
                    query3.setUserFormatOptions(null);
                    object4 = query.getUserFormatOptions();
                    object = new QueryFormat();
                    for (AbstractColumn abstractColumn : ((QueryFormat)object4).getColumns()) {
                        ((QueryFormat)object).addPattern(new SimpleColumn(abstractColumn.getId()), ((QueryFormat)object4).getPattern(abstractColumn));
                    }
                    query4.setUserFormatOptions((QueryFormat)object);
                }
            }
            catch (InvalidQueryException invalidQueryException) {
                // empty catch block
            }
        }
        return new QueryPair(query3, query4);
    }

    private static QueryPair splitSortAndPagination(Query query) {
        if (!query.getAllScalarFunctionsColumns().isEmpty()) {
            Query query2 = new Query();
            query2.copyFrom(query);
            return new QueryPair(new Query(), query2);
        }
        Query query3 = new Query();
        Query query4 = new Query();
        if (query.hasFilter() || query.hasGroup() || query.hasPivot()) {
            query4.copyFrom(query);
        } else {
            query3.setSort(query.getSort());
            if (query.hasRowSkipping()) {
                query4.copyRowSkipping(query);
                query4.copyRowLimit(query);
                query4.copyRowOffset(query);
            } else {
                query3.copyRowLimit(query);
                query3.copyRowOffset(query);
            }
            query4.setSelection(query.getSelection());
            query4.setOptions(query.getOptions());
            query4.setLabels(query.getLabels());
            query4.setUserFormatOptions(query.getUserFormatOptions());
        }
        return new QueryPair(query3, query4);
    }

    private static QueryPair splitSelect(Query query) {
        Query query2 = new Query();
        Query query3 = new Query();
        if (query.getSelection() != null) {
            QuerySelection querySelection = new QuerySelection();
            for (String string : query.getAllColumnIds()) {
                querySelection.addColumn(new SimpleColumn(string));
            }
            query2.setSelection(querySelection);
        }
        query3.copyFrom(query);
        return new QueryPair(query2, query3);
    }
}

