/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource;

import com.google.visualization.datasource.base.DataSourceParameters;
import com.google.visualization.datasource.base.OutputType;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResponseWriter {
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};

    private ResponseWriter() {
    }

    public static void setServletResponse(String string, DataSourceParameters dataSourceParameters, HttpServletResponse httpServletResponse) throws IOException {
        OutputType outputType = dataSourceParameters.getOutputType();
        switch (outputType) {
            case CSV: {
                ResponseWriter.setServletResponseCSV(dataSourceParameters, httpServletResponse);
                ResponseWriter.writeServletResponse(string, httpServletResponse);
                break;
            }
            case TSV_EXCEL: {
                ResponseWriter.setServletResponseTSVExcel(dataSourceParameters, httpServletResponse);
                ResponseWriter.writeServletResponse(string, httpServletResponse, "UTF-16LE", UTF_16LE_BOM);
                break;
            }
            case HTML: {
                ResponseWriter.setServletResponseHTML(httpServletResponse);
                ResponseWriter.writeServletResponse(string, httpServletResponse);
                break;
            }
            case JSONP: {
                ResponseWriter.setServletResponseJSONP(httpServletResponse);
                ResponseWriter.writeServletResponse(string, httpServletResponse);
                break;
            }
            case JSON: {
                ResponseWriter.setServletResponseJSON(httpServletResponse);
                ResponseWriter.writeServletResponse(string, httpServletResponse);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled output type.");
            }
        }
    }

    static void setServletResponseCSV(DataSourceParameters dataSourceParameters, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/csv; charset=UTF-8");
        String string = dataSourceParameters.getOutFileName();
        if (!string.toLowerCase().endsWith(".csv")) {
            string = string + ".csv";
        }
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + string);
    }

    static void setServletResponseTSVExcel(DataSourceParameters dataSourceParameters, HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/csv; charset=UTF-16LE");
        String string = dataSourceParameters.getOutFileName();
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + string);
    }

    static void setServletResponseHTML(HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/html; charset=UTF-8");
    }

    static void setServletResponseJSONP(HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("text/javascript; charset=UTF-8");
    }

    static void setServletResponseJSON(HttpServletResponse httpServletResponse) {
        httpServletResponse.setContentType("application/json; charset=UTF-8");
    }

    private static void writeServletResponse(CharSequence charSequence, HttpServletResponse httpServletResponse) throws IOException {
        ResponseWriter.writeServletResponse(charSequence, httpServletResponse, "UTF-8", null);
    }

    private static void writeServletResponse(CharSequence charSequence, HttpServletResponse httpServletResponse, String string, byte[] byArray) throws IOException {
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (byArray != null) {
            servletOutputStream.write(byArray);
        }
        servletOutputStream.write(((Object)charSequence).toString().getBytes(string));
    }
}

