/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.datatable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;

public class DataTable {
    private List<ColumnDescription> columns = Lists.newArrayList();
    private Map<String, Integer> columnIndexById = Maps.newHashMap();
    private List<TableRow> rows = Lists.newArrayList();
    private Map<String, String> customProperties = null;
    private List<Warning> warnings = Lists.newArrayList();
    private ULocale localeForUserMessages = null;

    public void addRow(TableRow tableRow) throws TypeMismatchException {
        int n;
        List<TableCell> list = tableRow.getCells();
        if (list.size() > this.columns.size()) {
            throw new TypeMismatchException("Row has too many cells. Should be at most of size: " + this.columns.size());
        }
        for (n = 0; n < list.size(); ++n) {
            if (list.get(n).getType() == this.columns.get(n).getType()) continue;
            throw new TypeMismatchException("Cell type does not match column type, at index: " + n + ". Should be of type: " + this.columns.get(n).getType().toString());
        }
        for (n = list.size(); n < this.columns.size(); ++n) {
            tableRow.addCell(new TableCell(Value.getNullValueFromValueType(this.columns.get(n).getType())));
        }
        this.rows.add(tableRow);
    }

    public void addRowFromValues(Object ... objectArray) throws TypeMismatchException {
        ListIterator<ColumnDescription> listIterator = this.columns.listIterator();
        TableRow tableRow = new TableRow();
        for (int i = 0; i < objectArray.length && listIterator.hasNext(); ++i) {
            ColumnDescription columnDescription = (ColumnDescription)listIterator.next();
            tableRow.addCell(columnDescription.getType().createValue(objectArray[i]));
        }
        this.addRow(tableRow);
    }

    public void addRows(Collection<TableRow> collection) throws TypeMismatchException {
        for (TableRow tableRow : collection) {
            this.addRow(tableRow);
        }
    }

    public void setRows(Collection<TableRow> collection) throws TypeMismatchException {
        this.rows.clear();
        this.addRows(collection);
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public TableRow getRow(int n) {
        return this.rows.get(n);
    }

    public int getNumberOfRows() {
        return this.rows.size();
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public List<ColumnDescription> getColumnDescriptions() {
        return ImmutableList.copyOf(this.columns);
    }

    public ColumnDescription getColumnDescription(int n) {
        return this.columns.get(n);
    }

    public ColumnDescription getColumnDescription(String string) {
        return this.columns.get(this.getColumnIndex(string));
    }

    public List<TableCell> getColumnCells(int n) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.getNumberOfRows());
        for (TableRow tableRow : this.getRows()) {
            arrayList.add(tableRow.getCell(n));
        }
        return arrayList;
    }

    public void addColumn(ColumnDescription columnDescription) {
        String string = columnDescription.getId();
        if (this.columnIndexById.containsKey(string)) {
            throw new RuntimeException("Column Id [" + string + "] already in table description");
        }
        this.columnIndexById.put(string, this.columns.size());
        this.columns.add(columnDescription);
        for (TableRow tableRow : this.rows) {
            tableRow.addCell(new TableCell(Value.getNullValueFromValueType(columnDescription.getType())));
        }
    }

    public void addColumns(Collection<ColumnDescription> collection) {
        for (ColumnDescription columnDescription : collection) {
            this.addColumn(columnDescription);
        }
    }

    public int getColumnIndex(String string) {
        return this.columnIndexById.get(string);
    }

    public List<TableCell> getColumnCells(String string) {
        return this.getColumnCells(this.getColumnIndex(string));
    }

    public TableCell getCell(int n, int n2) {
        return this.getRow(n).getCell(n2);
    }

    public TableCell setCell(int n, int n2, TableCell tableCell) throws TypeMismatchException, IndexOutOfBoundsException {
        TableRow tableRow = this.rows.get(n);
        if (!tableRow.getCell(n2).getType().equals((Object)tableCell.getType())) {
            throw new TypeMismatchException("New cell value type does not match expected value type. Expected type: " + (Object)((Object)tableRow.getCell(n2).getType()) + " but was: " + tableCell.getType().toString());
        }
        return tableRow.setCell(n2, tableCell);
    }

    public Value getValue(int n, int n2) {
        return this.getCell(n, n2).getValue();
    }

    public List<Warning> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    public List<TableCell> getColumnDistinctCellsSorted(int n, Comparator<TableCell> comparator) {
        TreeSet treeSet = Sets.newTreeSet(comparator);
        for (TableCell tableCell : this.getColumnCells(n)) {
            treeSet.add(tableCell);
        }
        return Ordering.from(comparator).sortedCopy((Iterable)treeSet);
    }

    List<Value> getColumnDistinctValues(int n) {
        TreeSet treeSet = Sets.newTreeSet();
        for (TableRow tableRow : this.getRows()) {
            treeSet.add(tableRow.getCell(n).getValue());
        }
        return Lists.newArrayList((Iterable)treeSet);
    }

    public void addWarning(Warning warning) {
        this.warnings.add(warning);
    }

    List<Value> getColumnDistinctValues(String string) {
        return this.getColumnDistinctValues(this.getColumnIndex(string));
    }

    public boolean containsColumn(String string) {
        return this.columnIndexById.containsKey(string);
    }

    public boolean containsAllColumnIds(Collection<String> collection) {
        for (String string : collection) {
            if (this.containsColumn(string)) continue;
            return false;
        }
        return true;
    }

    public static DataTable createSingleCellTable(String string) {
        DataTable dataTable = new DataTable();
        ColumnDescription columnDescription = new ColumnDescription("SingleCellTable", ValueType.TEXT, "");
        dataTable.addColumn(columnDescription);
        TableRow tableRow = new TableRow();
        tableRow.addCell(new TableCell(string));
        try {
            dataTable.addRow(tableRow);
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return dataTable;
    }

    public DataTable clone() {
        DataTable dataTable = new DataTable();
        for (ColumnDescription object : this.columns) {
            dataTable.addColumn(object.clone());
        }
        try {
            for (TableRow tableRow : this.rows) {
                dataTable.addRow(tableRow.clone());
            }
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        if (this.customProperties != null) {
            dataTable.customProperties = Maps.newHashMap();
            for (Map.Entry entry : this.customProperties.entrySet()) {
                dataTable.customProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        dataTable.warnings = Lists.newArrayList();
        for (Warning warning : this.warnings) {
            dataTable.warnings.add(warning);
        }
        dataTable.setLocaleForUserMessages(this.localeForUserMessages);
        return dataTable;
    }

    public String getCustomProperty(String string) {
        if (this.customProperties == null) {
            return null;
        }
        if (string == null) {
            throw new RuntimeException("Null keys are not allowed.");
        }
        return this.customProperties.get(string);
    }

    public void setCustomProperty(String string, String string2) {
        if (this.customProperties == null) {
            this.customProperties = Maps.newHashMap();
        }
        if (string == null || string2 == null) {
            throw new RuntimeException("Null keys/values are not allowed.");
        }
        this.customProperties.put(string, string2);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.rows.size(); ++i) {
            TableRow tableRow = this.rows.get(i);
            for (int j = 0; j < tableRow.getCells().size(); ++j) {
                TableCell tableCell = tableRow.getCells().get(j);
                stringBuilder.append(tableCell.toString());
                if (j >= tableRow.getCells().size() - 1) continue;
                stringBuilder.append(",");
            }
            if (i >= this.rows.size() - 1) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void setLocaleForUserMessages(ULocale uLocale) {
        this.localeForUserMessages = uLocale;
    }

    public ULocale getLocaleForUserMessages() {
        return this.localeForUserMessages;
    }
}

