/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import java.util.ArrayList;
import java.util.List;

public class QuerySelection {
    private List<AbstractColumn> columns;

    public QuerySelection() {
        this.columns = Lists.newArrayList();
    }

    public QuerySelection(QuerySelection querySelection) {
        this.columns = Lists.newArrayList(querySelection.columns);
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public void addColumn(AbstractColumn abstractColumn) {
        this.columns.add(abstractColumn);
    }

    public List<AbstractColumn> getColumns() {
        return ImmutableList.copyOf(this.columns);
    }

    public List<AggregationColumn> getAggregationColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllAggregationColumns());
        }
        return arrayList;
    }

    public List<SimpleColumn> getSimpleColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllSimpleColumns());
        }
        return arrayList;
    }

    public List<ScalarFunctionColumn> getScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllScalarFunctionColumns());
        }
        return arrayList;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.columns == null ? 0 : ((Object)this.columns).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        QuerySelection querySelection = (QuerySelection)object;
        return !(this.columns == null ? querySelection.columns != null : !((Object)this.columns).equals(querySelection.columns));
    }

    public String toQueryString() {
        return Query.columnListToQueryString(this.columns);
    }
}

