/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query;

import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ColumnLookup;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.text.StrBuilder;

public class ScalarFunctionColumn
extends AbstractColumn {
    public static final String COLUMN_FUNCTION_TYPE_SEPARATOR = "_";
    public static final String COLUMN_COLUMN_SEPARATOR = ",";
    private List<AbstractColumn> columns;
    private ScalarFunction scalarFunction;

    public ScalarFunctionColumn(List<AbstractColumn> list, ScalarFunction scalarFunction) {
        this.columns = list;
        this.scalarFunction = scalarFunction;
    }

    @Override
    public String getId() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.add(abstractColumn.getId());
        }
        return new StrBuilder(this.scalarFunction.getFunctionName()).append(COLUMN_FUNCTION_TYPE_SEPARATOR).appendWithSeparators((Collection)arrayList, COLUMN_COLUMN_SEPARATOR).toString();
    }

    @Override
    public List<String> getAllSimpleColumnIds() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllSimpleColumnIds());
        }
        return arrayList;
    }

    public ScalarFunction getFunction() {
        return this.scalarFunction;
    }

    public List<AbstractColumn> getColumns() {
        return this.columns;
    }

    @Override
    public TableCell getCell(ColumnLookup columnLookup, TableRow tableRow) {
        if (columnLookup.containsColumn(this)) {
            int n = columnLookup.getColumnIndex(this);
            return tableRow.getCells().get(n);
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.add(abstractColumn.getValue(columnLookup, tableRow));
        }
        return new TableCell(this.scalarFunction.evaluate(arrayList));
    }

    @Override
    public List<SimpleColumn> getAllSimpleColumns() {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllSimpleColumns());
        }
        return arrayList;
    }

    @Override
    public List<AggregationColumn> getAllAggregationColumns() {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllAggregationColumns());
        }
        return arrayList;
    }

    @Override
    public List<ScalarFunctionColumn> getAllScalarFunctionColumns() {
        ArrayList arrayList = Lists.newArrayList((Object[])new ScalarFunctionColumn[]{this});
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.addAll(abstractColumn.getAllScalarFunctionColumns());
        }
        return arrayList;
    }

    @Override
    public void validateColumn(DataTable dataTable) throws InvalidQueryException {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn abstractColumn : this.columns) {
            abstractColumn.validateColumn(dataTable);
            arrayList.add(abstractColumn.getValueType(dataTable));
        }
        this.scalarFunction.validateParameters(arrayList);
    }

    @Override
    public ValueType getValueType(DataTable dataTable) {
        if (dataTable.containsColumn(this.getId())) {
            return dataTable.getColumnDescription(this.getId()).getType();
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.columns.size());
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.add(abstractColumn.getValueType(dataTable));
        }
        return this.scalarFunction.getReturnType(arrayList);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ScalarFunctionColumn) {
            ScalarFunctionColumn scalarFunctionColumn = (ScalarFunctionColumn)object;
            return ((Object)this.columns).equals(scalarFunctionColumn.columns) && this.scalarFunction.equals(scalarFunctionColumn.scalarFunction);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1279;
        for (AbstractColumn abstractColumn : this.columns) {
            n = n * 17 + abstractColumn.hashCode();
        }
        n = n * 17 + this.scalarFunction.hashCode();
        return n;
    }

    @Override
    public String toQueryString() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.add(abstractColumn.toQueryString());
        }
        return this.scalarFunction.toQueryString(arrayList);
    }

    public String toString() {
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractColumn abstractColumn : this.columns) {
            arrayList.add(abstractColumn.toString());
        }
        return new StrBuilder(this.scalarFunction.getFunctionName()).append("(").appendWithSeparators((Collection)arrayList, COLUMN_COLUMN_SEPARATOR).append(")").toString();
    }
}

