/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.engine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.ColumnLookup;
import com.google.visualization.datasource.query.DataTableColumnLookup;
import com.google.visualization.datasource.query.GenericColumnLookup;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.engine.AggregationPath;
import com.google.visualization.datasource.query.engine.ColumnIndices;
import com.google.visualization.datasource.query.engine.ColumnTitle;
import com.google.visualization.datasource.query.engine.GroupingComparators;
import com.google.visualization.datasource.query.engine.MetaTable;
import com.google.visualization.datasource.query.engine.RowTitle;
import com.google.visualization.datasource.query.engine.ScalarFunctionColumnTitle;
import com.google.visualization.datasource.query.engine.TableAggregator;
import com.google.visualization.datasource.query.engine.TableRowComparator;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public final class QueryEngine {
    private QueryEngine() {
    }

    private static DataTable createDataTable(List<String> list, SortedSet<ColumnTitle> sortedSet, DataTable dataTable, List<ScalarFunctionColumnTitle> list2) {
        DataTable dataTable2 = new DataTable();
        for (String object : list) {
            dataTable2.addColumn(dataTable.getColumnDescription(object));
        }
        for (ColumnTitle columnTitle : sortedSet) {
            dataTable2.addColumn(columnTitle.createColumnDescription(dataTable));
        }
        for (ScalarFunctionColumnTitle scalarFunctionColumnTitle : list2) {
            dataTable2.addColumn(scalarFunctionColumnTitle.createColumnDescription(dataTable));
        }
        return dataTable2;
    }

    public static DataTable executeQuery(Query query, DataTable dataTable, ULocale uLocale) {
        ColumnIndices columnIndices = new ColumnIndices();
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        for (int i = 0; i < list.size(); ++i) {
            columnIndices.put(new SimpleColumn(list.get(i).getId()), i);
        }
        TreeMap<List<Value>, ColumnLookup> treeMap = new TreeMap<List<Value>, ColumnLookup>(GroupingComparators.VALUE_LIST_COMPARATOR);
        try {
            dataTable = QueryEngine.performFilter(dataTable, query);
            dataTable = QueryEngine.performGroupingAndPivoting(dataTable, query, columnIndices, treeMap);
            dataTable = QueryEngine.performSort(dataTable, query, uLocale);
            dataTable = QueryEngine.performSkipping(dataTable, query);
            dataTable = QueryEngine.performPagination(dataTable, query);
            AtomicReference<ColumnIndices> atomicReference = new AtomicReference<ColumnIndices>(columnIndices);
            dataTable = QueryEngine.performSelection(dataTable, query, atomicReference, treeMap);
            columnIndices = atomicReference.get();
            dataTable = QueryEngine.performLabels(dataTable, query, columnIndices);
            dataTable = QueryEngine.performFormatting(dataTable, query, columnIndices, uLocale);
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return dataTable;
    }

    private static DataTable performSkipping(DataTable dataTable, Query query) throws TypeMismatchException {
        int n = query.getRowSkipping();
        if (n <= 1) {
            return dataTable;
        }
        int n2 = dataTable.getNumberOfRows();
        ArrayList<TableRow> arrayList = new ArrayList<TableRow>();
        for (int i = 0; i < n2; i += n) {
            arrayList.add(dataTable.getRows().get(i));
        }
        DataTable dataTable2 = new DataTable();
        dataTable2.addColumns(dataTable.getColumnDescriptions());
        dataTable2.addRows(arrayList);
        return dataTable2;
    }

    private static DataTable performPagination(DataTable dataTable, Query query) throws TypeMismatchException {
        int n = query.getRowOffset();
        int n2 = query.getRowLimit();
        if ((n2 == -1 || dataTable.getRows().size() <= n2) && n == 0) {
            return dataTable;
        }
        int n3 = dataTable.getNumberOfRows();
        int n4 = Math.max(0, n);
        int n5 = n2 == -1 ? n3 : Math.min(n3, n + n2);
        List<TableRow> list = dataTable.getRows().subList(n4, n5);
        DataTable dataTable2 = new DataTable();
        dataTable2.addColumns(dataTable.getColumnDescriptions());
        dataTable2.addRows(list);
        if (n5 < n3) {
            Warning warning = new Warning(ReasonType.DATA_TRUNCATED, "Data has been truncated due to userrequest (LIMIT in query)");
            dataTable2.addWarning(warning);
        }
        return dataTable2;
    }

    private static DataTable performSort(DataTable dataTable, Query query, ULocale uLocale) {
        if (!query.hasSort()) {
            return dataTable;
        }
        QuerySort querySort = query.getSort();
        DataTableColumnLookup dataTableColumnLookup = new DataTableColumnLookup(dataTable);
        TableRowComparator tableRowComparator = new TableRowComparator(querySort, uLocale, dataTableColumnLookup);
        Collections.sort(dataTable.getRows(), tableRowComparator);
        return dataTable;
    }

    private static DataTable performFilter(DataTable dataTable, Query query) throws TypeMismatchException {
        if (!query.hasFilter()) {
            return dataTable;
        }
        ArrayList arrayList = Lists.newArrayList();
        QueryFilter queryFilter = query.getFilter();
        for (TableRow tableRow : dataTable.getRows()) {
            if (!queryFilter.isMatch(dataTable, tableRow)) continue;
            arrayList.add(tableRow);
        }
        dataTable.setRows(arrayList);
        return dataTable;
    }

    private static DataTable performSelection(DataTable dataTable, Query query, AtomicReference<ColumnIndices> atomicReference, Map<List<Value>, ColumnLookup> map) throws TypeMismatchException {
        Object object;
        if (!query.hasSelection()) {
            return dataTable;
        }
        ColumnIndices columnIndices = atomicReference.get();
        List<AbstractColumn> list = query.getSelection().getColumns();
        ArrayList arrayList = Lists.newArrayList();
        List<ColumnDescription> list2 = dataTable.getColumnDescriptions();
        ArrayList arrayList2 = Lists.newArrayList();
        ColumnIndices columnIndices2 = new ColumnIndices();
        int n = 0;
        for (AbstractColumn object2 : list) {
            List<Integer> list3 = columnIndices.getColumnIndices(object2);
            arrayList.addAll(list3);
            if (list3.size() == 0) {
                arrayList2.add(new ColumnDescription(object2.getId(), object2.getValueType(dataTable), ScalarFunctionColumnTitle.getColumnDescriptionLabel(dataTable, object2)));
                columnIndices2.put(object2, n++);
                continue;
            }
            object = list3.iterator();
            while (object.hasNext()) {
                int n2 = object.next();
                arrayList2.add(list2.get(n2));
                columnIndices2.put(object2, n++);
            }
        }
        columnIndices = columnIndices2;
        atomicReference.set(columnIndices);
        DataTable dataTable2 = new DataTable();
        dataTable2.addColumns(arrayList2);
        for (TableRow tableRow : dataTable.getRows()) {
            object = new TableRow();
            for (AbstractColumn abstractColumn : list) {
                boolean bl = false;
                Set<List<Value>> set = map.keySet();
                for (List<Value> list4 : set) {
                    if (!map.get(list4).containsColumn(abstractColumn) || abstractColumn.getAllAggregationColumns().size() == 0 && bl) continue;
                    bl = true;
                    ((TableRow)object).addCell(tableRow.getCell(map.get(list4).getColumnIndex(abstractColumn)));
                }
                if (bl) continue;
                DataTableColumnLookup dataTableColumnLookup = new DataTableColumnLookup(dataTable);
                ((TableRow)object).addCell(abstractColumn.getCell(dataTableColumnLookup, tableRow));
            }
            dataTable2.addRow((TableRow)object);
        }
        return dataTable2;
    }

    private static boolean queryHasAggregation(Query query) {
        return query.hasSelection() && !query.getSelection().getAggregationColumns().isEmpty();
    }

    private static DataTable performGroupingAndPivoting(DataTable object, Query query, ColumnIndices columnIndices, TreeMap<List<Value>, ColumnLookup> treeMap) throws TypeMismatchException {
        Object object2;
        Object object3;
        Iterator iterator2;
        Object object42;
        Object object5;
        Object object62;
        Object object72;
        if (!QueryEngine.queryHasAggregation(query) || ((DataTable)object).getNumberOfRows() == 0) {
            return object;
        }
        QueryGroup queryGroup = query.getGroup();
        QueryPivot queryPivot = query.getPivot();
        QuerySelection querySelection = query.getSelection();
        List<Object> list2 = Lists.newArrayList();
        if (queryGroup != null) {
            list2 = queryGroup.getColumnIds();
        }
        List<Object> list3 = Lists.newArrayList();
        if (queryPivot != null) {
            list3 = queryPivot.getColumnIds();
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)list2);
        arrayList.addAll(list3);
        List<AggregationColumn> list4 = querySelection.getAggregationColumns();
        List<ScalarFunctionColumn> list5 = querySelection.getScalarFunctionColumns();
        ArrayList arrayList2 = Lists.newArrayListWithExpectedSize((int)list4.size());
        for (AggregationColumn object142 : list4) {
            if (arrayList2.contains(object142)) continue;
            arrayList2.add(object142);
        }
        ArrayList arrayList3 = Lists.newArrayList();
        for (Object object72 : arrayList2) {
            arrayList3.add(((AggregationColumn)object72).getAggregatedColumn().getId());
        }
        ArrayList arrayList4 = Lists.newArrayList();
        if (queryGroup != null) {
            arrayList4.addAll(queryGroup.getScalarFunctionColumns());
        }
        if (queryPivot != null) {
            arrayList4.addAll(queryPivot.getScalarFunctionColumns());
        }
        object72 = Lists.newArrayList();
        object72.addAll(((DataTable)object).getColumnDescriptions());
        for (Object object62 : arrayList4) {
            object72.add(new ColumnDescription(((ScalarFunctionColumn)object62).getId(), ((ScalarFunctionColumn)object62).getValueType((DataTable)object), ScalarFunctionColumnTitle.getColumnDescriptionLabel((DataTable)object, (AbstractColumn)object62)));
        }
        DataTable dataTable = new DataTable();
        dataTable.addColumns((Collection<ColumnDescription>)object72);
        object62 = new DataTableColumnLookup((DataTable)object);
        for (TableRow tableRow : ((DataTable)object).getRows()) {
            object5 = new TableRow();
            for (TableCell tableCell : tableRow.getCells()) {
                ((TableRow)object5).addCell(tableCell);
            }
            for (ScalarFunctionColumn scalarFunctionColumn : arrayList4) {
                ((TableRow)object5).addCell(new TableCell(scalarFunctionColumn.getValue((ColumnLookup)object62, tableRow)));
            }
            try {
                dataTable.addRow((TableRow)object5);
            }
            catch (TypeMismatchException typeMismatchException) {}
        }
        object = dataTable;
        TableAggregator tableAggregator = new TableAggregator(arrayList, Sets.newHashSet((Iterable)arrayList3), (DataTable)object);
        Set<AggregationPath> set = tableAggregator.getPathsToLeaves();
        object5 = Sets.newTreeSet(GroupingComparators.ROW_TITLE_COMPARATOR);
        TreeSet treeSet = Sets.newTreeSet(GroupingComparators.getColumnTitleDynamicComparator(arrayList2));
        TreeSet treeSet2 = Sets.newTreeSet(GroupingComparators.VALUE_LIST_COMPARATOR);
        MetaTable metaTable = new MetaTable();
        for (Object object42 : arrayList2) {
            for (Object object8 : set) {
                iterator2 = ((AggregationPath)object8).getValues();
                object3 = iterator2.subList(0, list2.size());
                RowTitle rowTitle = new RowTitle((List<Value>)object3);
                object5.add(rowTitle);
                object2 = iterator2.subList(list2.size(), iterator2.size());
                treeSet2.add(object2);
                Object object9 = new ColumnTitle((List<Value>)object2, (AggregationColumn)object42, arrayList2.size() > 1);
                treeSet.add(object9);
                metaTable.put(rowTitle, (ColumnTitle)object9, new TableCell(tableAggregator.getAggregationValue((AggregationPath)object8, ((AggregationColumn)object42).getAggregatedColumn().getId(), ((AggregationColumn)object42).getAggregationType())));
            }
        }
        ArrayList arrayList5 = Lists.newArrayList();
        for (ScalarFunctionColumn scalarFunctionColumn : list5) {
            if (scalarFunctionColumn.getAllAggregationColumns().size() == 0) continue;
            for (Iterator iterator2 : treeSet2) {
                arrayList5.add(new ScalarFunctionColumnTitle((List<Value>)((Object)iterator2), scalarFunctionColumn));
            }
        }
        object42 = QueryEngine.createDataTable((List<String>)list2, treeSet, (DataTable)object, arrayList5);
        List<ColumnDescription> list = ((DataTable)object42).getColumnDescriptions();
        columnIndices.clear();
        int n = 0;
        if (queryGroup != null) {
            iterator2 = Lists.newArrayList();
            treeMap.put((List<Value>)((Object)iterator2), new GenericColumnLookup());
            for (AbstractColumn abstractColumn : queryGroup.getColumns()) {
                columnIndices.put(abstractColumn, n);
                if (!(abstractColumn instanceof ScalarFunctionColumn)) {
                    ((GenericColumnLookup)treeMap.get(iterator2)).put(abstractColumn, n);
                    for (Object object9 : treeSet2) {
                        if (!treeMap.containsKey(object9)) {
                            treeMap.put((List<Value>)object9, new GenericColumnLookup());
                        }
                        ((GenericColumnLookup)treeMap.get(object9)).put(abstractColumn, n);
                    }
                }
                ++n;
            }
        }
        iterator2 = treeSet.iterator();
        while (iterator2.hasNext()) {
            object3 = (ColumnTitle)iterator2.next();
            columnIndices.put(((ColumnTitle)object3).aggregation, n);
            List<Value> list6 = ((ColumnTitle)object3).getValues();
            if (!treeMap.containsKey(list6)) {
                treeMap.put(list6, new GenericColumnLookup());
            }
            ((GenericColumnLookup)treeMap.get(list6)).put(((ColumnTitle)object3).aggregation, n);
            ++n;
        }
        iterator2 = object5.iterator();
        while (iterator2.hasNext()) {
            Object object10;
            object3 = (RowTitle)iterator2.next();
            TableRow tableRow = new TableRow();
            for (Value value : ((RowTitle)object3).values) {
                tableRow.addCell(new TableCell(value));
            }
            object2 = metaTable.getRow((RowTitle)object3);
            int n2 = 0;
            Iterator iterator3 = treeSet.iterator();
            while (iterator3.hasNext()) {
                object10 = (ColumnTitle)iterator3.next();
                TableCell tableCell = (TableCell)object2.get(object10);
                tableRow.addCell(tableCell != null ? tableCell : new TableCell(Value.getNullValueFromValueType(list.get(n2 + ((RowTitle)object3).values.size()).getType())));
                ++n2;
            }
            iterator3 = arrayList5.iterator();
            while (iterator3.hasNext()) {
                object10 = (ScalarFunctionColumnTitle)iterator3.next();
                tableRow.addCell(new TableCell(((ScalarFunctionColumnTitle)object10).scalarFunctionColumn.getValue(treeMap.get(((ScalarFunctionColumnTitle)object10).getValues()), tableRow)));
            }
            ((DataTable)object42).addRow(tableRow);
        }
        iterator2 = arrayList5.iterator();
        while (iterator2.hasNext()) {
            object3 = (ScalarFunctionColumnTitle)iterator2.next();
            columnIndices.put(((ScalarFunctionColumnTitle)object3).scalarFunctionColumn, n);
            List<Value> list7 = ((ScalarFunctionColumnTitle)object3).getValues();
            if (!treeMap.containsKey(list7)) {
                treeMap.put(list7, new GenericColumnLookup());
            }
            ((GenericColumnLookup)treeMap.get(list7)).put(((ScalarFunctionColumnTitle)object3).scalarFunctionColumn, n);
            ++n;
        }
        return object42;
    }

    private static DataTable performLabels(DataTable dataTable, Query query, ColumnIndices columnIndices) {
        if (!query.hasLabels()) {
            return dataTable;
        }
        QueryLabels queryLabels = query.getLabels();
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        for (AbstractColumn abstractColumn : queryLabels.getColumns()) {
            String string = queryLabels.getLabel(abstractColumn);
            List<Integer> list2 = columnIndices.getColumnIndices(abstractColumn);
            if (list2.size() == 1) {
                list.get(list2.get(0)).setLabel(string);
                continue;
            }
            String string2 = abstractColumn.getId();
            for (int n : list2) {
                ColumnDescription columnDescription = list.get(n);
                String string3 = columnDescription.getId();
                String string4 = string3.substring(0, string3.length() - string2.length()) + string;
                list.get(n).setLabel(string4);
            }
        }
        return dataTable;
    }

    private static DataTable performFormatting(DataTable dataTable, Query query, ColumnIndices columnIndices, ULocale uLocale) {
        Object object;
        Object object2;
        Object object3;
        if (!query.hasUserFormatOptions()) {
            return dataTable;
        }
        QueryFormat queryFormat = query.getUserFormatOptions();
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        HashMap hashMap = Maps.newHashMap();
        for (AbstractColumn object4 : queryFormat.getColumns()) {
            object3 = queryFormat.getPattern(object4);
            List<Integer> list2 = columnIndices.getColumnIndices(object4);
            boolean tableCell = true;
            object2 = list2.iterator();
            while (object2.hasNext()) {
                int n = object2.next();
                object = list.get(n);
                ValueFormatter valueFormatter = ValueFormatter.createFromPattern(((ColumnDescription)object).getType(), (String)object3, uLocale);
                if (valueFormatter == null) {
                    tableCell = false;
                    continue;
                }
                hashMap.put(n, valueFormatter);
                dataTable.getColumnDescription(n).setPattern((String)object3);
            }
            if (tableCell) continue;
            object2 = new Warning(ReasonType.ILLEGAL_FORMATTING_PATTERNS, "Illegal formatting pattern: " + (String)object3 + " requested on column: " + object4.getId());
            dataTable.addWarning((Warning)object2);
        }
        for (TableRow tableRow : dataTable.getRows()) {
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                int n = (Integer)object3.next();
                TableCell tableCell = tableRow.getCell(n);
                object2 = tableCell.getValue();
                ValueFormatter valueFormatter = (ValueFormatter)hashMap.get(n);
                object = valueFormatter.format((Value)object2);
                tableCell.setFormattedValue((String)object);
            }
        }
        return dataTable;
    }
}

