/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.util.List;

public class CurrentDateTime
implements ScalarFunction {
    private static final String FUNCTION_NAME = "now";
    private static final CurrentDateTime INSTANCE = new CurrentDateTime();

    private CurrentDateTime() {
    }

    public static CurrentDateTime getInstance() {
        return INSTANCE;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public Value evaluate(List<Value> list) {
        return new DateTimeValue(new GregorianCalendar(TimeZone.getTimeZone((String)"GMT")));
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.DATETIME;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 0) {
            throw new InvalidQueryException("The now function should not get any parameters");
        }
    }

    @Override
    public String toQueryString(List<String> list) {
        return "now()";
    }
}

