/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.query.scalarfunction;

import com.google.common.collect.Maps;
import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.DateTimeValue;
import com.google.visualization.datasource.datatable.value.DateValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TimeOfDayValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.ibm.icu.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class TimeComponentExtractor
implements ScalarFunction {
    private static Map<TimeComponent, TimeComponentExtractor> timeComponentsPool = Maps.newHashMap();
    private TimeComponent timeComponent;

    public static TimeComponentExtractor getInstance(TimeComponent timeComponent) {
        return timeComponentsPool.get((Object)timeComponent);
    }

    private TimeComponentExtractor(TimeComponent timeComponent) {
        this.timeComponent = timeComponent;
    }

    @Override
    public String getFunctionName() {
        return this.timeComponent.getName();
    }

    @Override
    public Value evaluate(List<Value> list) {
        int n;
        Value value = list.get(0);
        ValueType valueType = value.getType();
        if (value.isNull()) {
            return NumberValue.getNullValue();
        }
        switch (this.timeComponent) {
            case YEAR: {
                if (valueType == ValueType.DATE) {
                    n = ((DateValue)value).getYear();
                    break;
                }
                n = ((DateTimeValue)value).getYear();
                break;
            }
            case MONTH: {
                if (valueType == ValueType.DATE) {
                    n = ((DateValue)value).getMonth();
                    break;
                }
                n = ((DateTimeValue)value).getMonth();
                break;
            }
            case DAY: {
                if (valueType == ValueType.DATE) {
                    n = ((DateValue)value).getDayOfMonth();
                    break;
                }
                n = ((DateTimeValue)value).getDayOfMonth();
                break;
            }
            case HOUR: {
                if (valueType == ValueType.TIMEOFDAY) {
                    n = ((TimeOfDayValue)value).getHours();
                    break;
                }
                n = ((DateTimeValue)value).getHourOfDay();
                break;
            }
            case MINUTE: {
                if (valueType == ValueType.TIMEOFDAY) {
                    n = ((TimeOfDayValue)value).getMinutes();
                    break;
                }
                n = ((DateTimeValue)value).getMinute();
                break;
            }
            case SECOND: {
                if (valueType == ValueType.TIMEOFDAY) {
                    n = ((TimeOfDayValue)value).getSeconds();
                    break;
                }
                n = ((DateTimeValue)value).getSecond();
                break;
            }
            case MILLISECOND: {
                if (valueType == ValueType.TIMEOFDAY) {
                    n = ((TimeOfDayValue)value).getMilliseconds();
                    break;
                }
                n = ((DateTimeValue)value).getMillisecond();
                break;
            }
            case QUARTER: {
                n = valueType == ValueType.DATE ? ((DateValue)value).getMonth() : ((DateTimeValue)value).getMonth();
                n = n / 3 + 1;
                break;
            }
            case DAY_OF_WEEK: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)(valueType == ValueType.DATE ? ((DateValue)value).getObjectToFormat() : ((DateTimeValue)value).getObjectToFormat());
                n = gregorianCalendar.get(7);
                break;
            }
            default: {
                throw new RuntimeException("An invalid time component.");
            }
        }
        return new NumberValue(n);
    }

    @Override
    public ValueType getReturnType(List<ValueType> list) {
        return ValueType.NUMBER;
    }

    @Override
    public void validateParameters(List<ValueType> list) throws InvalidQueryException {
        if (list.size() != 1) {
            throw new InvalidQueryException("Number of parameters for " + this.timeComponent.getName() + "function is wrong: " + list.size());
        }
        switch (this.timeComponent) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case QUARTER: 
            case DAY_OF_WEEK: {
                if (list.get(0) == ValueType.DATE || list.get(0) == ValueType.DATETIME) break;
                throw new InvalidQueryException("Can't perform the function " + this.timeComponent.getName() + " on a column that is not a Date or" + " a DateTime column");
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MILLISECOND: {
                if (list.get(0) == ValueType.TIMEOFDAY || list.get(0) == ValueType.DATETIME) break;
                throw new InvalidQueryException("Can't perform the function " + this.timeComponent.getName() + " on a column that is not a " + "TimeOfDay or a DateTime column");
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof TimeComponentExtractor) {
            TimeComponentExtractor timeComponentExtractor = (TimeComponentExtractor)object;
            return this.timeComponent.equals((Object)timeComponentExtractor.timeComponent);
        }
        return false;
    }

    public int hashCode() {
        return this.timeComponent == null ? 0 : this.timeComponent.hashCode();
    }

    @Override
    public String toQueryString(List<String> list) {
        return this.getFunctionName() + "(" + list.get(0) + ")";
    }

    static {
        for (TimeComponent timeComponent : TimeComponent.values()) {
            timeComponentsPool.put(timeComponent, new TimeComponentExtractor(timeComponent));
        }
    }

    public static enum TimeComponent {
        YEAR("year"),
        MONTH("month"),
        WEEK("week"),
        DAY("day"),
        HOUR("hour"),
        MINUTE("minute"),
        SECOND("second"),
        MILLISECOND("millisecond"),
        QUARTER("quarter"),
        DAY_OF_WEEK("dayofweek");

        private String name;

        private TimeComponent(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

