/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.render;

import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.ResponseStatus;
import com.google.visualization.datasource.base.StatusType;
import com.google.visualization.datasource.base.Warning;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableCell;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.render.EscapeUtil;
import com.ibm.icu.util.ULocale;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HtmlRenderer {
    private static final Log log = LogFactory.getLog((String)"HtmlRenderer");
    private static final Pattern DETAILED_MESSAGE_A_TAG_REGEXP = Pattern.compile("([^<]*<a(( )*target=\"_blank\")*(( )*target='_blank')*(( )*href=\"[^\"]*\")*(( )*href='[^']*')*>[^<]*</a>)+[^<]*");
    private static final Pattern BAD_JAVASCRIPT_REGEXP = Pattern.compile("javascript(( )*):");

    private HtmlRenderer() {
    }

    public static CharSequence renderDataTable(DataTable dataTable, ULocale uLocale) {
        Object object;
        Document document = HtmlRenderer.createDocument();
        Element element = HtmlRenderer.appendHeadAndBody(document);
        Element element2 = document.createElement("table");
        element.appendChild(element2);
        element2.setAttribute("border", "1");
        element2.setAttribute("cellpadding", "2");
        element2.setAttribute("cellspacing", "0");
        List<ColumnDescription> list = dataTable.getColumnDescriptions();
        Element element3 = document.createElement("tr");
        element3.setAttribute("style", "font-weight: bold; background-color: #aaa;");
        for (ColumnDescription columnDescription : list) {
            Iterator<Warning> iterator = document.createElement("td");
            iterator.setTextContent(columnDescription.getLabel());
            element3.appendChild((Node)((Object)iterator));
        }
        element2.appendChild(element3);
        Map<ValueType, ValueFormatter> map = ValueFormatter.createDefaultFormatters(uLocale);
        int n = 0;
        for (TableRow object2 : dataTable.getRows()) {
            element3 = document.createElement("tr");
            object = ++n % 2 != 0 ? "#f0f0f0" : "#ffffff";
            element3.setAttribute("style", "background-color: " + (String)object);
            List<TableCell> list2 = object2.getCells();
            for (int i = 0; i < list2.size(); ++i) {
                ValueType valueType = list.get(i).getType();
                TableCell tableCell = list2.get(i);
                String string = tableCell.getFormattedValue();
                if (string == null) {
                    string = ((ValueFormatter)map.get((Object)tableCell.getType())).format(tableCell.getValue());
                }
                Element element4 = document.createElement("td");
                if (tableCell.isNull()) {
                    element4.setTextContent("\u00a0");
                } else {
                    switch (valueType) {
                        case NUMBER: {
                            element4.setAttribute("align", "right");
                            element4.setTextContent(string);
                            break;
                        }
                        case BOOLEAN: {
                            BooleanValue booleanValue = (BooleanValue)tableCell.getValue();
                            element4.setAttribute("align", "center");
                            if (booleanValue.getValue()) {
                                element4.setTextContent("\u2714");
                                break;
                            }
                            element4.setTextContent("\u2717");
                            break;
                        }
                        default: {
                            if (StringUtils.isEmpty((String)string)) {
                                element4.setTextContent("\u00a0");
                                break;
                            }
                            element4.setTextContent(string);
                        }
                    }
                }
                element3.appendChild(element4);
            }
            element2.appendChild(element3);
        }
        element.appendChild(element2);
        for (Warning warning : dataTable.getWarnings()) {
            element.appendChild(document.createElement("br"));
            element.appendChild(document.createElement("br"));
            object = document.createElement("div");
            object.setTextContent(warning.getReasonType().getMessageForReasonType() + ". " + warning.getMessage());
            element.appendChild((Node)object);
        }
        return HtmlRenderer.transformDocumentToHtmlString(document);
    }

    private static String transformDocumentToHtmlString(Document document) {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            log.error((Object)"Couldn't create a transformer", (Throwable)transformerConfigurationException);
            throw new RuntimeException("Couldn't create a transformer. This should never happen.", transformerConfigurationException);
        }
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD HTML 4.01//EN");
        transformer.setOutputProperty("method", "html");
        transformer.setOutputProperty("version", "4.01");
        DOMSource dOMSource = new DOMSource(document);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            log.error((Object)"Couldn't transform", (Throwable)transformerException);
            throw new RuntimeException("Couldn't transform. This should never happen.", transformerException);
        }
        return ((Object)stringWriter).toString();
    }

    static String sanitizeDetailedMessage(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return "";
        }
        if (DETAILED_MESSAGE_A_TAG_REGEXP.matcher(string).matches() && !BAD_JAVASCRIPT_REGEXP.matcher(string).find()) {
            return string;
        }
        return EscapeUtil.htmlEscape(string);
    }

    public static CharSequence renderHtmlError(ResponseStatus responseStatus) {
        String string;
        StatusType statusType = responseStatus.getStatusType();
        ReasonType reasonType = responseStatus.getReasonType();
        String string2 = responseStatus.getDescription();
        Document document = HtmlRenderer.createDocument();
        Element element = HtmlRenderer.appendHeadAndBody(document);
        Element element2 = document.createElement("h3");
        element2.setTextContent("Oops, an error occured.");
        element.appendChild(element2);
        if (statusType != null) {
            string = "Status: " + statusType.lowerCaseString();
            HtmlRenderer.appendSimpleText(document, element, string);
        }
        if (reasonType != null) {
            string = "Reason: " + reasonType.getMessageForReasonType(null);
            HtmlRenderer.appendSimpleText(document, element, string);
        }
        if (string2 != null) {
            string = "Description: " + HtmlRenderer.sanitizeDetailedMessage(string2);
            HtmlRenderer.appendSimpleText(document, element, string);
        }
        return HtmlRenderer.transformDocumentToHtmlString(document);
    }

    private static Document createDocument() {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)"Couldn't create a document builder", (Throwable)parserConfigurationException);
            throw new RuntimeException("Couldn't create a document builder. This should never happen.", parserConfigurationException);
        }
        Document document = documentBuilder.newDocument();
        return document;
    }

    private static Element appendHeadAndBody(Document document) {
        Element element = document.createElement("html");
        document.appendChild(element);
        Element element2 = document.createElement("head");
        element.appendChild(element2);
        Element element3 = document.createElement("title");
        element3.setTextContent("Google Visualization");
        element2.appendChild(element3);
        Element element4 = document.createElement("body");
        element.appendChild(element4);
        return element4;
    }

    private static void appendSimpleText(Document document, Element element, String string) {
        Element element2 = document.createElement("div");
        element2.setTextContent(string);
        element.appendChild(element2);
    }
}

