/*
 * Decompiled with CFR 0.152.
 */
package com.google.visualization.datasource.util;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Lists;
import com.google.visualization.datasource.base.DataSourceException;
import com.google.visualization.datasource.base.ReasonType;
import com.google.visualization.datasource.base.TypeMismatchException;
import com.google.visualization.datasource.datatable.ColumnDescription;
import com.google.visualization.datasource.datatable.DataTable;
import com.google.visualization.datasource.datatable.TableRow;
import com.google.visualization.datasource.datatable.ValueFormatter;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.datatable.value.ValueType;
import com.google.visualization.datasource.util.CsvDataSourceException;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CsvDataSourceHelper {
    private CsvDataSourceHelper() {
    }

    public static DataTable read(Reader reader, List<ColumnDescription> list, Boolean bl) throws IOException, CsvDataSourceException {
        return CsvDataSourceHelper.read(reader, list, bl, null);
    }

    public static DataTable read(Reader reader, List<ColumnDescription> object, Boolean bl, ULocale uLocale) throws IOException, CsvDataSourceException {
        String[] stringArray;
        DataTable dataTable = new DataTable();
        if (reader == null) {
            return dataTable;
        }
        CSVReader cSVReader = new CSVReader(reader);
        Map<ValueType, ValueFormatter> map = ValueFormatter.createDefaultFormatters(uLocale);
        boolean bl2 = true;
        while ((stringArray = cSVReader.readNext()) != null) {
            Object object2;
            String string;
            Object object3;
            Object object4;
            Object object5;
            int n;
            Object object6;
            if (stringArray.length == 1 && stringArray[0].equals("")) continue;
            if (object != null && stringArray.length != object.size()) {
                throw new CsvDataSourceException(ReasonType.INTERNAL_ERROR, "Wrong number of columns in the data.");
            }
            if (bl2) {
                if (object == null) {
                    object = Lists.newArrayList();
                }
                object6 = new ArrayList();
                for (n = 0; n < stringArray.length; ++n) {
                    object5 = object.isEmpty() || object.get(n) == null ? null : (ColumnDescription)object.get(n);
                    object4 = object5 == null || ((ColumnDescription)object5).getId() == null ? "Col" + n : ((ColumnDescription)object5).getId();
                    object3 = object5 == null || ((ColumnDescription)object5).getType() == null ? ValueType.TEXT : ((ColumnDescription)object5).getType();
                    string = object5 == null || ((ColumnDescription)object5).getLabel() == null ? "Column" + n : ((ColumnDescription)object5).getLabel();
                    object2 = object5 == null || ((ColumnDescription)object5).getPattern() == null ? "" : ((ColumnDescription)object5).getPattern();
                    object5 = new ColumnDescription((String)object4, (ValueType)((Object)object3), string);
                    ((ColumnDescription)object5).setPattern((String)object2);
                    object6.add(object5);
                }
                if (bl.booleanValue()) {
                    for (n = 0; n < stringArray.length; ++n) {
                        object5 = stringArray[n];
                        if (object5 == null) {
                            ((ColumnDescription)object6.get(n)).setLabel("");
                            continue;
                        }
                        ((ColumnDescription)object6.get(n)).setLabel(stringArray[n].trim());
                    }
                }
                object = object6;
                dataTable = new DataTable();
                dataTable.addColumns((Collection<ColumnDescription>)object);
            }
            if (!bl2 || !bl.booleanValue()) {
                object6 = new TableRow();
                for (n = 0; n < stringArray.length; ++n) {
                    object5 = (ColumnDescription)object.get(n);
                    object4 = ((ColumnDescription)object5).getType();
                    object3 = stringArray[n];
                    if (object3 != null) {
                        object3 = object3.trim();
                    }
                    object2 = (string = ((ColumnDescription)object5).getPattern()) == null || string.equals("") ? map.get(object4) : ValueFormatter.createFromPattern(object4, string, uLocale);
                    Value value = ((ValueFormatter)object2).parse((String)object3);
                    ((TableRow)object6).addCell(value);
                }
                try {
                    dataTable.addRow((TableRow)object6);
                }
                catch (TypeMismatchException typeMismatchException) {
                    // empty catch block
                }
            }
            bl2 = false;
        }
        return dataTable;
    }

    public static Reader getCsvUrlReader(String string) throws DataSourceException {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openStream(), "UTF-8"));
        }
        catch (MalformedURLException malformedURLException) {
            throw new DataSourceException(ReasonType.INVALID_REQUEST, "url is malformed: " + string);
        }
        catch (IOException iOException) {
            throw new DataSourceException(ReasonType.INVALID_REQUEST, "Couldn't read csv file from url: " + string);
        }
        return bufferedReader;
    }

    public static Reader getCsvFileReader(String string) throws DataSourceException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataSourceException(ReasonType.INVALID_REQUEST, "Couldn't read csv file from: " + string);
        }
        return bufferedReader;
    }
}

