/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AbstractGraphChart;
import com.googlecode.charts4j.AxisLabels;
import com.googlecode.charts4j.AxisLabelsImpl;
import com.googlecode.charts4j.AxisStyle;
import com.googlecode.charts4j.GridChart;
import com.googlecode.charts4j.LineStyle;
import com.googlecode.charts4j.Marker;
import com.googlecode.charts4j.PrivateRadarChart;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Maps;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.parameters.AxisTypes;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAxisChart
extends AbstractGraphChart
implements GridChart {
    private final List<AxisLabelsImpl> xAxisLabels = Lists.newLinkedList();
    private final List<AxisLabelsImpl> yAxisLabels = Lists.newLinkedList();
    private final List<AxisLabelsImpl> topAxisLabels = Lists.newLinkedList();
    private final List<AxisLabelsImpl> rightAxisLabels = Lists.newLinkedList();
    private final List<FreeMarker> freeMarkers = Lists.newLinkedList();
    private LineStyle gridLineStyle;
    private double xAxisStepSize;
    private double yAxisStepSize;

    AbstractAxisChart() {
    }

    public final void addXAxisLabels(AxisLabels axisLabels) {
        Preconditions.checkNotNull(axisLabels, "axisLabel cannnot be null");
        this.xAxisLabels.add((AxisLabelsImpl)axisLabels.klone());
    }

    public final void addYAxisLabels(AxisLabels axisLabels) {
        Preconditions.checkNotNull(axisLabels, "axisLabel cannnot be null");
        this.yAxisLabels.add((AxisLabelsImpl)axisLabels.klone());
    }

    public final void addTopAxisLabels(AxisLabels axisLabels) {
        Preconditions.checkNotNull(axisLabels, "axisLabel cannnot be null");
        this.topAxisLabels.add((AxisLabelsImpl)axisLabels.klone());
    }

    public final void addRightAxisLabels(AxisLabels axisLabels) {
        Preconditions.checkNotNull(axisLabels, "axisLabels cannnot be null");
        this.rightAxisLabels.add((AxisLabelsImpl)axisLabels.klone());
    }

    public final void addMarker(Marker marker, double xPos, double yPos) {
        Preconditions.checkNotNull(marker, "marker cannnot be null");
        Preconditions.checkArgument(xPos >= 0.0 && xPos <= 100.0, "xPos must be >= 0 and <= 100: %s", xPos);
        Preconditions.checkArgument(yPos >= 0.0 && yPos <= 100.0, "yPos must be >= 0 and <= 100: %s", yPos);
        this.freeMarkers.add(new FreeMarker(marker, xPos, yPos));
    }

    @Override
    public final void setGrid(double xAxisStepSize, double yAxisStepSize, int lengthOfLineSegment, int lengthOfBlankSegment) {
        Preconditions.checkArgument(xAxisStepSize > 0.0, "xAxisStepSize must be positive: %s", xAxisStepSize);
        Preconditions.checkArgument(yAxisStepSize > 0.0, "yAxisStepSize must be positive: %s", yAxisStepSize);
        Preconditions.checkArgument(lengthOfLineSegment >= 0, "lengthOfLineSegment must be 0 or positive: %s", lengthOfLineSegment);
        Preconditions.checkArgument(lengthOfBlankSegment >= 0, "lengthOfBlankSegment must be 0 or positive: %s", lengthOfBlankSegment);
        this.xAxisStepSize = xAxisStepSize;
        this.yAxisStepSize = yAxisStepSize;
        this.gridLineStyle = LineStyle.newLineStyle(1, lengthOfLineSegment, lengthOfBlankSegment);
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        if (this.gridLineStyle != null) {
            this.parameterManager.setGridLineParameter(this.xAxisStepSize, this.yAxisStepSize, this.gridLineStyle.getLengthOfLineSegment(), this.gridLineStyle.getLengthOfBlankSegment());
        }
        for (FreeMarker marker : this.freeMarkers) {
            this.parameterManager.addFreeMarker(marker.marker, marker.xPos, marker.yPos);
        }
        if (!(this.xAxisLabels.isEmpty() && this.yAxisLabels.isEmpty() && this.topAxisLabels.isEmpty() && this.rightAxisLabels.isEmpty())) {
            EnumMap<AxisTypes, List<AxisLabelsImpl>> axisTypeMap = Maps.newEnumMap(AxisTypes.class);
            axisTypeMap.put(AxisTypes.RIGHT_Y_AXIS, this.rightAxisLabels);
            axisTypeMap.put(AxisTypes.TOP_X_AXIS, this.topAxisLabels);
            axisTypeMap.put(AxisTypes.LEFT_Y_AXIS, this.yAxisLabels);
            axisTypeMap.put(AxisTypes.BOTTOM_X_AXIS, this.xAxisLabels);
            int axisIndex = 0;
            for (Map.Entry entry : axisTypeMap.entrySet()) {
                for (AxisLabelsImpl axisLabel : (List)entry.getValue()) {
                    this.parameterManager.addAxisTypes((AxisTypes)((Object)entry.getKey()));
                    if (axisLabel.getPositions().isEmpty() && !axisLabel.getLabels().isEmpty()) {
                        this.parameterManager.addAxisLabels(axisIndex, axisLabel.getLabels());
                    } else if (!axisLabel.getPositions().isEmpty() && !axisLabel.getLabels().isEmpty()) {
                        this.parameterManager.addAxisLabels(axisIndex, axisLabel.getLabels());
                        this.parameterManager.addAxisLabelPosition(axisIndex, axisLabel.getPositions());
                        this.parameterManager.addAxisRange(axisIndex, 0.0, 100.0, Double.NaN);
                    } else if (!axisLabel.getPositions().isEmpty() && axisLabel.getLabels().isEmpty()) {
                        List<Double> sortedpositions = AbstractAxisChart.convertToSortedDoubleList(axisLabel.getPositions());
                        this.parameterManager.addAxisLabelPosition(axisIndex, axisLabel.getPositions());
                        this.parameterManager.addAxisRange(axisIndex, sortedpositions.get(0), sortedpositions.get(sortedpositions.size() - 1), Double.NaN);
                    } else if (axisLabel.getRange() != null) {
                        this.parameterManager.addAxisRange(axisIndex, axisLabel.getRange().getMin(), axisLabel.getRange().getMax(), axisLabel.getRange().getInterval());
                    }
                    if (axisLabel.getAxisStyle() != null) {
                        this.parameterManager.addAxisStyle(axisIndex, this.getClass().equals(PrivateRadarChart.class) ? axisLabel.getAxisStyle() : AxisStyle.correctAxisStyle(axisLabel.getAxisStyle()));
                        if (axisLabel.getAxisStyle().getTickMarkLength() != null) {
                            this.parameterManager.addTickMarkLength(axisIndex, axisLabel.getAxisStyle().getTickMarkLength());
                        }
                    }
                    ++axisIndex;
                }
            }
        }
    }

    private static List<Double> convertToSortedDoubleList(ImmutableList<? extends Number> positions) {
        List<Double> doubleList = Lists.newLinkedList();
        for (Number number : positions) {
            doubleList.add(number.doubleValue());
        }
        Collections.sort(doubleList);
        return doubleList;
    }

    private static class FreeMarker {
        private final Marker marker;
        private final double xPos;
        private final double yPos;

        private FreeMarker(Marker marker, double xPos, double yPos) {
            this.marker = marker;
            this.xPos = xPos;
            this.yPos = yPos;
        }
    }
}

