/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.DataEncoding;
import com.googlecode.charts4j.Fill;
import com.googlecode.charts4j.GChart;
import com.googlecode.charts4j.LinearGradientFill;
import com.googlecode.charts4j.LinearStripesFill;
import com.googlecode.charts4j.SolidFill;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.parameters.FillType;
import com.googlecode.charts4j.parameters.ParameterManager;
import com.googlecode.charts4j.parameters.SolidFillType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGChart
implements GChart {
    protected final ParameterManager parameterManager = new ParameterManager();
    private static final int MAX_PIXELS = 300000;
    private static final int MAX_WIDTH = 1000;
    private static final int MAX_HEIGHT = 1000;
    private static final int MIN_WIDTH = 0;
    private static final int MIN_HEIGHT = 0;
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 125;
    private static final int MAX_OPACITY = 100;
    private static final int MIN_OPACITY = 0;
    private static final int DEFAULT_OPACITY = 100;
    private int width = 200;
    private int height = 125;
    private Fill backgroundFill;
    private int opacity = 100;
    private DataEncoding dataEncoding = DataEncoding.EXTENDED;
    private Margins margins;
    private String chartURLEndpoint = "http://chart.apis.google.com/chart";

    AbstractGChart() {
    }

    @Override
    public void setSize(int width, int height) {
        Preconditions.checkArgument(width * height <= 300000, "The largest possible area for all charts except maps is 300,000 pixels.");
        Preconditions.checkArgument(width > 0 && width <= 1000, "width must be > 0 and <= 1000: %s", width);
        Preconditions.checkArgument(height > 0 && height <= 1000, "height must be > 0 and <= 1000: %s", height);
        this.width = width;
        this.height = height;
    }

    @Override
    public final Map<String, String> getParameters() {
        this.parameterManager.init(this.chartURLEndpoint);
        this.prepareData();
        return this.parameterManager.getParameterMap();
    }

    @Override
    public final String toURLString() {
        this.parameterManager.init(this.chartURLEndpoint);
        this.prepareData();
        return this.parameterManager.toString();
    }

    @Override
    public final String toURLForHTML() {
        return this.toURLString().replaceAll("&", "&amp;");
    }

    @Override
    public void setBackgroundFill(Fill fill) {
        Preconditions.checkNotNull(fill, "The background fill cannot be null");
        this.backgroundFill = fill;
    }

    @Override
    public void setTransparency(int opacity) {
        Preconditions.checkArgument(opacity >= 0 && opacity <= 100, "opacity must be between 0 and 100: %s", opacity);
        this.opacity = opacity;
    }

    @Override
    public final void setDataEncoding(DataEncoding dataEncoding) {
        Preconditions.checkNotNull(dataEncoding, "The data encoding cannot be null");
        this.dataEncoding = dataEncoding;
    }

    @Override
    public void setMargins(int leftMargin, int rightMargin, int topMargin, int bottomMargin) {
        this.margins = new Margins(leftMargin, rightMargin, topMargin, bottomMargin);
    }

    @Override
    public void setURLEndpoint(String urlEndpoint) {
        Preconditions.checkNotNull(urlEndpoint, "The chart URL endpoint cannot be null");
        this.chartURLEndpoint = urlEndpoint;
    }

    protected void prepareData() {
        if (this.backgroundFill instanceof SolidFill) {
            SolidFill solid = (SolidFill)this.backgroundFill;
            this.parameterManager.addSolidFill(SolidFillType.BACKGROUND, solid.getColor());
        } else if (this.backgroundFill instanceof LinearGradientFill) {
            LinearGradientFill lg = (LinearGradientFill)this.backgroundFill;
            this.parameterManager.addLinearGradientFill(FillType.BACKGROUND, lg.getAngle(), lg.getColorsAndOffsets());
        } else if (this.backgroundFill instanceof LinearStripesFill) {
            LinearStripesFill ls = (LinearStripesFill)this.backgroundFill;
            this.parameterManager.addLinearStripeFill(FillType.BACKGROUND, ls.getAngle(), ls.getColorsAndWidths());
        }
        if (this.opacity < 100) {
            this.parameterManager.addSolidFill(SolidFillType.TRANSPARENCY, Color.newColor(Color.WHITE, this.opacity));
        }
        this.parameterManager.setChartSizeParameter(this.width, this.height);
        this.parameterManager.setDataEncoding(this.dataEncoding);
        if (this.margins != null) {
            this.parameterManager.setMargins(this.margins.leftMargin, this.margins.rightMargin, this.margins.topMargin, this.margins.bottomMargin);
        }
    }

    private static final class Margins {
        private final int leftMargin;
        private final int rightMargin;
        private final int topMargin;
        private final int bottomMargin;

        private Margins(int bottomMargin, int leftMargin, int rightMargin, int topMargin) {
            this.bottomMargin = bottomMargin;
            this.leftMargin = leftMargin;
            this.rightMargin = rightMargin;
            this.topMargin = topMargin;
        }
    }
}

