/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.collect.PrimitiveArrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataUtil {
    private DataUtil() {
        throw new AssertionError();
    }

    public static Data scaleWithinRange(double min, double max, double[] data) {
        Preconditions.checkArgument(max - min > 0.0, "min >= max!");
        return Data.newData(DataUtil.privateScale(data, min, max));
    }

    public static Data scaleWithinRange(double min, double max, List<? extends Number> data) {
        return DataUtil.scaleWithinRange(min, max, DataUtil.toDoubleArray(Lists.copyOf(data)));
    }

    public static Data scale(double ... data) {
        Preconditions.checkNotNull(data, "data is null or contents of data is null.");
        double min = Collections.min(PrimitiveArrays.asList(data));
        double max = Collections.max(PrimitiveArrays.asList(data));
        Preconditions.checkArgument(min < max, "Cannot scale this data. It is ill conditioned.");
        return Data.newData(DataUtil.privateScale(data, min, max));
    }

    public static Data scale(List<? extends Number> data) {
        Preconditions.checkContentsNotNull(data, "data is null or contents of data is null.");
        return DataUtil.scale(DataUtil.toDoubleArray(Lists.copyOf(data)));
    }

    public static List<Data> scale(double[][] data) {
        Preconditions.checkNotNull(data, "data cannot be null");
        List<Double> allData = Lists.newLinkedList();
        double[][] arr$ = data;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] d;
            for (double doub : d = arr$[i$]) {
                allData.add(doub);
            }
        }
        double min = (Double)Collections.min(allData);
        double max = (Double)Collections.max(allData);
        List<Data> list = Lists.newLinkedList();
        for (double[] d : data) {
            list.add(DataUtil.scaleWithinRange(min, max, d));
        }
        return list;
    }

    public static List<Data> scaleDataList(List<? extends List<? extends Number>> data) {
        Preconditions.checkContentsNotNull(data, "data is null or contents of data is null.");
        double[][] d = new double[data.size()][];
        int j = 0;
        for (List<? extends Number> list : data) {
            Preconditions.checkContentsNotNull(list, "data is null or contents of data is null.");
            double[] plotData = new double[list.size()];
            int i = 0;
            for (Number number : list) {
                plotData[i++] = number.doubleValue();
            }
            d[j++] = plotData;
        }
        return DataUtil.scale(d);
    }

    static double[] toDoubleArray(ImmutableList<? extends Number> data) {
        double[] d = new double[data.size()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = data.get(i).doubleValue();
        }
        return d;
    }

    private static double[] privateScale(double[] doubleArray, double min, double max) {
        Preconditions.checkNotNull(doubleArray, "doubleArray cannot be null");
        Preconditions.checkArgument(max - min > 0.0, "min > max!");
        double[] scaledData = new double[doubleArray.length];
        for (int j = 0; j < doubleArray.length; ++j) {
            scaledData[j] = (doubleArray[j] - min) / (max - min) * 100.0;
        }
        return scaledData;
    }
}

