/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.BarChart;
import com.googlecode.charts4j.BarChartPlot;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.GeographicalArea;
import com.googlecode.charts4j.GoogleOMeter;
import com.googlecode.charts4j.Line;
import com.googlecode.charts4j.LineChart;
import com.googlecode.charts4j.MapChart;
import com.googlecode.charts4j.PieChart;
import com.googlecode.charts4j.Plot;
import com.googlecode.charts4j.Plots;
import com.googlecode.charts4j.RadarChart;
import com.googlecode.charts4j.RadarPlot;
import com.googlecode.charts4j.ScatterPlot;
import com.googlecode.charts4j.ScatterPlotData;
import com.googlecode.charts4j.Slice;
import com.googlecode.charts4j.VennDiagram;
import com.googlecode.charts4j.XYLine;
import com.googlecode.charts4j.XYLineChart;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GCharts {
    private GCharts() {
        throw new AssertionError();
    }

    public static LineChart newLineChart(Line ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return new LineChart(Plots.copyOf(plots));
    }

    public static LineChart newLineChart(Plot ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return GCharts.newLineChart(Plots.copyOf(plots));
    }

    public static LineChart newLineChart(List<? extends Plot> plots) {
        Preconditions.checkContentsNotNull(plots, "plots cannot be null or contain a null.");
        return new LineChart(Plots.copyOf(plots));
    }

    public static RadarChart newRadarChart(RadarPlot ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return new RadarChart(Plots.copyOf(plots));
    }

    public static RadarChart newRadarChart(Plot ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return GCharts.newRadarChart(Plots.copyOf(plots));
    }

    public static RadarChart newRadarChart(List<? extends Plot> plots) {
        Preconditions.checkContentsNotNull(plots, "plots cannot be null or contain a null.");
        return new RadarChart(Plots.copyOf(plots));
    }

    public static BarChart newBarChart(BarChartPlot ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return new BarChart(Plots.copyOf(plots));
    }

    public static BarChart newBarChart(Plot ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return GCharts.newBarChart(Plots.copyOf(plots));
    }

    public static BarChart newBarChart(List<? extends Plot> plots) {
        Preconditions.checkContentsNotNull(plots, "plots cannot be null or contain a null.");
        return new BarChart(Plots.copyOf(plots));
    }

    public static XYLineChart newXYLineChart(XYLine ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return new XYLineChart(Plots.copyOf(plots));
    }

    public static XYLineChart newXYLineChart(Plot ... plots) {
        Preconditions.checkNotNull(plots, "plots cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(plots), "plots cannot be null or contain a null.");
        return GCharts.newXYLineChart(Plots.copyOf(plots));
    }

    public static XYLineChart newXYLineChart(List<? extends Plot> plots) {
        Preconditions.checkContentsNotNull(plots, "plots cannot be null or contain a null.");
        return new XYLineChart(Plots.copyOf(plots));
    }

    public static ScatterPlot newScatterPlot(ScatterPlotData scatterPlotData) {
        Preconditions.checkNotNull(scatterPlotData);
        return new ScatterPlot(scatterPlotData);
    }

    public static ScatterPlot newScatterPlot(Plot scatterPlotData) {
        Preconditions.checkNotNull(scatterPlotData, "scatterPlotData cannot be null");
        return new ScatterPlot(scatterPlotData);
    }

    public static PieChart newPieChart(Slice ... slices) {
        Preconditions.checkNotNull(slices, "slices cannot be null or contain a null.");
        Preconditions.checkContentsNotNull(Arrays.asList(slices), "slices cannot be null or contain a null.");
        return GCharts.newPieChart(Lists.of(slices));
    }

    public static PieChart newPieChart(List<? extends Slice> slices) {
        Preconditions.checkContentsNotNull(slices, "slices cannot be null or contain a null.");
        return new PieChart(Lists.copyOf(slices));
    }

    public static VennDiagram newVennDiagram(double circle1Size, double circle2Size, double circle3Size, double abIntersect, double caIntersect, double bcIntersect, double abcIntersect) {
        return new VennDiagram(circle1Size, circle2Size, circle3Size, abIntersect, caIntersect, bcIntersect, abcIntersect);
    }

    public static GoogleOMeter newGoogleOMeter(double data) {
        return GCharts.newGoogleOMeter(data, null, null, Lists.of(new Color[0]));
    }

    public static GoogleOMeter newGoogleOMeter(double data, String label) {
        return GCharts.newGoogleOMeter(data, label, null, Lists.of(new Color[0]));
    }

    @Deprecated
    public static GoogleOMeter newGoogleOMeter(double data, String label, Color ... colors) {
        return GCharts.newGoogleOMeter(data, label, null, Lists.of(colors));
    }

    @Deprecated
    public static GoogleOMeter newGoogleOMeter(double data, String label, List<? extends Color> colors) {
        return GCharts.newGoogleOMeter(data, label, null, colors);
    }

    public static GoogleOMeter newGoogleOMeter(double data, String label, String legend, Color ... colors) {
        return GCharts.newGoogleOMeter(data, label, legend, Lists.of(colors));
    }

    public static GoogleOMeter newGoogleOMeter(double data, String label, String legend, List<? extends Color> colors) {
        return new GoogleOMeter(data, label, legend, colors == null ? Lists.of(new Color[0]) : colors);
    }

    public static MapChart newMapChart(GeographicalArea geographicalArea) {
        Preconditions.checkNotNull(geographicalArea, "geographicalArea cannot be null");
        MapChart mapChart = new MapChart(geographicalArea);
        mapChart.setSize(440, 220);
        mapChart.setColorGradient(Color.WHITE, Color.BEIGE, Color.FORESTGREEN);
        return mapChart;
    }
}

