/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.AbstractGraphChart;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import com.googlecode.charts4j.parameters.ChartType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleOMeter
extends AbstractGraphChart {
    private final double data;
    private final ImmutableList<Color> colors;
    private final String label;
    private final String legend;

    GoogleOMeter(double data, String label, String legend, List<? extends Color> colors) {
        Preconditions.checkArgument(data >= 0.0 && data <= 100.0, "must be between 0.0 and 100.0 : %s", data);
        Preconditions.checkContentsNotNull(colors, "colors is null or contains a null");
        Preconditions.checkArgument(colors.size() != 1, "Must provide at least 2 colors or none at all.");
        this.data = data;
        this.label = label;
        this.legend = legend;
        this.colors = Lists.copyOf(colors);
    }

    @Override
    protected void prepareData() {
        super.prepareData();
        this.parameterManager.addData(Data.newData(this.data));
        List<ImmutableList<Color>> colorList = Lists.newArrayList();
        for (Color color : this.colors) {
            colorList.add(Lists.of(color));
        }
        this.parameterManager.addColors(Lists.copyOf(colorList));
        if (this.label != null) {
            this.parameterManager.addPieChartAndGoogleOMeterLegend(this.label);
        }
        if (this.legend != null) {
            this.parameterManager.addLegend(this.legend);
        }
        this.parameterManager.setChartTypeParameter(ChartType.GOOGLE_O_METER);
    }
}

