/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Marker;
import com.googlecode.charts4j.Priority;
import com.googlecode.charts4j.Shape;
import com.googlecode.charts4j.ShapeMarker;
import com.googlecode.charts4j.TextMarker;
import com.googlecode.charts4j.collect.Preconditions;

public final class Markers {
    private Markers() {
        throw new AssertionError();
    }

    public static Marker newTextMarker(String text, Color color, int size) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size > 0, "The size of this marker has to be > 0");
        return new TextMarker(text, color, size, Priority.NORMAL, false);
    }

    public static Marker newFlaggedTextMarker(String text, Color color, int size) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size > 0, "The size of this marker has to be > 0");
        return new TextMarker(text, color, size, Priority.NORMAL, true);
    }

    public static Marker newShapeMarker(Shape shape, Color color, int size) {
        Preconditions.checkNotNull(shape, "shape cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size > 0, "The size of this marker has to be > 0");
        return new ShapeMarker(shape, color, size);
    }

    public static Marker newTextMarker(String text, Color color, int size, Priority priority) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size > 0, "The size of this marker has to be > 0");
        return new TextMarker(text, color, size, priority, false);
    }

    public static Marker newFlaggedTextMarker(String text, Color color, int size, Priority priority) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size > 0, "The size of this marker has to be > 0");
        return new TextMarker(text, color, size, priority, true);
    }

    public static Marker newShapeMarker(Shape shape, Color color, int size, Priority priority) {
        Preconditions.checkNotNull(shape, "shape cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(size > 0, "The size of this marker has to be > 0");
        return new ShapeMarker(shape, color, size, priority);
    }
}

