/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.BarChartPlot;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.Line;
import com.googlecode.charts4j.LineStyle;
import com.googlecode.charts4j.MarkedPoints;
import com.googlecode.charts4j.Marker;
import com.googlecode.charts4j.Markers;
import com.googlecode.charts4j.Plot;
import com.googlecode.charts4j.Priority;
import com.googlecode.charts4j.RadarPlot;
import com.googlecode.charts4j.ScatterPlotData;
import com.googlecode.charts4j.Shape;
import com.googlecode.charts4j.XYLine;
import com.googlecode.charts4j.collect.ImmutableList;
import com.googlecode.charts4j.collect.Lists;
import com.googlecode.charts4j.collect.Preconditions;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlotImpl
implements BarChartPlot,
Line,
RadarPlot,
ScatterPlotData,
XYLine {
    private final Data xData;
    private final Data yData;
    private final List<MarkedPoints> markedPointsList = Lists.newLinkedList();
    private final List<Marker> markers = Lists.newLinkedList();
    private final List<BarChartPlot.BarColor> barColors = Lists.newLinkedList();
    private Color color;
    private String legend;
    private Data pointSizes;
    private Color fillAreaColor;
    private double zeroLine = 0.0;
    private BarChartPlot.DataLine dataLine;
    private LineStyle lineStyle;
    private Priority priority;

    PlotImpl(Data xdata, Data ydata) {
        this.xData = xdata;
        this.yData = ydata;
    }

    PlotImpl(Data data) {
        this.yData = data;
        int inc = 0;
        if (data.getSize() > 1) {
            inc = 10000 / (data.getSize() - 1);
        }
        List<Double> xVals = Lists.newLinkedList();
        double x = 0.0;
        for (int i = 0; i < data.getSize(); ++i) {
            xVals.add(x / 100.0);
            x += (double)inc;
        }
        this.xData = Data.newData(xVals);
    }

    private PlotImpl(PlotImpl plotImpl) {
        this.xData = plotImpl.xData;
        this.yData = plotImpl.yData;
        this.markedPointsList.addAll(plotImpl.markedPointsList);
        this.barColors.addAll(plotImpl.barColors);
        this.markers.addAll(plotImpl.markers);
        this.color = plotImpl.color;
        this.legend = plotImpl.legend;
        this.pointSizes = plotImpl.pointSizes;
        this.fillAreaColor = plotImpl.fillAreaColor;
        this.zeroLine = plotImpl.zeroLine;
        this.dataLine = plotImpl.dataLine;
        this.lineStyle = plotImpl.lineStyle;
        this.priority = plotImpl.priority;
    }

    @Override
    public Plot klone() {
        return new PlotImpl(this);
    }

    Data getData() {
        return this.yData;
    }

    Data getXData() {
        return this.xData;
    }

    Data getYData() {
        return this.yData;
    }

    String getLegend() {
        return this.legend;
    }

    @Override
    public void setLegend(String legend) {
        Preconditions.checkNotNull(legend, "legend cannot be null");
        this.legend = legend;
    }

    Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        Preconditions.checkNotNull(color, "color cannot be null");
        this.color = color;
    }

    public ImmutableList<BarChartPlot.BarColor> getBarColors() {
        return Lists.copyOf(this.barColors);
    }

    @Override
    public void setColor(Color color, int index) {
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(index >= 0, "index must be >= 0");
        Preconditions.checkArgument(index < this.yData.getSize(), "index out of bounds");
        this.barColors.add(new BarChartPlot.BarColor(color, index));
    }

    Color getFillAreaColor() {
        return this.fillAreaColor;
    }

    @Override
    public void setFillAreaColor(Color color) {
        Preconditions.checkNotNull(color, "color cannot be null");
        this.fillAreaColor = color;
    }

    ImmutableList<MarkedPoints> getMarkedPointsList() {
        return Lists.copyOf(this.markedPointsList);
    }

    ImmutableList<Marker> getMarkers() {
        return Lists.copyOf(this.markers);
    }

    @Override
    public void addShapeMarker(Shape shape, Color color, int size, int index) {
        Preconditions.checkNotNull(shape, "shape cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(index >= 0, "index must be >= 0");
        Preconditions.checkArgument(index < this.yData.getSize(), "index is out of bounds");
        this.markedPointsList.add(new MarkedPoints(Markers.newShapeMarker(shape, color, size), index));
    }

    @Override
    public void addTextMarker(String text, Color color, int size, int index) {
        Preconditions.checkNotNull(text, "text cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkArgument(index >= 0, "index must be >= 0");
        Preconditions.checkArgument(index < this.yData.getSize(), "index is out of bounds");
        this.markedPointsList.add(new MarkedPoints(Markers.newTextMarker(text, color, size), index));
    }

    @Override
    public void addShapeMarkers(Shape shape, Color color, int size) {
        Preconditions.checkNotNull(shape, "shape cannot be null");
        Preconditions.checkNotNull(color, "color cannot be null");
        this.markers.add(Markers.newShapeMarker(shape, color, size));
    }

    @Override
    public void addMarker(Marker marker, int index) {
        Preconditions.checkNotNull(marker, "marker cannot be null");
        Preconditions.checkArgument(index >= 0, "index must be >= 0");
        this.markedPointsList.add(new MarkedPoints(marker, index));
    }

    @Override
    public void addMarkers(Marker marker) {
        Preconditions.checkNotNull(marker, "marker cannot be null");
        this.markers.add(marker);
    }

    @Override
    public void addMarkers(Marker marker, int startIndex, int endIndex, int n) {
        Preconditions.checkNotNull(marker, "marker cannot be null");
        Preconditions.checkArgument(startIndex >= 0, "start index must be >= 0");
        Preconditions.checkArgument(endIndex > 0, "end index must be > 0");
        Preconditions.checkArgument(endIndex > startIndex, "end index must be > start index");
        Preconditions.checkArgument(n > 0, "n must be > 0");
        this.markedPointsList.add(new MarkedPoints(marker, startIndex, endIndex, n));
    }

    @Override
    public void addMarkers(Marker marker, int n) {
        this.addMarkers(marker, 0, this.yData.getSize(), n);
    }

    @Override
    public void addMarkers(Marker marker, int startIndex, int endIndex) {
        this.addMarkers(marker, startIndex, endIndex, 1);
    }

    @Override
    public void setDataLine(int dataLineSize, Color color, Priority priority) {
        Preconditions.checkNotNull(color, "color cannot be null");
        Preconditions.checkNotNull(priority, "priority cannot be null");
        Preconditions.checkArgument(dataLineSize >= 0, "data line size must be >= 0");
        this.dataLine = new BarChartPlot.DataLine(dataLineSize, color, priority);
    }

    BarChartPlot.DataLine getDataLine() {
        return this.dataLine;
    }

    double getZeroLine() {
        return this.zeroLine;
    }

    @Override
    public void setZeroLine(double zeroLine) {
        Preconditions.checkArgument(zeroLine >= 0.0 && zeroLine <= 100.0, "Zero line must be between 0.0 and 100.0");
        this.zeroLine = zeroLine;
    }

    @Override
    public void setPriority(Priority priority) {
        Preconditions.checkNotNull(priority, "priority cannot be null");
        this.priority = priority;
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        Preconditions.checkNotNull(lineStyle, "line style cannot be null");
        this.lineStyle = lineStyle;
    }

    LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public void setPointSizes(Data pointSizes) {
        Preconditions.checkNotNull(pointSizes, "point sizes cannot be null");
        this.pointSizes = pointSizes;
    }

    Data getPointSizes() {
        return this.pointSizes;
    }

    Priority getPriority() {
        return this.priority;
    }
}

