/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.collect.Preconditions;

public class Slice {
    private final int percent;
    private final String label;
    private final String legend;
    private final Color color;

    Slice(int percent, Color color, String sliceLabel, String sliceLegend) {
        this.percent = percent;
        this.color = color;
        this.label = sliceLabel;
        this.legend = sliceLegend;
    }

    public final int getPercentage() {
        return this.percent;
    }

    public final Color getColor() {
        return this.color;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getLegend() {
        return this.legend;
    }

    public static Slice newSlice(int percent, Color color, String sliceLabel) {
        return Slice.newSlice(percent, color, sliceLabel, null);
    }

    public static Slice newSlice(int percent, Color color, String sliceLabel, String sliceLegend) {
        Preconditions.checkArgument(percent >= 0, "value must be between >= 0: %s", percent);
        return new Slice(percent, color, sliceLabel, sliceLegend);
    }

    @Deprecated
    public static Slice newSlice(int percent, Color color) {
        return Slice.newSlice(percent, color, null, null);
    }

    public static Slice newSlice(int percent, String sliceLabel) {
        return Slice.newSlice(percent, null, sliceLabel, null);
    }
}

