/*
 * Decompiled with CFR 0.152.
 */
package ezvcard;

import ezvcard.ValidationWarning;
import ezvcard.property.VCardProperty;
import ezvcard.util.ListMultimap;
import ezvcard.util.StringUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValidationWarnings
implements Iterable<Map.Entry<VCardProperty, List<ValidationWarning>>> {
    private final ListMultimap<VCardProperty, ValidationWarning> warnings = new ListMultimap(new IdentityHashMap());

    public void add(VCardProperty property, ValidationWarning warning) {
        this.warnings.put(property, warning);
    }

    public void add(VCardProperty property, List<ValidationWarning> warnings) {
        this.warnings.putAll(property, warnings);
    }

    public ListMultimap<VCardProperty, ValidationWarning> getWarnings() {
        return this.warnings;
    }

    public boolean isEmpty() {
        return this.warnings.isEmpty();
    }

    public List<ValidationWarning> getByProperty(Class<? extends VCardProperty> propertyClass) {
        ArrayList<ValidationWarning> propWarnings = new ArrayList<ValidationWarning>();
        for (Map.Entry<VCardProperty, List<ValidationWarning>> entry : this.warnings) {
            VCardProperty property = entry.getKey();
            if ((property != null || propertyClass != null) && (property == null || propertyClass != property.getClass())) continue;
            List<ValidationWarning> propViolations = entry.getValue();
            propWarnings.addAll(propViolations);
        }
        return propWarnings;
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMinimumIntegerDigits(2);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<VCardProperty, List<ValidationWarning>> entry : this.warnings) {
            VCardProperty property = entry.getKey();
            List<ValidationWarning> propViolations = entry.getValue();
            for (ValidationWarning propViolation : propViolations) {
                Integer code;
                if (property != null) {
                    sb.append('[');
                    sb.append(property.getClass().getSimpleName());
                    sb.append("] | ");
                }
                if ((code = propViolation.getCode()) != null) {
                    sb.append('W');
                    sb.append(nf.format(code));
                    sb.append(": ");
                }
                sb.append(propViolation.getMessage());
                sb.append(StringUtils.NEWLINE);
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<Map.Entry<VCardProperty, List<ValidationWarning>>> iterator() {
        return this.warnings.iterator();
    }
}

