/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.EmbeddedVCardException;
import ezvcard.io.SkipMeException;
import ezvcard.io.StreamWriter;
import ezvcard.io.json.JCardRawWriter;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.VCardProperty;
import ezvcard.util.Utf8Writer;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;

public class JCardWriter
extends StreamWriter
implements Flushable {
    private final JCardRawWriter writer;
    private final VCardVersion targetVersion = VCardVersion.V4_0;
    private JsonGenerator generator = null;

    public JCardWriter(OutputStream out) {
        this(new Utf8Writer(out));
    }

    public JCardWriter(OutputStream out, boolean wrapInArray) {
        this(new Utf8Writer(out), wrapInArray);
    }

    public JCardWriter(File file) throws IOException {
        this(new Utf8Writer(file));
    }

    public JCardWriter(File file, boolean wrapInArray) throws IOException {
        this(new Utf8Writer(file), wrapInArray);
    }

    public JCardWriter(Writer writer) {
        this(writer, false);
    }

    public JCardWriter(Writer writer, boolean wrapInArray) {
        this.writer = new JCardRawWriter(writer, wrapInArray);
    }

    public JCardWriter(JsonGenerator generator) {
        this.generator = generator;
        this.writer = new JCardRawWriter(generator);
    }

    @Override
    protected void _write(VCard vcard, List<VCardProperty> properties) throws IOException {
        Object previousValue = this.getCurrentValue();
        this.writer.writeStartVCard();
        this.writer.writeProperty("version", VCardDataType.TEXT, JCardValue.single(this.targetVersion.getVersion()));
        for (VCardProperty property : properties) {
            JCardValue value;
            VCardPropertyScribe<? extends VCardProperty> scribe = this.index.getPropertyScribe(property);
            try {
                value = scribe.writeJson(property);
            }
            catch (SkipMeException e) {
                continue;
            }
            catch (EmbeddedVCardException e) {
                continue;
            }
            String group = property.getGroup();
            String name = scribe.getPropertyName().toLowerCase();
            VCardParameters parameters = scribe.prepareParameters(property, this.targetVersion, vcard);
            this.removeUnsupportedParameters(parameters);
            VCardDataType dataType = scribe.dataType(property, this.targetVersion);
            this.writer.writeProperty(group, name, parameters, dataType, value);
        }
        this.writer.writeEndVCard();
        this.setCurrentValue(previousValue);
    }

    private Object getCurrentValue() {
        return this.generator == null ? null : this.generator.getCurrentValue();
    }

    private void setCurrentValue(Object value) {
        if (this.generator != null) {
            this.generator.setCurrentValue(value);
        }
    }

    @Override
    protected VCardVersion getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isPrettyPrint() {
        return this.writer.isPrettyPrint();
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.writer.setPrettyPrint(prettyPrint);
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.writer.setPrettyPrinter(prettyPrinter);
    }

    private void removeUnsupportedParameters(VCardParameters parameters) {
        parameters.setCharset(null);
        parameters.setEncoding(null);
        parameters.setValue(null);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public void closeJsonStream() throws IOException {
        this.writer.closeJsonStream();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

