/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum VCardDateFormat {
    DATE_BASIC("yyyyMMdd"),
    DATE_EXTENDED("yyyy-MM-dd"),
    DATE_TIME_BASIC("yyyyMMdd'T'HHmmssZ"),
    DATE_TIME_EXTENDED("yyyy-MM-dd'T'HH:mm:ssZ"){

        @Override
        public DateFormat getDateFormat(TimeZone timezone) {
            SimpleDateFormat df = new SimpleDateFormat(this.formatStr, Locale.ROOT){

                @Override
                public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                    StringBuffer sb = super.format(date, toAppendTo, fieldPosition);
                    sb.insert(sb.length() - 2, ':');
                    return sb;
                }
            };
            if (timezone != null) {
                df.setTimeZone(timezone);
            }
            return df;
        }
    }
    ,
    UTC_DATE_TIME_BASIC("yyyyMMdd'T'HHmmss'Z'"){

        @Override
        public DateFormat getDateFormat(TimeZone timezone) {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(utc);
        }
    }
    ,
    UTC_DATE_TIME_EXTENDED("yyyy-MM-dd'T'HH:mm:ss'Z'"){

        @Override
        public DateFormat getDateFormat(TimeZone timezone) {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(utc);
        }
    }
    ,
    HCARD_DATE_TIME("yyyy-MM-dd'T'HH:mm:ssZ");

    protected final String formatStr;

    private VCardDateFormat(String formatStr) {
        this.formatStr = formatStr;
    }

    public DateFormat getDateFormat() {
        return this.getDateFormat(null);
    }

    public DateFormat getDateFormat(TimeZone timezone) {
        SimpleDateFormat df = new SimpleDateFormat(this.formatStr, Locale.ROOT);
        if (timezone != null) {
            df.setTimeZone(timezone);
        }
        return df;
    }

    public String format(Date date) {
        return this.format(date, null);
    }

    public String format(Date date, TimeZone timezone) {
        DateFormat df = this.getDateFormat(timezone);
        return df.format(date);
    }

    public static Date parse(String dateStr) {
        return VCardDateFormat.parseAsCalendar(dateStr).getTime();
    }

    public static Calendar parseAsCalendar(String dateStr) {
        TimestampPattern p = new TimestampPattern(dateStr);
        if (!p.matches()) {
            throw Messages.INSTANCE.getIllegalArgumentException(41, dateStr);
        }
        Calendar c = Calendar.getInstance(p.timezone());
        c.clear();
        c.set(1, p.year());
        c.set(2, p.month() - 1);
        c.set(5, p.date());
        if (p.hasTime()) {
            c.set(11, p.hour());
            c.set(12, p.minute());
            c.set(13, p.second());
            c.set(14, p.millisecond());
        }
        return c;
    }

    public static boolean dateHasTime(String dateStr) {
        return dateStr.contains("T");
    }

    public static boolean dateHasTimezone(String dateStr) {
        return dateStr.endsWith("Z") || dateStr.matches(".*?[-+]\\d\\d:?\\d\\d");
    }

    public static TimeZone parseTimeZoneId(String timezoneId) {
        TimeZone timezone = TimeZone.getTimeZone(timezoneId);
        return "GMT".equals(timezone.getID()) ? null : timezone;
    }

    public static Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    private static class TimestampPattern {
        private static final Pattern regex = Pattern.compile("^(\\d{4})(-?(\\d{2})-?(\\d{2})|-(\\d{1,2})-(\\d{1,2}))(T(\\d{2}):?(\\d{2}):?(\\d{2})(\\.\\d+)?(Z|([-+])((\\d{2})|((\\d{2}):?(\\d{2}))))?)?$");
        private final Matcher m;
        private final boolean matches;

        public TimestampPattern(String str) {
            this.m = regex.matcher(str);
            this.matches = this.m.find();
        }

        public boolean matches() {
            return this.matches;
        }

        public int year() {
            return this.parseInt(1);
        }

        public int month() {
            return this.parseInt(3, 5);
        }

        public int date() {
            return this.parseInt(4, 6);
        }

        public boolean hasTime() {
            return this.m.group(8) != null;
        }

        public int hour() {
            return this.parseInt(8);
        }

        public int minute() {
            return this.parseInt(9);
        }

        public int second() {
            return this.parseInt(10);
        }

        public int millisecond() {
            String s = this.m.group(11);
            if (s == null) {
                return 0;
            }
            double ms = Double.parseDouble(s) * 1000.0;
            return (int)Math.round(ms);
        }

        public TimeZone timezone() {
            String offsetStr = this.m.group(12);
            if (offsetStr == null) {
                return TimeZone.getDefault();
            }
            if (offsetStr.equals("Z")) {
                return TimeZone.getTimeZone("GMT");
            }
            return TimeZone.getTimeZone("GMT" + offsetStr);
        }

        private int parseInt(int ... group) {
            for (int g : group) {
                String s = this.m.group(g);
                if (s == null) continue;
                return Integer.parseInt(s);
            }
            throw new NullPointerException();
        }
    }
}

