/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.chain;

import ezvcard.VCard;
import ezvcard.io.ParseWarning;
import ezvcard.io.StreamReader;
import ezvcard.io.scribe.ScribeIndex;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.property.VCardProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

abstract class ChainingParser<T extends ChainingParser<?>> {
    final String string;
    final InputStream in;
    final Reader reader;
    final File file;
    ScribeIndex index;
    List<List<ParseWarning>> warnings;
    final T this_ = this;

    ChainingParser(String string) {
        this(string, null, null, null);
    }

    ChainingParser(InputStream in) {
        this(null, in, null, null);
    }

    ChainingParser(Reader reader) {
        this(null, null, reader, null);
    }

    ChainingParser(File file) {
        this(null, null, null, file);
    }

    ChainingParser() {
        this(null, null, null, null);
    }

    private ChainingParser(String string, InputStream in, Reader reader, File file) {
        this.string = string;
        this.in = in;
        this.reader = reader;
        this.file = file;
    }

    public T register(VCardPropertyScribe<? extends VCardProperty> scribe) {
        if (this.index == null) {
            this.index = new ScribeIndex();
        }
        this.index.register(scribe);
        return this.this_;
    }

    public T warnings(List<List<ParseWarning>> warnings) {
        this.warnings = warnings;
        return this.this_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCard first() throws IOException {
        StreamReader reader = this.constructReader();
        if (this.index != null) {
            reader.setScribeIndex(this.index);
        }
        try {
            VCard vcard = reader.readNext();
            if (this.warnings != null) {
                this.warnings.add(reader.getWarnings());
            }
            VCard vCard = vcard;
            return vCard;
        }
        finally {
            if (this.closeWhenDone()) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VCard> all() throws IOException {
        StreamReader reader = this.constructReader();
        if (this.index != null) {
            reader.setScribeIndex(this.index);
        }
        try {
            VCard vcard;
            ArrayList<VCard> vcards = new ArrayList<VCard>();
            while ((vcard = reader.readNext()) != null) {
                if (this.warnings != null) {
                    this.warnings.add(reader.getWarnings());
                }
                vcards.add(vcard);
            }
            ArrayList<VCard> arrayList = vcards;
            return arrayList;
        }
        finally {
            if (this.closeWhenDone()) {
                reader.close();
            }
        }
    }

    abstract StreamReader constructReader() throws IOException;

    private boolean closeWhenDone() {
        return this.in == null && this.reader == null;
    }
}

