/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.VCard;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Address;
import ezvcard.util.StringUtils;
import java.util.List;

public class AddressScribe
extends VCardPropertyScribe<Address> {
    public AddressScribe() {
        super(Address.class, "ADR");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected void _prepareParameters(Address property, VCardParameters copy, VCardVersion version, VCard vcard) {
        AddressScribe.handlePrefParam(property, copy, version, vcard);
        if (version == VCardVersion.V2_1 || version == VCardVersion.V3_0) {
            copy.setLabel(null);
        }
    }

    @Override
    protected String _writeText(Address property, WriteContext context) {
        if (context.getVersion() == VCardVersion.V2_1) {
            VObjectPropertyValues.SemiStructuredValueBuilder builder = new VObjectPropertyValues.SemiStructuredValueBuilder();
            builder.append((Object)StringUtils.join(property.getPoBoxes(), ","));
            builder.append((Object)StringUtils.join(property.getExtendedAddresses(), ","));
            builder.append((Object)StringUtils.join(property.getStreetAddresses(), ","));
            builder.append((Object)StringUtils.join(property.getLocalities(), ","));
            builder.append((Object)StringUtils.join(property.getRegions(), ","));
            builder.append((Object)StringUtils.join(property.getPostalCodes(), ","));
            builder.append((Object)StringUtils.join(property.getCountries(), ","));
            return builder.build(false, context.isIncludeTrailingSemicolons());
        }
        VObjectPropertyValues.StructuredValueBuilder builder = new VObjectPropertyValues.StructuredValueBuilder();
        builder.append(property.getPoBoxes());
        builder.append(property.getExtendedAddresses());
        builder.append(property.getStreetAddresses());
        builder.append(property.getLocalities());
        builder.append(property.getRegions());
        builder.append(property.getPostalCodes());
        builder.append(property.getCountries());
        return builder.build(context.isIncludeTrailingSemicolons());
    }

    @Override
    protected Address _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        if (context.getVersion() == VCardVersion.V2_1) {
            VObjectPropertyValues.SemiStructuredValueIterator it = new VObjectPropertyValues.SemiStructuredValueIterator(value);
            return AddressScribe.parseSemiStructuredValue(it);
        }
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value);
        return AddressScribe.parseStructuredValue(it);
    }

    @Override
    protected void _writeXml(Address property, XCardElement parent) {
        parent.append("pobox", property.getPoBoxes());
        parent.append("ext", property.getExtendedAddresses());
        parent.append("street", property.getStreetAddresses());
        parent.append("locality", property.getLocalities());
        parent.append("region", property.getRegions());
        parent.append("code", property.getPostalCodes());
        parent.append("country", property.getCountries());
    }

    @Override
    protected Address _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        Address property = new Address();
        property.getPoBoxes().addAll(this.sanitizeXml(element, "pobox"));
        property.getExtendedAddresses().addAll(this.sanitizeXml(element, "ext"));
        property.getStreetAddresses().addAll(this.sanitizeXml(element, "street"));
        property.getLocalities().addAll(this.sanitizeXml(element, "locality"));
        property.getRegions().addAll(this.sanitizeXml(element, "region"));
        property.getPostalCodes().addAll(this.sanitizeXml(element, "code"));
        property.getCountries().addAll(this.sanitizeXml(element, "country"));
        return property;
    }

    private List<String> sanitizeXml(XCardElement element, String name) {
        return element.all(name);
    }

    @Override
    protected Address _parseHtml(HCardElement element, ParseContext context) {
        Address property = new Address();
        property.getPoBoxes().addAll(element.allValues("post-office-box"));
        property.getExtendedAddresses().addAll(element.allValues("extended-address"));
        property.getStreetAddresses().addAll(element.allValues("street-address"));
        property.getLocalities().addAll(element.allValues("locality"));
        property.getRegions().addAll(element.allValues("region"));
        property.getPostalCodes().addAll(element.allValues("postal-code"));
        property.getCountries().addAll(element.allValues("country-name"));
        List<String> types = element.types();
        property.getParameters().putAll("TYPE", types);
        return property;
    }

    @Override
    protected JCardValue _writeJson(Address property) {
        return JCardValue.structured(property.getPoBoxes(), property.getExtendedAddresses(), property.getStreetAddresses(), property.getLocalities(), property.getRegions(), property.getPostalCodes(), property.getCountries());
    }

    @Override
    protected Address _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        VObjectPropertyValues.StructuredValueIterator it = new VObjectPropertyValues.StructuredValueIterator(value.asStructured());
        return AddressScribe.parseStructuredValue(it);
    }

    private static Address parseStructuredValue(VObjectPropertyValues.StructuredValueIterator it) {
        Address property = new Address();
        property.getPoBoxes().addAll(it.nextComponent());
        property.getExtendedAddresses().addAll(it.nextComponent());
        property.getStreetAddresses().addAll(it.nextComponent());
        property.getLocalities().addAll(it.nextComponent());
        property.getRegions().addAll(it.nextComponent());
        property.getPostalCodes().addAll(it.nextComponent());
        property.getCountries().addAll(it.nextComponent());
        return property;
    }

    private static Address parseSemiStructuredValue(VObjectPropertyValues.SemiStructuredValueIterator it) {
        Address property = new Address();
        String next = it.next();
        if (next != null) {
            property.getPoBoxes().add(next);
        }
        if ((next = it.next()) != null) {
            property.getExtendedAddresses().add(next);
        }
        if ((next = it.next()) != null) {
            property.getStreetAddresses().add(next);
        }
        if ((next = it.next()) != null) {
            property.getLocalities().add(next);
        }
        if ((next = it.next()) != null) {
            property.getRegions().add(next);
        }
        if ((next = it.next()) != null) {
            property.getPostalCodes().add(next);
        }
        if ((next = it.next()) != null) {
            property.getCountries().add(next);
        }
        return property;
    }
}

