/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.SupportedVersions;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.property.VCardProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@SupportedVersions(value={VCardVersion.V4_0})
public class ClientPidMap
extends VCardProperty {
    private Integer pid;
    private String uri;

    public ClientPidMap(Integer pid, String uri) {
        this.pid = pid;
        this.uri = uri;
    }

    public ClientPidMap(ClientPidMap original) {
        super(original);
        this.pid = original.pid;
        this.uri = original.uri;
    }

    public static ClientPidMap random(Integer pid) {
        String uuid = UUID.randomUUID().toString();
        return new ClientPidMap(pid, "urn:uuid:" + uuid);
    }

    public Integer getPid() {
        return this.pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.pid == null && this.uri == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("pid", this.pid);
        values.put("uri", this.uri);
        return values;
    }

    @Override
    public ClientPidMap copy() {
        return new ClientPidMap(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ClientPidMap other = (ClientPidMap)obj;
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

