/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.io.scribe;

import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import ezvcard.Messages;
import ezvcard.VCardDataType;
import ezvcard.VCardVersion;
import ezvcard.io.CannotParseException;
import ezvcard.io.ParseContext;
import ezvcard.io.html.HCardElement;
import ezvcard.io.json.JCardValue;
import ezvcard.io.scribe.VCardPropertyScribe;
import ezvcard.io.text.WriteContext;
import ezvcard.io.xml.XCardElement;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.Timezone;
import ezvcard.util.VCardDateFormat;
import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class TimezoneScribe
extends VCardPropertyScribe<Timezone> {
    public TimezoneScribe() {
        super(Timezone.class, "TZ");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        switch (version) {
            case V2_1: 
            case V3_0: {
                return VCardDataType.UTC_OFFSET;
            }
            case V4_0: {
                return VCardDataType.TEXT;
            }
        }
        return null;
    }

    @Override
    protected VCardDataType _dataType(Timezone property, VCardVersion version) {
        String text = property.getText();
        ZoneOffset offset = property.getOffset();
        switch (version) {
            case V2_1: {
                return VCardDataType.UTC_OFFSET;
            }
            case V3_0: {
                if (offset != null) {
                    return VCardDataType.UTC_OFFSET;
                }
                if (text == null) break;
                return VCardDataType.TEXT;
            }
            case V4_0: {
                if (text != null) {
                    return VCardDataType.TEXT;
                }
                if (offset == null) break;
                return VCardDataType.UTC_OFFSET;
            }
        }
        return this._defaultDataType(version);
    }

    @Override
    protected String _writeText(Timezone property, WriteContext context) {
        String text = property.getText();
        ZoneOffset offset = property.getOffset();
        switch (context.getVersion()) {
            case V2_1: {
                if (offset != null) {
                    return VCardDateFormat.BASIC.format(offset);
                }
                if (text == null) break;
                try {
                    ZoneId zoneId = ZoneId.of(text);
                    ZoneOffset offsetNow = OffsetDateTime.now(zoneId).getOffset();
                    return VCardDateFormat.BASIC.format(offsetNow);
                }
                catch (DateTimeException dateTimeException) {
                    break;
                }
            }
            case V3_0: {
                if (offset != null) {
                    return VCardDateFormat.EXTENDED.format(offset);
                }
                if (text == null) break;
                return VObjectPropertyValues.escape((String)text);
            }
            case V4_0: {
                if (text != null) {
                    return VObjectPropertyValues.escape((String)text);
                }
                if (offset == null) break;
                return VCardDateFormat.BASIC.format(offset);
            }
        }
        return "";
    }

    @Override
    protected Timezone _parseText(String value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        return this.parse(value, dataType, context);
    }

    @Override
    protected void _writeXml(Timezone property, XCardElement parent) {
        String text = property.getText();
        if (text != null) {
            parent.append(VCardDataType.TEXT, text);
            return;
        }
        ZoneOffset offset = property.getOffset();
        if (offset != null) {
            parent.append(VCardDataType.UTC_OFFSET, VCardDateFormat.BASIC.format(offset));
            return;
        }
        parent.append(VCardDataType.TEXT, "");
    }

    @Override
    protected Timezone _parseXml(XCardElement element, VCardParameters parameters, ParseContext context) {
        String text = element.first(VCardDataType.TEXT);
        if (text != null) {
            return new Timezone(text);
        }
        String utcOffset = element.first(VCardDataType.UTC_OFFSET);
        if (utcOffset != null) {
            try {
                return new Timezone(ZoneOffset.of(utcOffset));
            }
            catch (DateTimeException e) {
                throw new CannotParseException(19, new Object[0]);
            }
        }
        throw TimezoneScribe.missingXmlElements(VCardDataType.TEXT, VCardDataType.UTC_OFFSET);
    }

    @Override
    protected Timezone _parseHtml(HCardElement element, ParseContext context) {
        return this.parse(element.value(), null, context);
    }

    @Override
    protected JCardValue _writeJson(Timezone property) {
        String text = property.getText();
        if (text != null) {
            return JCardValue.single(text);
        }
        ZoneOffset offset = property.getOffset();
        if (offset != null) {
            return JCardValue.single(VCardDateFormat.EXTENDED.format(offset));
        }
        return JCardValue.single("");
    }

    @Override
    protected Timezone _parseJson(JCardValue value, VCardDataType dataType, VCardParameters parameters, ParseContext context) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, dataType, context);
    }

    private Timezone parse(String value, VCardDataType dataType, ParseContext context) {
        if (value == null || value.isEmpty()) {
            return new Timezone((String)null);
        }
        switch (context.getVersion()) {
            case V2_1: {
                try {
                    return new Timezone(this.parse(value));
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(19, new Object[0]);
                }
            }
            case V3_0: 
            case V4_0: {
                try {
                    return new Timezone(this.parse(value));
                }
                catch (IllegalArgumentException e) {
                    if (dataType == VCardDataType.UTC_OFFSET) {
                        context.addWarning(20, new Object[0]);
                    }
                    return new Timezone(value);
                }
            }
        }
        return new Timezone((String)null);
    }

    private ZoneOffset parse(String text) {
        int minute;
        int hour;
        String hourStr;
        int i = 0;
        char sign = text.charAt(i);
        boolean negative = false;
        if (sign == '-') {
            negative = true;
            ++i;
        } else if (sign == '+') {
            ++i;
        }
        int maxLength = i + 4;
        int colon = text.indexOf(58, i);
        if (colon >= 0) {
            ++maxLength;
        }
        if (text.length() > maxLength) {
            throw Messages.INSTANCE.getIllegalArgumentException(40, text);
        }
        String minuteStr = null;
        if (colon < 0) {
            hourStr = text.substring(i);
            int minutePos = hourStr.length() - 2;
            if (minutePos > 0) {
                minuteStr = hourStr.substring(minutePos);
                hourStr = hourStr.substring(0, minutePos);
            }
        } else {
            hourStr = text.substring(i, colon);
            if (colon < text.length() - 1) {
                minuteStr = text.substring(colon + 1);
            }
        }
        try {
            hour = Integer.parseInt(hourStr);
            minute = minuteStr == null ? 0 : Integer.parseInt(minuteStr);
        }
        catch (NumberFormatException e) {
            throw Messages.INSTANCE.getIllegalArgumentException(40, text);
        }
        if (negative) {
            hour *= -1;
            minute *= -1;
        }
        return ZoneOffset.ofHoursMinutes(hour, minute);
    }
}

