/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toDocument(String xml) throws SAXException {
        try {
            return XmlUtils.toDocument(new StringReader(xml));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Document toDocument(Path file) throws SAXException, IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
            Document document = XmlUtils.toDocument(in);
            return document;
        }
    }

    public static Document toDocument(InputStream in) throws SAXException, IOException {
        return XmlUtils.toDocument(new InputSource(in));
    }

    public static Document toDocument(Reader reader) throws SAXException, IOException {
        return XmlUtils.toDocument(new InputSource(reader));
    }

    private static Document toDocument(InputSource in) throws SAXException, IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        XmlUtils.applyXXEProtection(factory);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder.parse(in);
    }

    public static void applyXXEProtection(DocumentBuilderFactory factory) {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        features.put("http://xml.org/sax/features/external-general-entities", false);
        features.put("http://xml.org/sax/features/external-parameter-entities", false);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        for (Map.Entry entry : features.entrySet()) {
            String feature = (String)entry.getKey();
            Boolean value = (Boolean)entry.getValue();
            try {
                factory.setFeature(feature, value);
            }
            catch (ParserConfigurationException parserConfigurationException) {}
        }
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
    }

    public static void applyXXEProtection(TransformerFactory factory) {
        String[] attributes;
        for (String attribute : attributes = new String[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", "http://javax.xml.XMLConstants/property/accessExternalStylesheet"}) {
            try {
                factory.setAttribute(attribute, "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static String toString(Node node) {
        return XmlUtils.toString(node, new HashMap<String, String>());
    }

    public static String toString(Node node, Map<String, String> outputProperties) {
        try {
            StringWriter writer = new StringWriter();
            XmlUtils.toWriter(node, writer, outputProperties);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toWriter(Node node, Writer writer) throws TransformerException {
        XmlUtils.toWriter(node, writer, new HashMap<String, String>());
    }

    public static void toWriter(Node node, Writer writer, Map<String, String> outputProperties) throws TransformerException {
        Transformer transformer;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        XmlUtils.assignOutputProperties(transformer, outputProperties);
        DOMSource source = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
    }

    public static void assignOutputProperties(Transformer transformer, Map<String, String> outputProperties) {
        for (Map.Entry<String, String> property : outputProperties.entrySet()) {
            try {
                transformer.setOutputProperty(property.getKey(), property.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static List<Element> toElementList(NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static Element getFirstChildElement(Element parent) {
        return XmlUtils.getFirstChildElement((Node)parent);
    }

    private static Element getFirstChildElement(Node parent) {
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public static boolean hasQName(Node node, QName qname) {
        return qname.getNamespaceURI().equals(node.getNamespaceURI()) && qname.getLocalPart().equals(node.getLocalName());
    }

    private XmlUtils() {
    }
}

