/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.finder;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.test.finder.GwtFinderException;
import com.googlecode.gwt.test.finder.GwtInstance;
import com.googlecode.gwt.test.finder.Node;
import com.googlecode.gwt.test.finder.NodeObjectFinder;
import com.googlecode.gwt.test.finder.ObjectFinder;
import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtFinder
implements AfterTestCallback {
    private static GwtFinder INSTANCE = new GwtFinder();
    private final List<ObjectFinder> customObjectFinders = new ArrayList<ObjectFinder>();
    private final DefaultObjectFinder defaultObjectFinder = new DefaultObjectFinder();
    private final IndexedObjectFinder indexedObjectFinder = new IndexedObjectFinder();

    public static <T> T find(Object o, Node node) {
        return INSTANCE.findInternal(o, node);
    }

    public static GwtInstance object(String ... identifier) {
        return new GwtInstance(INSTANCE.findInternal(identifier), identifier);
    }

    public static void registerFinder(ObjectFinder finder) {
        GwtFinder.INSTANCE.customObjectFinders.add(finder);
    }

    public static void registerNodeFinder(String prefix, NodeObjectFinder nodeObjectFinder) {
        GwtFinder.INSTANCE.defaultObjectFinder.nodeObjectFinders.put(prefix, nodeObjectFinder);
    }

    protected static void onAttach(Widget widget) {
        String id;
        if (Composite.class.isInstance(widget.getParent()) && GwtFinder.getCompositeWidget(widget.getParent()) == widget) {
            GwtFinder.onAttach(widget.getParent());
            return;
        }
        if (HasHTML.class.isInstance(widget)) {
            GwtFinder.onSetIndex(widget, ((HasHTML)widget).getHTML(), GwtFinder.INSTANCE.indexedObjectFinder.mapByHTML);
        }
        if (HasText.class.isInstance(widget)) {
            GwtFinder.onSetIndex(widget, ((HasText)widget).getText(), GwtFinder.INSTANCE.indexedObjectFinder.mapByText);
        }
        if (HasName.class.isInstance(widget)) {
            GwtFinder.onSetIndex(widget, ((HasName)widget).getName(), GwtFinder.INSTANCE.indexedObjectFinder.mapByName);
        }
        if (widget.getElement() != null && (id = widget.getElement().getId()) != null && id.length() > 0) {
            GwtFinder.INSTANCE.indexedObjectFinder.mapById.put(id, widget);
        }
    }

    protected static void onDetach(Widget widget) {
        Set byName;
        Set byText;
        Set byHTML;
        if (Composite.class.isInstance(widget.getParent()) && GwtFinder.getCompositeWidget(widget.getParent()) == widget) {
            GwtFinder.onDetach(widget.getParent());
            return;
        }
        if (HasHTML.class.isInstance(widget) && (byHTML = (Set)GwtFinder.INSTANCE.indexedObjectFinder.mapByHTML.get(((HasHTML)widget).getHTML())) != null) {
            byHTML.remove(widget);
        }
        if (HasText.class.isInstance(widget) && (byText = (Set)GwtFinder.INSTANCE.indexedObjectFinder.mapByText.get(((HasText)widget).getText())) != null) {
            byText.remove(widget);
        }
        if (HasName.class.isInstance(widget) && (byName = (Set)GwtFinder.INSTANCE.indexedObjectFinder.mapByName.get(((HasName)widget).getName())) != null) {
            byName.remove(widget);
        }
        if (widget.getElement() != null) {
            GwtFinder.INSTANCE.indexedObjectFinder.mapById.remove(widget.getElement().getId());
        }
    }

    protected static void onSetHTML(Object hasHTML, String newHTML, String oldHTML) {
        if (!(hasHTML instanceof Widget) || ((Widget)hasHTML).isAttached() || hasHTML instanceof PopupPanel) {
            GwtFinder.onSetIndex(hasHTML, newHTML, oldHTML, GwtFinder.INSTANCE.indexedObjectFinder.mapByHTML);
        }
    }

    protected static void onSetId(Object o, String newId, String oldId) {
        if (!(o instanceof Widget) || ((Widget)o).isAttached() || o instanceof PopupPanel) {
            GwtFinder.INSTANCE.indexedObjectFinder.mapById.remove(oldId);
            GwtFinder.INSTANCE.indexedObjectFinder.mapById.put(newId, o);
        }
    }

    protected static void onSetName(Object hasName, String newName, String oldName) {
        if (!(hasName instanceof Widget) || ((Widget)hasName).isAttached() || hasName instanceof PopupPanel) {
            GwtFinder.onSetIndex(hasName, newName, oldName, GwtFinder.INSTANCE.indexedObjectFinder.mapByName);
        }
    }

    protected static void onSetText(Object hasText, String newText, String oldText) {
        if (!(hasText instanceof Widget) || ((Widget)hasText).isAttached() || hasText instanceof PopupPanel) {
            GwtFinder.onSetIndex(hasText, newText, oldText, GwtFinder.INSTANCE.indexedObjectFinder.mapByText);
        }
    }

    private static Widget getCompositeWidget(Widget composite) {
        return (Widget)GwtReflectionUtils.callPrivateMethod((Object)composite, "getWidget", new Object[0]);
    }

    private static void onSetIndex(Object object, String index, Map<String, Set<Object>> cache) {
        Set<Object> newSet = cache.get(index);
        if (newSet == null) {
            newSet = new HashSet<Object>();
            cache.put(index, newSet);
        }
        newSet.add(object);
    }

    private static void onSetIndex(Object object, String newIndex, String oldIndex, Map<String, Set<Object>> cache) {
        Set<Object> oldSet = cache.get(oldIndex);
        if (oldSet != null) {
            if (oldSet.size() == 1 && oldSet.contains(object)) {
                cache.remove(object);
            } else {
                oldSet.remove(object);
            }
        }
        GwtFinder.onSetIndex(object, newIndex, cache);
    }

    private GwtFinder() {
        AfterTestCallbackManager.get().registerCallback(this);
    }

    @Override
    public void afterTest() {
        this.customObjectFinders.clear();
        this.defaultObjectFinder.nodeObjectFinders.clear();
        this.indexedObjectFinder.mapById.clear();
        this.indexedObjectFinder.mapByHTML.clear();
        this.indexedObjectFinder.mapByText.clear();
        this.indexedObjectFinder.mapByName.clear();
    }

    private boolean checkCondition(Object n, Node before, String after) {
        Object result = GwtFinder.find(n, before);
        String s = result == null ? null : result.toString();
        return after.equals(s);
    }

    private Object findInIterable(Iterable<Object> list, Node before, String after, Object current, Method m) {
        Object found = null;
        for (Object n : list) {
            if (!this.checkCondition(n, before, after)) continue;
            if (found != null) {
                throw new GwtFinderException("Not unique object with condition " + before + "=" + after);
            }
            found = n;
        }
        if (found == null) {
            throw new GwtFinderException("Not found " + before + "=" + after + " in " + current.getClass().getCanonicalName() + (m != null ? " method " + m.getName() : ""));
        }
        return found;
    }

    private Object findInList(final Object current, final Method m, Node mapEq, String map) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (m.getParameterTypes().length != 1 && m.getParameterTypes()[0] != Integer.TYPE) {
            throw new GwtFinderException("Unable to navigate " + current.getClass().getCanonicalName() + " with method " + m.getName());
        }
        Method countM = GwtReflectionUtils.getMethod(current.getClass(), m.getName() + "Count");
        if (countM == null) {
            throw new GwtFinderException("Count method not found in " + current.getClass().getCanonicalName() + " method " + m.getName());
        }
        if (countM.getParameterTypes().length > 0) {
            throw new GwtFinderException("Too many parameter in count method " + countM.toGenericString());
        }
        final int count = (Integer)countM.invoke(current, new Object[0]);
        return this.findInIterable(new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    int counter = 0;

                    @Override
                    public boolean hasNext() {
                        return this.counter < count;
                    }

                    @Override
                    public Object next() {
                        try {
                            return m.invoke(current, this.counter++);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Iterator exception", e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not implemented");
                    }
                };
            }
        }, mapEq, map, current, m);
    }

    private <T> T findInternal(Object o, Node node) {
        Object current = o;
        for (Node currentNode = node; currentNode != null; currentNode = currentNode.getNext()) {
            Field f;
            if (current == null) {
                return null;
            }
            String currentName = currentNode.getLabel();
            boolean mapEqIsProcessed = false;
            boolean ok = false;
            if (!ok) {
                Method m = null;
                if (m == null) {
                    m = GwtReflectionUtils.getMethod(current.getClass(), currentName);
                }
                if (m == null) {
                    m = GwtReflectionUtils.getMethod(current.getClass(), "get" + currentName);
                }
                if (m != null) {
                    try {
                        if (m.getParameterTypes().length == 0 || currentNode.getParams() != null) {
                            current = this.invoke(current, m, currentNode.getParams());
                            ok = true;
                        } else {
                            current = this.findInList(current, m, currentNode.getMapEq(), currentNode.getMap());
                            mapEqIsProcessed = true;
                            ok = true;
                        }
                    }
                    catch (Exception e) {
                        throw new GwtFinderException("Unable to get method result on " + o.getClass().getCanonicalName() + ", method " + m.getName() + ", params " + currentNode.getParams(), e);
                    }
                }
            }
            if (!ok && (f = this.getField(current, current.getClass(), currentName)) != null) {
                try {
                    current = f.get(current);
                    ok = true;
                }
                catch (Exception e) {
                    throw new GwtFinderException("Unable to get field value on " + o.getClass().getCanonicalName() + ", field " + f.getName() + ", params " + node, e);
                }
            }
            if (ok && currentNode.getMap() != null) {
                if (currentNode.getMapEq() == null) {
                    current = this.proccessMap(current, currentNode.getMap());
                } else if (!mapEqIsProcessed) {
                    if (current instanceof Iterable) {
                        Iterable list = (Iterable)current;
                        current = this.findInIterable(list, currentNode.getMapEq(), currentNode.getMap(), current, null);
                    } else {
                        throw new GwtFinderException("Not managed type for iteration " + current.getClass().getCanonicalName());
                    }
                }
            }
            if (ok) continue;
            return null;
        }
        return (T)current;
    }

    private <T> T findInternal(String ... params) {
        for (ObjectFinder customObjectFinder : this.customObjectFinders) {
            if (!customObjectFinder.accept(params)) continue;
            return (T)customObjectFinder.find(params);
        }
        if (this.indexedObjectFinder.accept(params)) {
            return (T)this.indexedObjectFinder.find(params);
        }
        if (this.defaultObjectFinder.accept(params)) {
            return (T)this.defaultObjectFinder.find(params);
        }
        throw new GwtFinderException("No registered " + ObjectFinder.class.getSimpleName() + " instance can be used to find object with param: " + this.paramsToString(params));
    }

    private Field getField(Object fixture, Class<?> clazz, String fieldName) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equalsIgnoreCase(fieldName)) continue;
            GwtReflectionUtils.makeAccessible(f);
            return f;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            return this.getField(fixture, superClazz, fieldName);
        }
        return null;
    }

    private Object invoke(Object current, Method m, List<String> list) throws IllegalArgumentException, IllegalAccessException {
        GwtReflectionUtils.makeAccessible(m);
        if (list == null && m.getParameterTypes().length == 0) {
            try {
                return m.invoke(current, new Object[0]);
            }
            catch (InvocationTargetException e) {
                return null;
            }
        }
        Object[] tab = new Object[m.getParameterTypes().length];
        for (int index = 0; index < m.getParameterTypes().length; ++index) {
            if (m.getParameterTypes()[index] == String.class) {
                tab[index] = list.get(index);
                continue;
            }
            if (m.getParameterTypes()[index] == Integer.class || m.getParameterTypes()[index] == Integer.TYPE) {
                tab[index] = Integer.parseInt(list.get(index));
                continue;
            }
            throw new GwtFinderException("Error while calling method " + m.toGenericString() + ": Not managed type " + m.getParameterTypes()[index]);
        }
        try {
            return m.invoke(current, tab);
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private String paramsToString(String ... params) {
        StringBuilder sb = new StringBuilder();
        for (String param : params) {
            sb.append("'").append(param).append("', ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    private Object proccessMap(Object current, String map) {
        if (current instanceof Map) {
            Map m = (Map)current;
            current = m.get(map);
        } else if (current instanceof List) {
            List l = (List)current;
            current = l.get(Integer.parseInt(map));
        } else {
            throw new GwtFinderException("Object not a map " + current.getClass().getCanonicalName() + " : " + map);
        }
        return current;
    }

    private static class IndexedObjectFinder
    implements ObjectFinder {
        private final Map<String, Set<Object>> mapByHTML = new HashMap<String, Set<Object>>();
        private final Map<String, Object> mapById = new HashMap<String, Object>();
        private final Map<String, Set<Object>> mapByName = new HashMap<String, Set<Object>>();
        private final Map<String, Set<Object>> mapByText = new HashMap<String, Set<Object>>();

        IndexedObjectFinder() {
        }

        public boolean accept(String ... params) {
            return params.length == 1 && !params[0].trim().startsWith("/");
        }

        public Object find(String ... params) {
            String alias = params[0];
            Object result = this.findByAlias(alias);
            if (result != null) {
                return result;
            }
            int flag = alias.indexOf("/");
            if (flag == -1) {
                return null;
            }
            String introspectionPath = null;
            introspectionPath = alias.substring(flag);
            result = this.findByAlias(alias = alias.substring(0, flag));
            if (result == null) {
                return null;
            }
            return GwtFinder.find(result, Node.parse(introspectionPath));
        }

        private Object findByAlias(String alias) {
            Object result = this.mapById.get(alias);
            if (result != null) {
                return result;
            }
            Set<Object> byHTML = this.mapByHTML.get(alias);
            if (byHTML != null && byHTML.size() > 0) {
                if (byHTML.size() == 1) {
                    return byHTML.iterator().next();
                }
                throw new GwtFinderException("There are " + byHTML.size() + " Widgets matching HTML filter [" + alias + "]. You should use an unique identifier instead");
            }
            Set<Object> byText = this.mapByText.get(alias);
            if (byText != null && byText.size() > 0) {
                if (byText.size() == 1) {
                    return byText.iterator().next();
                }
                throw new GwtFinderException("There are " + byText.size() + " Widgets matching text filter [" + alias + "]. You should use an unique identifier instead");
            }
            Set<Object> byName = this.mapByText.get(alias);
            if (byName != null && byName.size() > 0) {
                if (byName.size() == 1) {
                    return byName.iterator().next();
                }
                throw new GwtFinderException("There are " + byName.size() + " Widgets matching name filter [" + alias + "]. You should use an unique identifier instead");
            }
            return null;
        }
    }

    private class DefaultObjectFinder
    implements ObjectFinder {
        private final Map<String, NodeObjectFinder> nodeObjectFinders = new HashMap<String, NodeObjectFinder>();

        DefaultObjectFinder() {
        }

        public boolean accept(String ... params) {
            return params.length == 1 && params[0].matches("^/\\w+/.*$");
        }

        public Object find(String ... params) {
            Node node = Node.parse(params[0]);
            if (node == null) {
                throw new GwtFinderException("Cannot parse search string to a valid Node : " + params[0]);
            }
            String prefix = node.getLabel();
            NodeObjectFinder finder = this.nodeObjectFinders.get(prefix);
            if (finder == null) {
                throw new GwtFinderException("Unknown node prefix '" + prefix + "'. You must register your own " + NodeObjectFinder.class.getSimpleName() + " instance for this prefix through the " + GwtFinder.class.getSimpleName() + ".registerNodeFinder(..) method");
            }
            return finder.find(node.getNext());
        }
    }
}

