/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.internal.AfterTestCallback;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AfterTestCallbackManager {
    private static final AfterTestCallbackManager INSTANCE = new AfterTestCallbackManager();
    private final Set<AfterTestCallback> callbacks = new HashSet<AfterTestCallback>();
    private final Set<AfterTestCallback> finalCallbacks = new HashSet<AfterTestCallback>();
    private final Set<AfterTestCallback> removeableCallbacks = new HashSet<AfterTestCallback>();

    public static AfterTestCallbackManager get() {
        return INSTANCE;
    }

    private AfterTestCallbackManager() {
    }

    public boolean registerCallback(AfterTestCallback callback) {
        return this.callbacks.add(callback);
    }

    public boolean registerFinalCallback(AfterTestCallback finalCallback) {
        return this.finalCallbacks.add(finalCallback);
    }

    public boolean registerRemoveableCallback(AfterTestCallback removeableCallback) {
        return this.removeableCallbacks.add(removeableCallback);
    }

    public List<Throwable> triggerCallbacks() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (AfterTestCallback callback : this.callbacks) {
            this.executeCallback(callback, throwables);
        }
        for (AfterTestCallback callback : this.removeableCallbacks) {
            this.executeCallback(callback, throwables);
        }
        for (AfterTestCallback callback : this.finalCallbacks) {
            this.executeCallback(callback, throwables);
        }
        this.removeableCallbacks.clear();
        return throwables;
    }

    public boolean unregisterCallback(AfterTestCallback callback) {
        return this.callbacks.remove(callback);
    }

    private void executeCallback(AfterTestCallback callback, List<Throwable> throwables) {
        try {
            callback.afterTest();
        }
        catch (Throwable t) {
            throwables.add(t);
        }
    }
}

